package extras

/**
 *  Apply some transformation f to every element of some list.
 *    Effectively, given a function f and a list = [x1, x2, ...]
 *    then the new list = [f(x1), f(x2), ...].
 */

def map(f, list) {
    return list.collect(f)
}

def twice = { x -> return 2 * x }

println "map: ${map(twice, [1, 2, 3, 4])}"
println "map: ${map(twice, [])}"

def res = map({ x -> return 3 * x }, [1, 2, 3, 4])
println "res: ${res}"
  