package extras

/**
 *  Select all those elements from a list that match some criteria (predicate).
 */

def filter(predicate, list) {
    return list.findAll(predicate)
}

def isLessThan = { x, y -> return (y < x) }	// NOTE ordering of parameters
def isNegative = isLessThan.curry(0)		// isNegative = { y -> return (y < 0) }
def isUnderTen = isLessThan.curry(10)		// isUnderten = { y -> return (y < 10) }

println "filter: ${filter(isNegative, [1, -1, -2, 3, 4])}"
println "filter: ${filter(isUnderTen, [1, 5, 11, 8, 12])}"
