package extras

/**
 *  Composition and currying can lead to many useful closure definitions
 *    that can be combined in countless ways to produce problem solutions.
 */

def filter = { predicate, list ->
    return list.findAll(predicate)
}

def isEqual = { x, y -> return (x == y) }
def remainder = { x, y -> return (y % x) }

def composition = { f, g, x -> return f(g(x)) }

def filterEvens = filter.curry(composition.curry(isEqual.curry(0), remainder.curry(2)))

println "filterEvens: ${filterEvens([1, 2, 3, 4, 5, 6])}"
