/**
 *  A Library consists of a collection of Book objects. The Library
 *    carries a name while each Book has a title and an author.
 */

class Book {

    public String toString() {
        return "Book: ${title}, ${author}"
    }
    
// ---------- properties ------------------------------

    def title
    def author
}

class Library {
    
    public Object invokeMethod(String methodName, Object args) {
        if(methodName == 'addBook')
            return this.addBook(args)
        else
            return findByAuthor(methodName)
    }

    private addBook(title, author) {
        bookStock << new Book(title : title, author : author)
    }
    
    private findByAuthor(pattern) {
        return bookStock.findAll { bk -> bk.author =~ pattern }
    }
    
// ---------- properties -------------------------------

    def name
    def bookStock = []	// of Book objects
}

def lib = new Library(name : 'PUBLIC')
lib.addBook('Groovy', 'Ken Barclay')
lib.addBook('UML', 'John Savage')
lib.addBook('CSP', 'Jon Kerridge')

println "Jo: ${lib.Jo()}"
