package events
import org.hibernate.*
import org.hibernate.criterion.Expression

import java.util.*

import util.HibernateUtil

class EventManager {

    static main(args) {
        def mgr = new EventManager()

        if (args[0] == "store") {
            mgr.createAndStoreEvent("My Event", new Date())
        }
        else if (args[0] == "list") {
            def events = mgr.listEvents()
            events.each { event ->
                println "Event: ${event.title}; Time: ${event.date}"
            }
            //for (int i = 0; i < events.size(); i++) {
            //    Event theEvent = (Event) events.get(i)
            //    System.out.println("Event: " + theEvent.getTitle() +
            //                       " Time: " + theEvent.getDate())
            //}
        }
        else if (args[0] == "addpersontoevent") {
            def eventId = mgr.createAndStoreEvent("My Event", new Date())
            def personId = mgr.createAndStorePerson("Foo", "Bar")
            mgr.addPersonToEvent(personId, eventId)
            println "Added person: ${personId} to event: ${eventId}"
            //System.out.println("Added person " + personId + " to event " + eventId)
        }
        else if (args[0] == "addemailtoperson") {
            def personId = mgr.createAndStorePerson("Foozy", "Beary")
            mgr.addEmailToPerson(personId, "foo@bar")
            mgr.addEmailToPerson(personId, "bar@foo")
            println "Added two email addresses (value typed objects) to person entity : ${personId}"
            //System.out.println("Added two email addresses (value typed objects) to person entity : " + personId)
        }

        HibernateUtil.getSessionFactory().close()
    }
    
    
    
    def createAndStoreEvent(title, theDate) {

        def session = HibernateUtil.getSessionFactory().getCurrentSession()
        session.beginTransaction()

        def theEvent = new Event()
        theEvent.setTitle(title)
        theEvent.setDate(theDate)

        session.save(theEvent)

        session.getTransaction().commit()

        return theEvent.getId()
    }
    
    
    
    def createAndStorePerson(firstname, lastname) {

        def session = HibernateUtil.getSessionFactory().getCurrentSession()
        session.beginTransaction()

        def thePerson = new Person()
        thePerson.setFirstname(firstname)
        thePerson.setLastname(lastname)

        session.save(thePerson)

        session.getTransaction().commit()

        return thePerson.getId()
    }
    
    
    
    def listEvents() {

        def session = HibernateUtil.getSessionFactory().getCurrentSession()
        session.beginTransaction()

        def result = session.createQuery("from Event").list()

        session.getTransaction().commit()

        return result
    }
    
    
    
    private void addPersonToEvent(personId, eventId) {

        def session = HibernateUtil.getSessionFactory().getCurrentSession()
        session.beginTransaction()

        def aPerson = (Person) session
                .createQuery("select p from Person p left join fetch p.events where p.id = :pid")
                .setParameter("pid", personId)
                .uniqueResult() // Eager fetch the collection so we can use it detached

        def anEvent = (Event) session.load(Event.class, eventId)
        // If we want to handle it bidirectional and detached, we also need to load this
        // collection with an eager outer-join fetch, this time with Criteria and not HQL:
        /*
        Event anEvent = (Event) session
                .createCriteria(Event.class).setFetchMode("participants", FetchMode.JOIN)
                .add( Expression.eq("id", eventId) )
                .uniqueResult(); // Eager fetch the colleciton so we can use it detached
        */

        session.getTransaction().commit()

        // End of first unit of work

        aPerson.getEvents().add(anEvent) // aPerson is detached
        // or bidirectional safety method, setting both sides: aPerson.addToEvent(anEvent);

        // Begin second unit of work

        def session2 = HibernateUtil.getSessionFactory().getCurrentSession()
        session2.beginTransaction()

        session2.update(aPerson) // Reattachment of aPerson

        session2.getTransaction().commit()
    }
    
    
    
    def addEmailToPerson(personId, emailAddress) {

        def session = HibernateUtil.getSessionFactory().getCurrentSession()
        session.beginTransaction()

        def aPerson = (Person) session.load(Person.class, personId)

        // The getEmailAddresses() might trigger a lazy load of the collection
        aPerson.getEmailAddresses().add(emailAddress)

        session.getTransaction().commit()
    }
}
