/**
 *  A category to augment the String class with the method isUSSSN to
 *    determine if a string represents a US social security number.
 */

class StringCategory {

    static boolean isUSSSN(String text) {
        return text =~ '([0-9]{3})-([0-9]{2})-([0-9]{4})'
    }
}

use(StringCategory.class) {
    def usgood = '123-45-6789'
    def usbad = '12-345-6789'
    
    println "usgood: ${usgood.isUSSSN()}"
    println "usbad: ${usbad.isUSSSN()}"
}
