/**
 *  Each proxy instance has an associated invocation handler. When a method
 *    is invoked on a proxy instance, the method invocation is encoded and
 *    dispatched to the invoke method of its invocation handler.
 */

import java.lang.reflect.*

class ClosureHandler implements InvocationHandler {

    protected ClosureHandler(clos) {
        this.clos = clos
    }
    
    /**
     *  OVERIDE
     *  Processes a method invocation on a proxy instance and returns the result.
     *    This method will be invoked on an invocation handler when a method is
     *    invoked on a proxy instance that it is associated with.
     *
     *  @param proxy		the proxy instance that the method was invoked on (ignored)
     *  @param method	the Method instance corresponding to the interface method invoked on the proxy instance
     *  @param args		an array of objects containing the values of the arguments passed in the method invocation on the proxy instance
     *
     *  @return		the value to return from the method invocation on the proxy instance
     */
    public Object invoke(Object proxy, Method method, Object[] args) {
        if(method.getDeclaringClass().equals(Object.class))		// superclass method?
            return method.invoke(this, args)
        else
            return clos.call(args)
    }
    
    /**
     *  Create a dynamic proxy to adapt a closure to a set of interfaces.
     */
    public static Object proxyClosure(Closure clos, ClassLoader cLoader, Class[] interfaces) {
        return Proxy.newProxyInstance(cLoader, interfaces, new ClosureHandler(clos))
    }
    
    /**
     *  Create a dynamic proxy to adapt a closure to an interface.
     */
    public static Object proxyClosure(Closure clos, Class interf) {
        return proxyClosure(clos, clos.getClass().getClassLoader(), [interf] as Class[])
    }
    
// ---------- properties ----------------------------------

    def clos					// Closure
}
