/**
 *  We define a closure that effectively implements some interface.
 *    We then invoke the closure through a proxy.
 */

interface Calculator {

    def add(a, b)
}

def clos = {x, y -> return x + y }

use(ClosureCategory.class) {
    def prox = Calculator.implement(clos)
    println "Proxy: ${prox.add(3, 4)}"
}
