/**
 *  Using asType to convert a closure to act as an instance of an interface.
 *    Here, the interface is introduced with three methods with differing number
 *    of parameters.
 */

interface CalculatorIF {

    def abstract add(x, y)
    def abstract sub(x, y)
    def abstract inv(x)
}

def calc = {Object[] args -> println "closure called with args: ${args}"}.asType(CalculatorIF)
calc.add(3, 4)
calc.sub(5, 6)
calc.inv(4)
