/**
 *  Using asType to convert a closure to act as an instance of an interface.
 *    Here, the interface is introduced with three methods with differing number
 *    of parameters. The instance is created with a Map.
 */

interface CalculatorIF {

    def abstract add(x, y)
    def abstract sub(x, y)
    def abstract inv(x)
}

def calc = [add : {x, y -> return x + y},
            sub : {x, y -> return x - y},
            inv : {x -> return 1/x}].asType(CalculatorIF)
println "add: ${calc.add(3, 4)}"
println "sub: ${calc.sub(5, 6)}"
println "inv: ${calc.inv(4)}"
