/**
 *  class:        Console
 *  date:         Monday 31 October 2005
 *  @author       Ken Barclay
 *  @version      1.0
 */

package ken

class Console {

    def static readLine() {
        return getNextLine()
    }

    def static readString() {
        return getNextToken()
    }
    
    def static readInteger() {
        return getNextToken().toInteger()
    }
    
    def static readDouble() {
        return getNextToken().toDouble()
    }
    
    def static readBoolean() {
        return (getNextToken() == "true")
    }
    
    private static String getNextToken() {
        if(inputLine == null)
            readInputLine()
        
        while(inputIndex == numberOfTokens)
            readInputLine()
            
        return inputTokens[inputIndex++]
    }
    
    private static String getNextLine() {
        if(inputLine == null)
            readInputLine()
        
        while(inputIndex == numberOfTokens)
            readInputLine()
            
        def line = inputTokens[inputIndex..<numberOfTokens].join(' ')
        inputIndex = numberOfTokens
        return line
    }
    
    private static void readInputLine() {
        inputLine = System.in.readLine()
        inputTokens = inputLine.tokenize()
        numberOfTokens = inputTokens.size()
        inputIndex = 0
    }

// ---------- properties ----------------------------------

    private static String inputLine	= null
    private static List inputTokens	= null
    private static int numberOfTokens	= 0
    private static int inputIndex	= -1
    
}
