<?php

/**********************************************************************
* Section 1 : pre-processing 
*********************************************************************/

  include ('include_fns.php');
  session_start();

  $action = $_GET['action'];
  $buttons = array();
  
  //append to this string if anything processed before header has output 
  $status = '';
   
  // need to process log in or out requests before anything else
  if($_POST['email']&&$_POST['password'])
  {
    $login = login($_POST['email'], $_POST['password']);
    
    if($login == 'admin')
    {
      $status .= "<p><b>".get_real_name($_POST['email']).
                 "</b> logged in"." successfully as <b>Administrator</b></p>
                  <br /><br /><br /><br /><br />";
      $_SESSION['admin_user'] = $_POST['email'];
    }
    else if($login == 'normal')
    {
      $status .= "<p><b>".get_real_name($_POST['email'])."</b> logged in"
                 ." successfully.</p><br /><br />";
      $_SESSION['normal_user'] = $_POST['email'];
    }
    else
    {
      $status .= "<p>Sorry, we could not log you in with that 
                  email address and password.</p><br />";
    }
  }

  if($action == 'log-out')
  {
    unset($action);
    $_SESSION=array();
    session_destroy();
  }

/**********************************************************************
* Section 2: set up and display headers 
*********************************************************************/

  // set the buttons that will be on the tool bar
  if(check_normal_user())
  {
    // if a normal user
    $buttons[0] = 'change-password';
    $buttons[1] = 'account-settings';
    $buttons[2] = 'show-my-lists';
    $buttons[3] = 'show-other-lists';
    $buttons[4] = 'log-out'; 
  }
  else if(check_admin_user())
  {
    // if an administrator
    $buttons[0] = 'change-password';
    $buttons[1] = 'create-list';
    $buttons[2] = 'create-mail';
    $buttons[3] = 'view-mail';
    $buttons[4] = 'log-out';
    $buttons[5] = 'show-all-lists';
    $buttons[6] = 'show-my-lists';
    $buttons[7] = 'show-other-lists';
  }
  else
  {
    // if not logged in at all
    $buttons[0] = 'new-account'; 
    $buttons[1] = 'show-all-lists';
    $buttons[4] = 'log-in';
  }
  
  if($action)
  {
    // display header with application name and description of page or action
    do_html_header('Pyramid-MLM - '.format_action($action));
  }
  else
  {
    // display header with just application name
    do_html_header('Pyramid-MLM');
  }
  
  display_toolbar($buttons);
  
  //display any text generated by functions called before header
  echo $status;

/**********************************************************************
* Section 3: perform action
*********************************************************************/

  // only these actions can be done if not logged in
  switch ( $action )
  {
    case 'new-account' :
    {
      // get rid of session variables
      session_destroy();
      display_account_form();   
      break;
    }
    case 'store-account' :
    {
      if (store_account($_SESSION['normal_user'], 
               $_SESSION['admin_user'], $_POST))
        $action = '';
      if(!check_logged_in())
        display_login_form($action);
      break;
    }
    case 'log-in' :
    case '':
    {
      if(!check_logged_in())
        display_login_form($action);
      break;
    }
    case 'show-all-lists' :
    {
      display_items('All Lists', get_all_lists(), 'information',
                    'show-archive','');
      break;
    }
    case 'show-archive' :
    {
      display_items('Archive For '.get_list_name($_GET['id']), 
                     get_archive($_GET['id']), 'view-html', 
                    'view-text', '');
      break;
    }
    case 'information' :
    {
      display_information($_GET['id']);
      break;
    }
    
  }
  
  //all other actions require user to be logged in
  if(check_logged_in())
  {
    switch ( $action )
    {
      case 'account-settings' :
      {
        display_account_form(get_email(), 
              get_real_name(get_email()), get_mimetype(get_email()));   
        break;
      }
      case 'show-other-lists' :
      {
        display_items('Unsubscribed Lists', 
                      get_unsubscribed_lists(get_email()), 'information', 
                      'show-archive', 'subscribe');
        break;
      }
      case 'subscribe' :
      {
        subscribe(get_email(), $_GET['id']);
        display_items('Subscribed Lists', get_subscribed_lists(get_email()),
                        'information', 'show-archive', 'unsubscribe');
        break;
      }
      case 'unsubscribe' :
      {
        unsubscribe(get_email(), $_GET['id']);
        display_items('Subscribed Lists', get_subscribed_lists(get_email()),
                      'information', 'show-archive', 'unsubscribe');
        break;
      }
      case '':
      case 'show-my-lists' :
      {               
        display_items('Subscribed Lists', get_subscribed_lists(get_email()), 
                     'information', 'show-archive', 'unsubscribe');
        break;
      }
      case 'change-password' :
      {               
        display_password_form();
        break;
      }
      case 'store-change-password' :
      {               
        if(change_password(get_email(), $_POST['old_passwd'], 
           $_POST['new_passwd'], $_POST['new_passwd2']))
        {
          echo '<p>OK: Password changed.</p>
                <br /><br /><br /><br /><br /><br />';
        }
        else
        {
          echo '<p>Sorry, your password could not be changed.</p>';
          display_password_form();
        } 
        break;
      }
    }
  }
  // The following actions may only be performed by an admin user
  if(check_admin_user())
  {
    switch ( $action )
    {
      case 'create-mail' :
      {
        display_mail_form(get_email());   
        break;
      }
      case 'create-list' :
      {
        display_list_form(get_email());   
        break;
      }
      case 'store-list' :
      {
        if(store_list($_SESSION['admin_user'], $_POST))
        {
          echo '<p>New list added</p><br />';
          display_items('All Lists', get_all_lists(), 'information', 
                        'show-archive','');
        }
        else     
          echo '<p>List could not be stored, please try ' 
               .'again.</p><br /><br /><br /><br /><br />';  
                
        break;
      }
      case 'send' :
      {
        send($_GET['id'], $_SESSION['admin_user']);   
        break;
      }
      case 'view-mail' :
      {
        display_items('Unsent Mail', get_unsent_mail(get_email()), 
                      'preview-html', 'preview-text', 'send');
        break;
      }
    }
  } 

/**********************************************************************
* Section 4: display footer 
*********************************************************************/

  do_html_footer();
?> 
