/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import org.postgresql.core.PGStream;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.V3ParameterList;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.StreamWrapper;

class SimpleParameterList
implements V3ParameterList {
    private static final int IN = 1;
    private static final int OUT = 2;
    private static final int INOUT = 3;
    private final Object[] paramValues;
    private final int[] paramTypes;
    private final int[] direction;
    private final byte[][] encoded;
    private static final Object NULL_OBJECT = new Object();

    SimpleParameterList(int paramCount) {
        this.paramValues = new Object[paramCount];
        this.paramTypes = new int[paramCount];
        this.encoded = new byte[paramCount][];
        this.direction = new int[paramCount];
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int n = index - 1;
        this.direction[n] = this.direction[n] | 2;
    }

    private void bind(int index, Object value, int oid) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.encoded[--index] = null;
        this.paramValues[index] = value;
        int n = index;
        this.direction[n] = this.direction[n] | 1;
        if (oid == 0 && this.paramTypes[index] != 0 && value == NULL_OBJECT) {
            return;
        }
        this.paramTypes[index] = oid;
    }

    @Override
    public int getParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public int getOutParameterCount() {
        int count = 0;
        int i = this.paramTypes.length;
        while (--i >= 0) {
            if ((this.direction[i] & 2) != 2) continue;
            ++count;
        }
        if (count == 0) {
            count = 1;
        }
        return count;
    }

    @Override
    public int getInParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction[i] == 2) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setIntParameter(int index, int value) throws SQLException {
        byte[] data = new byte[4];
        data[3] = (byte)value;
        data[2] = (byte)(value >> 8);
        data[1] = (byte)(value >> 16);
        data[0] = (byte)(value >> 24);
        this.bind(index, data, 23);
    }

    @Override
    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid);
    }

    @Override
    public void setStringParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid);
    }

    @Override
    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 17);
    }

    @Override
    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 17);
    }

    @Override
    public void setNull(int index, int oid) throws SQLException {
        this.bind(index, NULL_OBJECT, oid);
    }

    @Override
    public String toString(int index) {
        if (this.paramValues[--index] == null) {
            return "?";
        }
        if (this.paramValues[index] == NULL_OBJECT) {
            return "NULL";
        }
        return this.paramValues[index].toString();
    }

    @Override
    public void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction[i] == 2 || this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("No value specified for parameter {0}.", new Integer(i + 1)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    private static void streamBytea(PGStream pgStream, StreamWrapper wrapper) throws IOException {
        byte[] rawData = wrapper.getBytes();
        if (rawData != null) {
            pgStream.Send(rawData, wrapper.getOffset(), wrapper.getLength());
            return;
        }
        pgStream.SendStream(wrapper.getStream(), wrapper.getLength());
    }

    @Override
    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(int index) {
        if (this.direction[index - 1] == 2) {
            this.paramTypes[index - 1] = 2278;
            this.paramValues[index - 1] = "null";
        }
        return this.paramTypes[index - 1];
    }

    boolean hasUnresolvedTypes() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.paramTypes[i] != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(int index, int oid) {
        if (this.paramTypes[index - 1] == 0) {
            this.paramTypes[index - 1] = oid;
        } else if (this.paramTypes[index - 1] != oid) {
            throw new IllegalArgumentException("Can't change resolved type for param: " + index + " from " + this.paramTypes[index] + " to " + oid);
        }
    }

    boolean isNull(int index) {
        return this.paramValues[index - 1] == NULL_OBJECT;
    }

    boolean isBinary(int index) {
        return this.paramValues[index - 1] instanceof StreamWrapper;
    }

    int getV3Length(int index) {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't getV3Length() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            return ((byte[])this.paramValues[index]).length;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            return ((StreamWrapper)this.paramValues[index]).getLength();
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encodeUTF8(this.paramValues[index].toString());
        }
        return this.encoded[index].length;
    }

    void writeV3Value(int index, PGStream pgStream) throws IOException {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't writeV3Value() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            pgStream.Send((byte[])this.paramValues[index]);
            return;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            SimpleParameterList.streamBytea(pgStream, (StreamWrapper)this.paramValues[index]);
            return;
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encodeUTF8((String)this.paramValues[index]);
        }
        pgStream.Send(this.encoded[index]);
    }

    @Override
    public ParameterList copy() {
        SimpleParameterList newCopy = new SimpleParameterList(this.paramValues.length);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, newCopy.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.direction, 0, newCopy.direction, 0, this.direction.length);
        return newCopy;
    }

    @Override
    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill((Object[])this.encoded, null);
        Arrays.fill(this.direction, 0);
    }

    @Override
    public SimpleParameterList[] getSubparams() {
        return null;
    }
}

