class SubscriberController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ subscriberList: Subscriber.list( params ) ]
    }

    def show = {
        def subscriber = Subscriber.get( params.id )

        if(!subscriber) {
            flash.message = "Subscriber not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ subscriber : subscriber ] }
    }

    def delete = {
        def subscriber = Subscriber.get( params.id )
        if(subscriber) {
            subscriber.delete()
            flash.message = "Subscriber ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "Subscriber not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def subscriber = Subscriber.get( params.id )

        if(!subscriber) {
            flash.message = "Subscriber not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ subscriber : subscriber ]
        }
    }

    def update = {
        def subscriber = Subscriber.get( params.id )
        if(subscriber) {
            subscriber.properties = params
            if(!subscriber.hasErrors() && subscriber.save()) {
                flash.message = "Subscriber ${params.id} updated"
                redirect(action:show,id:subscriber.id)
            }
            else {
                render(view:'edit',model:[subscriber:subscriber])
            }
        }
        else {
            flash.message = "Subscriber not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def subscriber = new Subscriber()
        subscriber.properties = params
        return ['subscriber':subscriber]
    }

    def save = {
        def subscriber = new Subscriber(params)
        if(!subscriber.hasErrors() && subscriber.save()) {
            flash.message = "Subscriber ${subscriber.id} created"
            redirect(action:show,id:subscriber.id)
        }
        else {
            render(view:'create',model:[subscriber:subscriber])
        }
    }
}
