create temporary table pgdump_restore_path(p text);
--
-- NOTE:
--
-- File paths need to be edited. Search for $$PATH$$ and
-- replace it with the path to the directory containing
-- the extracted data files.
--
-- Edit the following to match the path where the
-- tar archive has been extracted.
--
insert into pgdump_restore_path values('/tmp');

--
-- PostgreSQL database dump
--

SET client_encoding = 'SQL_ASCII';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

ALTER TABLE ONLY public.subscriber DROP CONSTRAINT subscriber_pkey;
DROP TABLE public.subscriber;
DROP SEQUENCE public.hibernate_sequence;
DROP SCHEMA public;
--
-- Name: public; Type: SCHEMA; Schema: -; Owner: tdaly
--

CREATE SCHEMA public;


ALTER SCHEMA public OWNER TO tdaly;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: tdaly
--

COMMENT ON SCHEMA public IS 'Standard public schema';


--
-- Name: hibernate_sequence; Type: SEQUENCE; Schema: public; Owner: regperf
--

CREATE SEQUENCE hibernate_sequence
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.hibernate_sequence OWNER TO regperf;

--
-- Name: hibernate_sequence; Type: SEQUENCE SET; Schema: public; Owner: regperf
--

SELECT pg_catalog.setval('hibernate_sequence', 201, true);


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: subscriber; Type: TABLE; Schema: public; Owner: regperf; Tablespace: 
--

CREATE TABLE subscriber (
    id bigint NOT NULL,
    version bigint NOT NULL,
    address character varying(255) NOT NULL,
    renew_date timestamp without time zone NOT NULL,
    email character varying(255) NOT NULL,
    "location" character varying(255) NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE public.subscriber OWNER TO regperf;

--
-- Data for Name: subscriber; Type: TABLE DATA; Schema: public; Owner: regperf
--

COPY subscriber (id, version, address, renew_date, email, "location", name) FROM stdin;
\.
copy subscriber (id, version, address, renew_date, email, "location", name)  from '$$PATH$$/1507.dat' ;
--
-- Name: subscriber_pkey; Type: CONSTRAINT; Schema: public; Owner: regperf; Tablespace: 
--

ALTER TABLE ONLY subscriber
    ADD CONSTRAINT subscriber_pkey PRIMARY KEY (id);


--
-- Name: public; Type: ACL; Schema: -; Owner: tdaly
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM tdaly;
GRANT ALL ON SCHEMA public TO tdaly;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

