package org.andromda.timetracker.console;

import org.andromda.timetracker.ServiceLocator;
import org.andromda.timetracker.service.PeopleService;
import org.andromda.timetracker.vo.PersonVO;

public class TimeTrackerConsole {

    // ServiceLocator and Services
    private static ServiceLocator serviceLocator = null;
    private static PeopleService peopleService = null;

    public static void main(String[] args) {
        // Get services
        serviceLocator = ServiceLocator.instance();
        peopleService = serviceLocator.getPeopleService();

        // Create people
        PersonVO naresh = createPerson("nbhatia", "Naresh", "Bhatia");
        PersonVO louis = createPerson("lcoude", "Louis", "Coude");
        PersonVO john = createPerson("jsmith", "John", "Smith");

        // Fetch and show all objects created above
        PersonVO[] people = peopleService.getAllPeople();
        showPeople(people);
    }

    private static PersonVO createPerson(String username, String firstName, String lastName) {
        PersonVO person = new PersonVO(null, username, firstName, lastName);
        person.setId(peopleService.createPerson(person));
        System.out.println("Person " + person.getId() + " created - " + person.getUsername());
        return person;
    }

    private static void showPeople(PersonVO[] people) {
        System.out.println("People:");
        for (int i=0; i<people.length; i++) {
            System.out.println(
                people[i].getId() + ": " + people[i].getUsername() + " - " +
                people[i].getFirstName() + " " + people[i].getLastName());
        }
        System.out.println();
    }
}