// Name: UserDaoImpl.cs
// license-header cs merge-point
//
// This is only generated once! It will never be overwritten.
// You can (and have to!) safely modify it by hand.

using System;

using Iesi.Collections;

using Northwind.TimeTracker.VO;

namespace Northwind.TimeTracker.Domain
{
    /// <summary>
    /// @see MembershipExample.Domain.User
    /// </summary>
    public class UserDaoImpl : UserDaoBase
    {
        /// <summary>
        /// @see MembershipExample.Domain.IUserDao#ToUserVO(MembershipExample.Domain.User)
        /// </summary>
        public override UserVO ToUserVO(User entity)
        {
			if (entity == null) { return null; }
			string[] roles = new string[entity.Roles.Count];
			int i = 0;
			foreach (UserRole role in entity.Roles)
			{
				roles[i++] = role.Role.ToString();
			}
			UserVO userVO = new UserVO(entity.Id,
										entity.UserName,
										entity.Email,
										entity.IsActive,
										entity.Comment,
										entity.CreationDate,
										roles);
            return userVO;
        }

        /// <summary>
        /// @see MembershipExample.Domain.IUserDao#UserVOToEntity(MembershipExample.VO.UserVO)
        /// </summary>
        public override User UserVOToEntity(UserVO userVO)
        {
			if (userVO == null) { return null; }
			// VO to entity conversion
			User entity = User.Factory.newInstance();

			entity.Id = userVO.Id;
			entity.UserName = userVO.UserName;
			entity.Email = userVO.Email;
			entity.IsActive = userVO.IsActive;
			entity.Comment = userVO.Comment;
			entity.CreationDate = userVO.CreationDate;

			return entity;

        }

    }
}
