// Name: MembershipServiceBase.cs
// license-header cs merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: NSpringServiceBase.vsl in andromda-nspring-cartridge.

using System;
using AndroMDA.NHibernateSupport;

namespace Northwind.TimeTracker.Service
{
    /// <summary>
    /// <p>
    /// Spring Service base class for <code>Northwind.TimeTracker.Service.MembershipService</code>,
    /// provides access to all services and entities referenced by this service.
    /// </p>
    ///
    /// @see Northwind.TimeTracker.Service.MembershipService
    /// </summary>
    public abstract class MembershipServiceBase
        : Northwind.TimeTracker.Service.IMembershipService
    {
        private static readonly log4net.ILog log = log4net.LogManager.GetLogger(typeof(MembershipServiceBase));

        /// <summary>Property to access UserDao</summary>
        protected Northwind.TimeTracker.Domain.IUserDao UserDao
        {
            get { return Northwind.TimeTracker.Domain.DaoFactory.GetUserDao(); }
        }

        /// <summary>Property to access UserRoleDao</summary>
        protected Northwind.TimeTracker.Domain.IUserRoleDao UserRoleDao
        {
            get { return Northwind.TimeTracker.Domain.DaoFactory.GetUserRoleDao(); }
        }

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#ValidateUser(String, String)
        /// </summary>
        public Northwind.TimeTracker.VO.UserVO ValidateUser(String username, String password)
        {
            Northwind.TimeTracker.VO.UserVO result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleValidateUser(username, password);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #ValidateUser(String, String)}
        /// <summary>
        protected abstract Northwind.TimeTracker.VO.UserVO HandleValidateUser(String username, String password);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#CreateUser(Northwind.TimeTracker.VO.UserVO, String)
        /// </summary>
        public void CreateUser(Northwind.TimeTracker.VO.UserVO user, String password)
        {
            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                HandleCreateUser(user, password);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }
        }

        /// <summary>
        /// Performs the core logic for {@link #CreateUser(Northwind.TimeTracker.VO.UserVO, String)}
        /// <summary>
        protected abstract void HandleCreateUser(Northwind.TimeTracker.VO.UserVO user, String password);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#GetUser(long)
        /// </summary>
        public Northwind.TimeTracker.VO.UserVO GetUser(long userId)
        {
            Northwind.TimeTracker.VO.UserVO result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleGetUser(userId);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #GetUser(long)}
        /// <summary>
        protected abstract Northwind.TimeTracker.VO.UserVO HandleGetUser(long userId);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#GetUser(String)
        /// </summary>
        public Northwind.TimeTracker.VO.UserVO GetUser(String username)
        {
            Northwind.TimeTracker.VO.UserVO result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleGetUser(username);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #GetUser(String)}
        /// <summary>
        protected abstract Northwind.TimeTracker.VO.UserVO HandleGetUser(String username);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#GetAllUsers(int, int)
        /// </summary>
        public System.Collections.IList GetAllUsers(int pageIndex, int pageSize)
        {
            System.Collections.IList result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleGetAllUsers(pageIndex, pageSize);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #GetAllUsers(int, int)}
        /// <summary>
        protected abstract System.Collections.IList HandleGetAllUsers(int pageIndex, int pageSize);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#GetUserNameByEmail(String)
        /// </summary>
        public String GetUserNameByEmail(String email)
        {
            String result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleGetUserNameByEmail(email);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #GetUserNameByEmail(String)}
        /// <summary>
        protected abstract String HandleGetUserNameByEmail(String email);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#GetUserIdByUsername(String)
        /// </summary>
        public long GetUserIdByUsername(String username)
        {
            long result;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleGetUserIdByUsername(username);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #GetUserIdByUsername(String)}
        /// <summary>
        protected abstract long HandleGetUserIdByUsername(String username);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#UpdateUser(Northwind.TimeTracker.VO.UserVO)
        /// </summary>
        public void UpdateUser(Northwind.TimeTracker.VO.UserVO user)
        {
            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                HandleUpdateUser(user);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }
        }

        /// <summary>
        /// Performs the core logic for {@link #UpdateUser(Northwind.TimeTracker.VO.UserVO)}
        /// <summary>
        protected abstract void HandleUpdateUser(Northwind.TimeTracker.VO.UserVO user);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#UpdatePassword(String, String, String)
        /// </summary>
        public bool UpdatePassword(String username, String oldPassword, String newPassword)
        {
            bool result;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleUpdatePassword(username, oldPassword, newPassword);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #UpdatePassword(String, String, String)}
        /// <summary>
        protected abstract bool HandleUpdatePassword(String username, String oldPassword, String newPassword);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#DeleteUser(String)
        /// </summary>
        public void DeleteUser(String username)
        {
            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                HandleDeleteUser(username);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }
        }

        /// <summary>
        /// Performs the core logic for {@link #DeleteUser(String)}
        /// <summary>
        protected abstract void HandleDeleteUser(String username);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#FindUsersByEmail(String, int, int)
        /// </summary>
        public System.Collections.IList FindUsersByEmail(String emailToMatch, int pageIndex, int pageSize)
        {
            System.Collections.IList result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleFindUsersByEmail(emailToMatch, pageIndex, pageSize);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #FindUsersByEmail(String, int, int)}
        /// <summary>
        protected abstract System.Collections.IList HandleFindUsersByEmail(String emailToMatch, int pageIndex, int pageSize);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#FindUsersByName(String, int, int)
        /// </summary>
        public System.Collections.IList FindUsersByName(String usernameToMatch, int pageIndex, int pageSize)
        {
            System.Collections.IList result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleFindUsersByName(usernameToMatch, pageIndex, pageSize);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #FindUsersByName(String, int, int)}
        /// <summary>
        protected abstract System.Collections.IList HandleFindUsersByName(String usernameToMatch, int pageIndex, int pageSize);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#GetRolesForUser(long)
        /// </summary>
        public Northwind.TimeTracker.Domain.Role[] GetRolesForUser(long userId)
        {
            Northwind.TimeTracker.Domain.Role[] result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleGetRolesForUser(userId);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #GetRolesForUser(long)}
        /// <summary>
        protected abstract Northwind.TimeTracker.Domain.Role[] HandleGetRolesForUser(long userId);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#GetRolesForUser(String)
        /// </summary>
        public Northwind.TimeTracker.Domain.Role[] GetRolesForUser(String username)
        {
            Northwind.TimeTracker.Domain.Role[] result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleGetRolesForUser(username);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #GetRolesForUser(String)}
        /// <summary>
        protected abstract Northwind.TimeTracker.Domain.Role[] HandleGetRolesForUser(String username);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#GetUsernamesInRole(Northwind.TimeTracker.Domain.Role)
        /// </summary>
        public String[] GetUsernamesInRole(Northwind.TimeTracker.Domain.Role role)
        {
            String[] result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleGetUsernamesInRole(role);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #GetUsernamesInRole(Northwind.TimeTracker.Domain.Role)}
        /// <summary>
        protected abstract String[] HandleGetUsernamesInRole(Northwind.TimeTracker.Domain.Role role);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#FindUsernamesInRole(Northwind.TimeTracker.Domain.Role, String)
        /// </summary>
        public String[] FindUsernamesInRole(Northwind.TimeTracker.Domain.Role role, String usernameToMatch)
        {
            String[] result = null;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleFindUsernamesInRole(role, usernameToMatch);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #FindUsernamesInRole(Northwind.TimeTracker.Domain.Role, String)}
        /// <summary>
        protected abstract String[] HandleFindUsernamesInRole(Northwind.TimeTracker.Domain.Role role, String usernameToMatch);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#IsUserInRole(Northwind.TimeTracker.VO.UserVO, Northwind.TimeTracker.Domain.Role)
        /// </summary>
        public bool IsUserInRole(Northwind.TimeTracker.VO.UserVO user, Northwind.TimeTracker.Domain.Role role)
        {
            bool result;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleIsUserInRole(user, role);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #IsUserInRole(Northwind.TimeTracker.VO.UserVO, Northwind.TimeTracker.Domain.Role)}
        /// <summary>
        protected abstract bool HandleIsUserInRole(Northwind.TimeTracker.VO.UserVO user, Northwind.TimeTracker.Domain.Role role);

        /// <summary>
        /// @see Northwind.TimeTracker.Service.MembershipService#IsUserInRole(String, Northwind.TimeTracker.Domain.Role)
        /// </summary>
        public bool IsUserInRole(String username, Northwind.TimeTracker.Domain.Role role)
        {
            bool result;

            SessionManagerFactory.SessionManager.HandleSessionStart();
            SessionManagerFactory.SessionManager.BeginTransaction();
            try
            {
                result = HandleIsUserInRole(username, role);
                SessionManagerFactory.SessionManager.CommitTransaction();
            }
            catch (Exception ex)
            {
                SessionManagerFactory.SessionManager.RollbackTransaction();
                log.Error(ex);
                throw;
            }
            finally
            {
                SessionManagerFactory.SessionManager.HandleSessionEnd();
            }

            return result;
        }

        /// <summary>
        /// Performs the core logic for {@link #IsUserInRole(String, Northwind.TimeTracker.Domain.Role)}
        /// <summary>
        protected abstract bool HandleIsUserInRole(String username, Northwind.TimeTracker.Domain.Role role);

    }
}
