/*
 * Decompiled with CFR 0.152.
 */
package com.mosso.client.cloudfiles.sample;

import com.mosso.client.cloudfiles.FilesAuthorizationException;
import com.mosso.client.cloudfiles.FilesClient;
import com.mosso.client.cloudfiles.FilesContainerNotEmptyException;
import com.mosso.client.cloudfiles.FilesException;
import com.mosso.client.cloudfiles.FilesNotFoundException;
import com.mosso.client.cloudfiles.FilesObject;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FilesRemove {
    private static final Logger logger = Logger.getLogger(FilesRemove.class);

    public static void main(String[] args) throws NoSuchAlgorithmException, FilesException {
        Options options = FilesRemove.addCommandLineOptions();
        if (args.length <= 0) {
            FilesRemove.printHelp(options);
        }
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                FilesRemove.printHelp(options);
                System.exit(0);
            }
            if (line.hasOption("container")) {
                String containerName = null;
                containerName = line.getOptionValue("container");
                FilesRemove.removeContainer(containerName, line.hasOption('r'));
            }
            if (line.hasOption("object")) {
                String ObjectNameWithPath = null;
                ObjectNameWithPath = line.getOptionValue("object");
                FilesRemove.removeObject(ObjectNameWithPath);
            }
        }
        catch (ParseException err) {
            logger.fatal((Object)("Parsing exception on the command line: " + (Object)((Object)err)));
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
            err.printStackTrace(System.err);
        }
        catch (IOException err) {
            logger.fatal((Object)("IOException : " + err));
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
        }
    }

    private static void removeObject(String objectNameWithPath) throws HttpException, IOException, FilesException {
        int firstSlashLocation;
        if (!StringUtils.isNotBlank((String)objectNameWithPath)) {
            System.err.println("You must provide a valid value for the  Object name and path !");
            System.exit(0);
        }
        if ((firstSlashLocation = objectNameWithPath.indexOf(47)) > -1) {
            String container = objectNameWithPath.substring(0, firstSlashLocation - 1);
            String object = objectNameWithPath.substring(firstSlashLocation + 1);
            FilesClient client = new FilesClient();
            if (client.login()) {
                client.deleteObject(container, object);
            } else {
                System.err.println("Failed to log in to Cloud FS");
                System.exit(-1);
            }
        } else {
            System.err.println("Please specify the object path in the form containerName/objectName");
            System.exit(-1);
        }
    }

    private static void removeContainer(String containerName, boolean recurse) throws HttpException, IOException, FilesAuthorizationException, FilesException {
        block9: {
            FilesClient client;
            if (!StringUtils.isNotBlank((String)containerName)) {
                System.out.println("You must provide a valid value for the  Container name !");
                logger.fatal((Object)"You must provide a valid value for the  Container name !");
                System.exit(0);
            }
            if ((client = new FilesClient()).login()) {
                if (recurse) {
                    List<FilesObject> objects = client.listObjects(containerName);
                    for (FilesObject obj : objects) {
                        client.deleteObject(containerName, obj.getName());
                    }
                }
                try {
                    if (client.deleteContainer(containerName)) {
                        System.out.println(containerName + " deleted");
                        System.exit(0);
                        break block9;
                    }
                    System.out.println(containerName + " was not deleted");
                    System.exit(-1);
                }
                catch (FilesNotFoundException fnfe) {
                    System.out.println(containerName + " not found !");
                    System.exit(0);
                }
                catch (FilesContainerNotEmptyException fcnee) {
                    System.out.println(containerName + " is not empty use -r !");
                    System.exit(0);
                }
            } else {
                System.out.println("Failed to login to  !");
            }
        }
        System.exit(0);
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Remove [-container] ContainerName [-rf]", options);
    }

    private static Options addCommandLineOptions() {
        Option help = new Option("help", "print this message");
        Option recurse = new Option("r", "Recursively go through the folders and files");
        OptionBuilder.withArgName((String)"container");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Name of  container to remove.");
        Option container = OptionBuilder.create((String)"container");
        OptionBuilder.withArgName((String)"object");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Name and path of  object to remove.");
        Option object = OptionBuilder.create((String)"object");
        Options options = new Options();
        options.addOption(help);
        options.addOption(recurse);
        options.addOption(container);
        options.addOption(object);
        return options;
    }
}

