/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Keychain;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractLoginController
implements LoginController {
    private static Logger log = Logger.getLogger(AbstractLoginController.class);
    private boolean persisted;

    public void check(Host host) throws LoginCanceledException {
        this.check(host, null);
    }

    public void check(Host host, String message) throws LoginCanceledException {
        Credentials credentials;
        StringBuffer reason = new StringBuffer();
        if (StringUtils.isNotBlank((String)message)) {
            reason.append(message).append(". ");
        }
        if ((credentials = host.getCredentials()).isPublicKeyAuthentication()) {
            return;
        }
        if (!credentials.isValid()) {
            String title = Locale.localizedString("Login with username and password", "Credentials");
            if (StringUtils.isNotBlank((String)credentials.getUsername())) {
                if (Preferences.instance().getBoolean("connection.login.useKeychain")) {
                    String passFromKeychain = this.find(host);
                    if (StringUtils.isBlank((String)passFromKeychain)) {
                        reason.append(Locale.localizedString("No login credentials could be found in the Keychain", "Credentials"));
                        this.prompt(host, title, reason.toString());
                    } else {
                        this.persisted = true;
                        credentials.setPassword(passFromKeychain);
                    }
                } else {
                    reason.append(Locale.localizedString("The use of the Keychain is disabled in the Preferences", "Credentials"));
                    this.prompt(host, title, reason.toString());
                }
            } else {
                reason.append(Locale.localizedString("No login credentials could be found in the Keychain", "Credentials"));
                this.prompt(host, title, reason.toString());
            }
        }
    }

    public void success(Host host) {
        if (this.persisted) {
            log.info((Object)"Password already persisted in Keychain");
            return;
        }
        this.save(host);
    }

    public void fail(Host host, String reason) throws LoginCanceledException {
        this.persisted = false;
        this.prompt(host, Locale.localizedString("Login failed", "Credentials"), reason);
    }

    public String find(Host host) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Fetching password from Keychain:" + host));
        }
        if (StringUtils.isEmpty((String)host.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        if (StringUtils.isEmpty((String)host.getCredentials().getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        String p = Keychain.instance().getInternetPasswordFromKeychain(host.getProtocol().getScheme(), host.getPort(), host.getHostname(), host.getCredentials().getUsername());
        if (null == p && log.isInfoEnabled()) {
            log.info((Object)("Password not found in Keychain:" + host));
        }
        return p;
    }

    protected void save(Host host) {
        if (StringUtils.isEmpty((String)host.getHostname())) {
            log.warn((Object)"No hostname given");
            return;
        }
        if (StringUtils.isEmpty((String)host.getCredentials().getUsername())) {
            log.warn((Object)"No username given");
            return;
        }
        if (StringUtils.isEmpty((String)host.getCredentials().getPassword())) {
            log.warn((Object)"No password given");
            return;
        }
        if (host.getCredentials().isAnonymousLogin()) {
            log.info((Object)"Do not write anonymous credentials to Keychain");
            return;
        }
        if (!host.getCredentials().usesKeychain()) {
            log.info((Object)"Do not write credentials to Keychain");
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Add Password to Keychain:" + host));
        }
        Keychain.instance().addInternetPasswordToKeychain(host.getProtocol().getScheme(), host.getPort(), host.getHostname(), host.getCredentials().getUsername(), host.getCredentials().getPassword());
    }
}

