/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Preferences;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Credentials {
    private static Logger log = Logger.getLogger(Credentials.class);
    private String user;
    private transient String pass;
    private Local identity;
    private boolean shouldBeAddedToKeychain;

    public Credentials() {
        this(Preferences.instance().getProperty("connection.login.name"), null, Preferences.instance().getBoolean("connection.login.useKeychain"));
    }

    public Credentials(String user, String pass) {
        this(user, pass, Preferences.instance().getBoolean("connection.login.useKeychain"));
    }

    public Credentials(String user, String pass, boolean shouldBeAddedToKeychain) {
        this.shouldBeAddedToKeychain = shouldBeAddedToKeychain;
        this.init(user, pass);
    }

    private void init(String username, String password) {
        this.user = username;
        this.pass = password;
    }

    public String getUsername() {
        return this.user;
    }

    public void setUsername(String user) {
        this.user = user;
    }

    public String getPassword() {
        if (StringUtils.isEmpty((String)this.pass) && this.isAnonymousLogin()) {
            return Preferences.instance().getProperty("connection.login.anon.pass");
        }
        return this.pass;
    }

    public void setPassword(String pass) {
        this.pass = pass;
    }

    public void setUseKeychain(boolean shouldBeAddedToKeychain) {
        this.shouldBeAddedToKeychain = shouldBeAddedToKeychain;
    }

    public boolean usesKeychain() {
        return this.shouldBeAddedToKeychain;
    }

    public boolean isAnonymousLogin() {
        String user = this.getUsername();
        if (StringUtils.isEmpty((String)user)) {
            return false;
        }
        return Preferences.instance().getProperty("connection.login.anon.name").equals(user);
    }

    public boolean isPublicKeyAuthentication() {
        if (null == this.getIdentity()) {
            return false;
        }
        return this.getIdentity().exists();
    }

    public void setIdentity(Local file) {
        this.identity = file;
    }

    public Local getIdentity() {
        return this.identity;
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((String)this.getUsername()) && StringUtils.isNotEmpty((String)this.getPassword());
    }
}

