/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostCollection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.serializer.HostReaderFactory;
import ch.cyberduck.core.serializer.HostWriterFactory;
import ch.cyberduck.core.serializer.Reader;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class HistoryCollection
extends HostCollection {
    private static Logger log = Logger.getLogger(HistoryCollection.class);
    private static HistoryCollection HISTORY_COLLECTION = new HistoryCollection(LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "History"));

    public static HistoryCollection defaultCollection() {
        return HISTORY_COLLECTION;
    }

    public HistoryCollection(Local folder) {
        super(folder);
        folder.mkdir(true);
    }

    public Local getFile(Host bookmark) {
        return LocalFactory.createLocal(this.file, bookmark.getNickname() + ".duck");
    }

    public synchronized void add(int row, Host bookmark) {
        HostWriterFactory.instance().write(bookmark, this.getFile(bookmark));
        if (!this.contains(bookmark)) {
            super.add(row, bookmark);
        } else {
            this.sort();
        }
    }

    public synchronized Host remove(int row) {
        this.getFile(this.get(row)).delete(false);
        return super.remove(row);
    }

    public void load() {
        log.info((Object)("Reloading " + this.file));
        AttributedList<Local> bookmarks = this.file.childs(new PathFilter<Local>(){

            @Override
            public boolean accept(Local file) {
                return file.getName().endsWith(".duck");
            }
        });
        Reader<Host> reader = HostReaderFactory.instance();
        for (Local next : bookmarks) {
            super.add(this.size(), reader.read(next));
        }
    }

    protected void sort() {
        Collections.sort(this, new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                Local f1 = HistoryCollection.this.getFile(o1);
                Local f2 = HistoryCollection.this.getFile(o2);
                if (f1.attributes.getModificationDate() < f2.attributes.getModificationDate()) {
                    return 1;
                }
                if (f1.attributes.getModificationDate() > f2.attributes.getModificationDate()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public synchronized void clear() {
        log.debug((Object)("Removing all bookmarks from " + this.file));
        for (Host next : this) {
            this.getFile(next).delete(false);
        }
        super.clear();
    }

    public void save() {
    }

    protected Host unique(Host bookmark) {
        return bookmark;
    }

    public boolean allowsAdd() {
        return false;
    }

    public boolean allowsEdit() {
        return false;
    }
}

