/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Native;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.ibm.icu.text.IDNA;
import com.ibm.icu.text.StringPrepParseException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.spearce.jgit.transport.OpenSshConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Host
implements Serializable {
    private static Logger log = Logger.getLogger(Host.class);
    private Protocol protocol;
    private int port = -1;
    private String hostname;
    private String punycode;
    private String nickname;
    private String defaultpath;
    private Credentials credentials = new KnownHostsCredentials();
    private String encoding;
    private FTPConnectMode connectMode;
    private Integer maxConnections;
    private String downloadFolder;
    private TimeZone timezone;
    private String comment;
    private String webURL;
    private static boolean JNI_LOADED = false;
    private static OpenSshConfig config;

    public Host(String hostname) {
        this(Protocol.forName(Preferences.instance().getProperty("connection.protocol.default")), hostname);
    }

    public Host(String hostname, int port) {
        this(Protocol.getDefaultProtocol(port), hostname, port);
    }

    public Host(Protocol protocol, String hostname) {
        this(protocol, hostname, protocol.getDefaultPort());
    }

    public Host(Protocol protocol, String hostname, int port) {
        this(protocol, hostname, port, null);
    }

    public Host(Protocol protocol, String hostname, int port, String defaultpath) {
        this.setProtocol(protocol);
        this.setPort(port);
        this.setHostname(hostname);
        this.setDefaultPath(defaultpath);
    }

    public <T> Host(T dict) {
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        String urlObj;
        String commentObj;
        String timezoneObj;
        String downloadObj;
        String connObj;
        String connectModeObj;
        String encodingObj;
        String nicknameObj;
        String pathObj;
        String portObj;
        String keyObj;
        String usernameObj;
        String hostnameObj;
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        String protocolObj = dict.stringForKey("Protocol");
        if (protocolObj != null) {
            this.setProtocol(Protocol.forName(protocolObj.toString()));
        }
        if ((hostnameObj = dict.stringForKey("Hostname")) != null) {
            this.setHostname(hostnameObj.toString());
        }
        if ((usernameObj = dict.stringForKey("Username")) != null) {
            this.setCredentials(usernameObj.toString(), null);
        }
        if ((keyObj = dict.stringForKey("Private Key File")) != null) {
            this.getCredentials().setIdentity(LocalFactory.createLocal(keyObj.toString()));
        }
        if ((portObj = dict.stringForKey("Port")) != null) {
            this.setPort(Integer.parseInt(portObj.toString()));
        }
        if ((pathObj = dict.stringForKey("Path")) != null) {
            this.setDefaultPath(pathObj.toString());
        }
        if ((nicknameObj = dict.stringForKey("Nickname")) != null) {
            this.setNickname(nicknameObj.toString());
        }
        if ((encodingObj = dict.stringForKey("Encoding")) != null) {
            this.setEncoding(encodingObj.toString());
        }
        if ((connectModeObj = dict.stringForKey("FTP Connect Mode")) != null) {
            if (connectModeObj.toString().equals(FTPConnectMode.ACTIVE.toString())) {
                this.setFTPConnectMode(FTPConnectMode.ACTIVE);
            }
            if (connectModeObj.toString().equals(FTPConnectMode.PASV.toString())) {
                this.setFTPConnectMode(FTPConnectMode.PASV);
            }
        }
        if ((connObj = dict.stringForKey("Maximum Connections")) != null) {
            this.setMaxConnections(Integer.valueOf(connObj.toString()));
        }
        if ((downloadObj = dict.stringForKey("Download Folder")) != null) {
            this.setDownloadFolder(downloadObj.toString());
        }
        if ((timezoneObj = dict.stringForKey("Timezone")) != null) {
            this.setTimezone(TimeZone.getTimeZone(timezoneObj.toString()));
        }
        if ((commentObj = dict.stringForKey("Comment")) != null) {
            this.setComment(commentObj.toString());
        }
        if ((urlObj = dict.stringForKey("Web URL")) != null) {
            this.setWebURL(urlObj.toString());
        }
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setStringForKey(this.getProtocol().getIdentifier(), "Protocol");
        dict.setStringForKey(this.getNickname(), "Nickname");
        if (StringUtils.isNotBlank((String)this.getHostname())) {
            dict.setStringForKey(this.getHostname(), "Hostname");
        }
        dict.setStringForKey(String.valueOf(this.getPort()), "Port");
        if (StringUtils.isNotBlank((String)this.getCredentials().getUsername())) {
            dict.setStringForKey(this.getCredentials().getUsername(), "Username");
        }
        if (StringUtils.isNotBlank((String)this.getDefaultPath())) {
            dict.setStringForKey(this.getDefaultPath(), "Path");
        }
        if (StringUtils.isNotBlank((String)this.getEncoding())) {
            dict.setStringForKey(this.getEncoding(), "Encoding");
        }
        if (null != this.getCredentials().getIdentity()) {
            dict.setStringForKey(this.getCredentials().getIdentity().toURL(), "Private Key File");
        }
        if ((this.getProtocol().equals(Protocol.FTP) || this.getProtocol().equals(Protocol.FTP_TLS)) && null != this.getFTPConnectMode()) {
            if (this.getFTPConnectMode().equals(FTPConnectMode.ACTIVE)) {
                dict.setStringForKey(FTPConnectMode.ACTIVE.toString(), "FTP Connect Mode");
            } else if (this.getFTPConnectMode().equals(FTPConnectMode.PASV)) {
                dict.setStringForKey(FTPConnectMode.PASV.toString(), "FTP Connect Mode");
            }
        }
        if (null != this.getMaxConnections()) {
            dict.setStringForKey(String.valueOf(this.getMaxConnections()), "Maximum Connections");
        }
        if (!this.isDefaultDownloadFolder()) {
            dict.setStringForKey(this.getDownloadFolder().getAbbreviatedPath(), "Download Folder");
        }
        if (null != this.getTimezone()) {
            dict.setStringForKey(this.getTimezone().getID(), "Timezone");
        }
        if (StringUtils.isNotBlank((String)this.getComment())) {
            dict.setStringForKey(this.getComment(), "Comment");
        }
        if (!this.isDefaultWebURL()) {
            dict.setStringForKey(this.getWebURL(), "Web URL");
        }
        return dict.getSerialized();
    }

    public static Host parse(String input) {
        int cut;
        input = input.trim();
        int begin = 0;
        Protocol protocol = null;
        if (input.indexOf("://", begin) != -1 && null != (protocol = Protocol.forScheme(input.substring(begin, cut = input.indexOf("://", begin))))) {
            begin += cut - begin + 3;
        }
        if (null == protocol) {
            protocol = Protocol.forName(Preferences.instance().getProperty("connection.protocol.default"));
        }
        String username = null;
        String password = null;
        username = protocol.equals(Protocol.FTP) ? Preferences.instance().getProperty("connection.login.anon.name") : Preferences.instance().getProperty("connection.login.name");
        if (input.lastIndexOf(64) != -1) {
            if (input.indexOf(58, begin) != -1 && input.lastIndexOf(64) > input.indexOf(58, begin)) {
                cut = input.indexOf(58, begin);
                username = input.substring(begin, cut);
                cut = input.lastIndexOf(64);
                password = input.substring(begin += username.length() + 1, cut);
                begin += password.length() + 1;
            } else {
                cut = input.lastIndexOf(64);
                username = input.substring(begin, cut);
                begin += username.length() + 1;
            }
        }
        String hostname = Preferences.instance().getProperty("connection.hostname.default");
        if (StringUtils.isNotBlank((String)input)) {
            hostname = input.substring(begin, input.length());
        }
        String path = null;
        int port = protocol.getDefaultPort();
        if (input.indexOf(58, begin) != -1) {
            cut = input.indexOf(58, begin);
            hostname = input.substring(begin, cut);
            begin += hostname.length() + 1;
            try {
                String portString;
                if (input.indexOf(47, begin) != -1) {
                    portString = input.substring(begin, input.indexOf(47, begin));
                    begin += portString.length();
                    try {
                        path = URLDecoder.decode(input.substring(begin, input.length()), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)e.getMessage());
                    }
                } else {
                    portString = input.substring(begin, input.length());
                }
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Invalid port number given");
            }
        } else if (input.indexOf(47, begin) != -1) {
            cut = input.indexOf(47, begin);
            hostname = input.substring(begin, cut);
            begin += hostname.length();
            try {
                path = URLDecoder.decode(input.substring(begin, input.length()), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage());
            }
        }
        Host h = new Host(protocol, hostname, port, path);
        h.setCredentials(username, password);
        return h;
    }

    public void setDefaultPath(String defaultpath) {
        this.defaultpath = StringUtils.isNotBlank((String)defaultpath) ? defaultpath : null;
    }

    public String getDefaultPath() {
        return this.defaultpath;
    }

    public void setCredentials(String username, String password) {
        this.credentials.setUsername(username);
        this.credentials.setPassword(password);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setProtocol(Protocol protocol) {
        log.debug((Object)("setProtocol:" + protocol));
        Protocol protocol2 = this.protocol = protocol != null ? protocol : Protocol.forName(Preferences.instance().getProperty("connection.protocol.default"));
        if (!this.protocol.equals(Protocol.SFTP)) {
            this.getCredentials().setIdentity(null);
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getNickname() {
        if (null == this.nickname) {
            return this.getDefaultNickname();
        }
        return this.nickname;
    }

    private String getDefaultNickname() {
        return this.getHostname() + " \u2013 " + this.getProtocol().getName();
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getHostname() {
        return this.getHostname(false);
    }

    public String getHostname(boolean punycode) {
        if (punycode && Preferences.instance().getBoolean("connection.hostname.idn")) {
            if (null == this.punycode && StringUtils.isNotEmpty((String)this.hostname)) {
                try {
                    String idn = IDNA.convertIDNToASCII((String)this.hostname, (int)0).toString();
                    log.info((Object)("IDN hostname for " + this.hostname + ":" + idn));
                    this.punycode = idn;
                }
                catch (StringPrepParseException e) {
                    log.error((Object)("Cannot convert hostname to IDNA:" + e.getMessage()));
                }
            }
            if (StringUtils.isNotEmpty((String)this.punycode)) {
                return this.punycode;
            }
        }
        return this.hostname;
    }

    public void setHostname(String hostname) {
        log.debug((Object)("setHostname:" + hostname));
        this.hostname = hostname.trim();
        this.punycode = null;
    }

    public void setPort(int port) {
        this.port = port;
        if (-1 == port) {
            this.port = this.getProtocol().getDefaultPort();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setEncoding(String encoding) {
        log.debug((Object)("setEncoding:" + encoding));
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFTPConnectMode(FTPConnectMode connectMode) {
        log.debug((Object)("setFTPConnectMode:" + connectMode));
        this.connectMode = connectMode;
    }

    public FTPConnectMode getFTPConnectMode() {
        return this.connectMode;
    }

    public void setMaxConnections(Integer n) {
        log.debug((Object)("setMaxConnections:" + n));
        this.maxConnections = n;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setDownloadFolder(String folder) {
        log.debug((Object)("setDownloadFolder:" + folder));
        this.downloadFolder = LocalFactory.createLocal(folder).toURL();
    }

    public Local getDownloadFolder() {
        if (null == this.downloadFolder) {
            return LocalFactory.createLocal(Preferences.instance().getProperty("queue.download.folder"));
        }
        return LocalFactory.createLocal(this.downloadFolder);
    }

    public boolean isDefaultDownloadFolder() {
        return null == this.downloadFolder;
    }

    public void setTimezone(TimeZone timezone) {
        log.debug((Object)("setTimezone:" + timezone));
        this.timezone = timezone;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public String getWebURL() {
        if (null == this.webURL) {
            return this.getDefaultWebURL();
        }
        String protocol = "^http(s)?://.*$";
        if (!this.webURL.matches("^http(s)?://.*$")) {
            this.webURL = "http://" + this.webURL;
        }
        return this.webURL;
    }

    public boolean isDefaultWebURL() {
        return this.getWebURL().equals(this.getDefaultWebURL());
    }

    public String getDefaultWebURL() {
        return "http://" + this.getHostname();
    }

    public void setWebURL(String webURL) {
        this.webURL = webURL;
    }

    public String getIp() throws UnknownHostException {
        try {
            return InetAddress.getByName(this.hostname).toString();
        }
        catch (UnknownHostException e) {
            throw new UnknownHostException(this.hostname + " cannot be resolved");
        }
    }

    public String toString() {
        return this.toURL();
    }

    public String toURL() {
        if (this.getPort() == this.getProtocol().getDefaultPort()) {
            return this.getProtocol().getScheme() + "://" + this.getHostname(true);
        }
        return this.getProtocol().getScheme() + "://" + this.getHostname(true) + ":" + this.getPort();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Host) {
            Host o = (Host)other;
            return this.getNickname().equals(o.getNickname());
        }
        if (other instanceof String) {
            return this.getNickname().equals(other);
        }
        return false;
    }

    private static boolean loadNative() {
        if (!JNI_LOADED) {
            JNI_LOADED = Native.load("Diagnostics");
        }
        return JNI_LOADED;
    }

    public boolean isReachable() {
        if (!Host.loadNative()) {
            return false;
        }
        if (!Preferences.instance().getBoolean("connection.hostname.check")) {
            return true;
        }
        return this.isReachable(this.toURL());
    }

    private native boolean isReachable(String var1);

    public void diagnose() {
        if (!Host.loadNative()) {
            return;
        }
        this.diagnose(this.toURL());
    }

    private native void diagnose(String var1);

    private static OpenSshConfig getOpenSshConfig() {
        if (null == config) {
            config = OpenSshConfig.create();
        }
        return config;
    }

    private class KnownHostsCredentials
    extends Credentials {
        private KnownHostsCredentials() {
        }

        public String getUsername() {
            String user = super.getUsername();
            if (StringUtils.isBlank((String)user)) {
                if (!Protocol.SFTP.equals(Host.this.getProtocol())) {
                    return null;
                }
                OpenSshConfig.Host entry = Host.getOpenSshConfig().lookup(Host.this.getHostname());
                if (StringUtils.isNotBlank((String)entry.getUser())) {
                    return entry.getUser();
                }
            }
            return user;
        }

        public Local getIdentity() {
            OpenSshConfig.Host entry;
            if (!Protocol.SFTP.equals(Host.this.getProtocol())) {
                return null;
            }
            if (null == super.getIdentity() && null != (entry = Host.getOpenSshConfig().lookup(Host.this.getHostname())).getIdentityFile()) {
                return LocalFactory.createLocal(entry.getIdentityFile().getAbsolutePath());
            }
            return super.getIdentity();
        }
    }
}

