/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.serializer.HostReaderFactory;
import ch.cyberduck.core.serializer.HostWriterFactory;
import org.apache.log4j.Logger;

public class HostCollection
extends BookmarkCollection {
    private static Logger log = Logger.getLogger(HostCollection.class);
    private static HostCollection DEFAULT_COLLECTION = new HostCollection(LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "Favorites.plist"));
    protected Local file;

    public static HostCollection defaultCollection() {
        return DEFAULT_COLLECTION;
    }

    public HostCollection(Local file) {
        this.setFile(file);
    }

    protected void setFile(Local file) {
        this.file = file;
        this.file.getParent().mkdir(true);
    }

    public Local getFile() {
        return this.file;
    }

    public Host get(int row) {
        return (Host)super.get(row);
    }

    public boolean add(Host host) {
        this.add(this.size(), host);
        return true;
    }

    public void add(int row, Host host) {
        super.add(row, this.unique(host));
        this.sort();
        this.save();
    }

    protected Host unique(Host host) {
        String proposal = host.getNickname();
        int i = 1;
        while (this.contains(host) && this.get(this.indexOf(host)) != host) {
            host.setNickname(proposal + " (" + i + ")");
            ++i;
        }
        return host;
    }

    public Host remove(int row) {
        Host previous = (Host)super.remove(row);
        this.save();
        return previous;
    }

    protected void sort() {
    }

    public void save() {
        if (Preferences.instance().getBoolean("favorites.save")) {
            HostWriterFactory.instance().write((Host)((Object)this), this.file);
        }
    }

    public void load() {
        if (this.file.exists()) {
            log.info((Object)("Found Bookmarks file: " + this.file.getAbsolute()));
            this.addAll(HostReaderFactory.instance().readCollection(this.file));
            this.sort();
        }
    }
}

