/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cf;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.cf.CFSession;
import ch.cyberduck.core.cloud.CloudPath;
import ch.cyberduck.core.cloud.Distribution;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import com.mosso.client.cloudfiles.FilesCDNContainer;
import com.mosso.client.cloudfiles.FilesContainerInfo;
import com.mosso.client.cloudfiles.FilesObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.utils.ServiceUtils;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFPath
extends CloudPath {
    private static Logger log = Logger.getLogger(CFPath.class);
    private final CFSession session;

    protected CFPath(CFSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    protected CFPath(CFSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    protected CFPath(CFSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    protected <T> CFPath(CFSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDistribution(boolean enabled, String[] cnames, boolean logging) {
        String container = this.getContainerName();
        AbstractX509TrustManager trust = this.session.getTrustManager();
        try {
            block9: {
                try {
                    this.session.check();
                    trust.setHostname(URI.create(this.session.CF.getCdnManagementURL()).getHost());
                    if (enabled) {
                        this.session.message(MessageFormat.format(Locale.localizedString("Enable {0} Distribution", "Status"), Locale.localizedString("Mosso Cloud Files", "Mosso")));
                    } else {
                        this.session.message(MessageFormat.format(Locale.localizedString("Disable {0} Distribution", "Status"), Locale.localizedString("Mosso Cloud Files", "Mosso")));
                    }
                    if (enabled) {
                        FilesCDNContainer info = this.session.CF.getCDNContainerInfo(container);
                        if (null == info) {
                            this.session.CF.cdnEnableContainer(container);
                        } else {
                            this.session.CF.cdnUpdateContainer(container, -1, true);
                        }
                        break block9;
                    }
                    this.session.CF.cdnUpdateContainer(container, -1, false);
                }
                catch (IOException e) {
                    this.error("Cannot change permissions", e);
                    Object var8_9 = null;
                    trust.setHostname(URI.create(this.session.CF.getStorageURL()).getHost());
                }
            }
            Object var8_8 = null;
            trust.setHostname(URI.create(this.session.CF.getStorageURL()).getHost());
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            trust.setHostname(URI.create(this.session.CF.getStorageURL()).getHost());
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Distribution readDistribution() {
        String container = this.getContainerName();
        if (null != container) {
            FilesCDNContainer info;
            AbstractX509TrustManager trust;
            block6: {
                trust = this.session.getTrustManager();
                this.session.check();
                trust.setHostname(URI.create(this.session.CF.getCdnManagementURL()).getHost());
                info = this.session.CF.getCDNContainerInfo(container);
                if (null != info) break block6;
                Distribution distribution = new Distribution(false, null, Locale.localizedString("CDN Disabled", "Mosso"));
                Object var6_7 = null;
                trust.setHostname(URI.create(this.session.CF.getStorageURL()).getHost());
                return distribution;
            }
            try {
                Distribution distribution = new Distribution(info.isEnabled(), info.getCdnURL(), info.isEnabled() ? Locale.localizedString("CDN Enabled", "Mosso") : Locale.localizedString("CDN Disabled", "Mosso"));
                Object var6_8 = null;
                trust.setHostname(URI.create(this.session.CF.getStorageURL()).getHost());
                return distribution;
            }
            catch (IOException e) {
                try {
                    this.error(e.getMessage(), e);
                    Object var6_9 = null;
                    trust.setHostname(URI.create(this.session.CF.getStorageURL()).getHost());
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    trust.setHostname(URI.create(this.session.CF.getStorageURL()).getHost());
                    throw throwable;
                }
            }
        }
        return new Distribution(false, null, null);
    }

    @Override
    public boolean exists() {
        if (this.isRoot()) {
            return true;
        }
        try {
            if (this.isContainer()) {
                return this.session.CF.containerExists(this.getName());
            }
        }
        catch (IOException e) {
            return false;
        }
        return super.exists();
    }

    @Override
    public void readSize() {
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
            if (this.isContainer()) {
                this.attributes.setSize(this.session.CF.getContainerInfo(this.getContainerName()).getTotalSize());
            } else if (this.attributes.isFile()) {
                this.attributes.setSize(Long.valueOf(this.session.CF.getObjectMetaData(this.getContainerName(), this.getKey()).getContentLength()));
            }
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readTimestamp() {
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
            if (!this.isContainer()) {
                try {
                    this.attributes.setModificationDate(ServiceUtils.parseRfc822Date((String)this.session.CF.getObjectMetaData(this.getContainerName(), this.getKey()).getLastModified()).getTime());
                }
                catch (ParseException e) {
                    log.error((Object)e);
                }
            }
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readPermission() {
    }

    @Override
    public boolean isWritePermissionsSupported() {
        return false;
    }

    @Override
    public void writePermissions(Permission perm, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    public AttributedList<Path> list() {
        AttributedList<Path> childs;
        block9: {
            childs = new AttributedList<Path>();
            try {
                this.session.check();
                this.session.message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                if (this.isRoot()) {
                    for (FilesContainerInfo container : this.session.CF.listContainersInfo()) {
                        Path p = PathFactory.createPath(this.session, this.getAbsolute(), container.getName(), 10);
                        p.attributes.setSize(container.getTotalSize());
                        p.attributes.setOwner(this.session.CF.getUserName());
                        childs.add(p);
                    }
                    break block9;
                }
                for (FilesObject object : this.session.CF.listObjects(this.getContainerName(), this.getKey())) {
                    Path file = PathFactory.createPath(this.session, this.getContainerName(), object.getName(), "application/directory".equals(object.getMimeType()) ? 2 : 1);
                    if (!file.getParent().equals(this)) continue;
                    file.setParent(this);
                    if (file.attributes.getType() == 1) {
                        file.attributes.setSize(object.getSize());
                    }
                    try {
                        Date modified = DateParser.parse(object.getLastModified());
                        if (null != modified) {
                            file.attributes.setModificationDate(modified.getTime());
                        }
                    }
                    catch (InvalidDateException e) {
                        log.warn((Object)("Not ISO 8601 format:" + e.getMessage()));
                    }
                    file.attributes.setOwner(this.attributes.getOwner());
                    childs.add(file);
                }
            }
            catch (IOException e) {
                childs.attributes().setReadable(false);
                this.error("Listing directory failed", e);
            }
        }
        return childs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        block8: {
            if (this.attributes.isFile()) {
                Local.OutputStream out = null;
                InputStream in = null;
                try {
                    try {
                        if (check) {
                            this.session.check();
                        }
                        this.getSession().message(MessageFormat.format(Locale.localizedString("Downloading {0}", "Status"), this.getName()));
                        in = this.session.CF.getObjectAsStream(this.getContainerName(), this.getKey());
                        if (null == in) {
                            throw new IOException("Unable opening data stream");
                        }
                        this.getStatus().setCurrent(0L);
                        out = new Local.OutputStream(this.getLocal(), this.getStatus().isResume());
                        this.download(in, out, throttle, listener);
                    }
                    catch (IOException e) {
                        this.error("Download failed", e);
                        Object var8_7 = null;
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly(out);
                        break block8;
                    }
                    Object var8_6 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        if (this.attributes.isDirectory()) {
            this.getLocal().mkdir(true);
        }
    }

    @Override
    protected void upload(BandwidthThrottle throttle, StreamListener listener, Permission p, boolean check) {
        try {
            if (check) {
                this.session.check();
            }
            if (this.attributes.isFile()) {
                Status stat = this.getStatus();
                stat.setCurrent(0L);
                Local.InputStream in = new Local.InputStream(this.getLocal());
                this.getSession().message(MessageFormat.format(Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                String md5sum = null;
                try {
                    md5sum = ServiceUtils.toHex((byte[])ServiceUtils.computeMD5Hash((InputStream)((Object)new Local.InputStream(this.getLocal()))));
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Uploading {0}", "Status"), this.getName()));
                }
                catch (NoSuchAlgorithmException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                HashMap metadata = new HashMap();
                this.session.CF.storeObjectAs(this.getContainerName(), this.getKey(), (RequestEntity)new InputStreamRequestEntity((InputStream)((Object)in), this.getLocal().attributes.getSize(), this.getLocal().getMimeType(), (InputStream)((Object)in), stat, throttle, listener){
                    boolean requested;
                    final /* synthetic */ InputStream val$in;
                    final /* synthetic */ Status val$stat;
                    final /* synthetic */ BandwidthThrottle val$throttle;
                    final /* synthetic */ StreamListener val$listener;
                    {
                        this.val$in = inputStream;
                        this.val$stat = status;
                        this.val$throttle = bandwidthThrottle;
                        this.val$listener = streamListener;
                        super(x0, x1, x2);
                        this.requested = false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void writeRequest(OutputStream out) throws IOException {
                        if (this.requested) {
                            this.val$in.reset();
                            this.val$stat.reset();
                            this.val$stat.setCurrent(0L);
                        }
                        try {
                            CFPath.this.upload(out, this.val$in, this.val$throttle, this.val$listener);
                            Object var3_2 = null;
                            this.requested = true;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            this.requested = true;
                            throw throwable;
                        }
                    }

                    public boolean isRepeatable() {
                        return true;
                    }
                }, metadata, md5sum);
            }
            if (this.attributes.isDirectory()) {
                this.mkdir();
            }
        }
        catch (IOException e) {
            this.error("Upload failed", e);
        }
    }

    @Override
    public void mkdir(boolean recursive) {
        log.debug((Object)("mkdir:" + this.getName()));
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
            if (this.isContainer()) {
                this.session.CF.createContainer(this.getName());
            } else {
                this.session.CF.createFullPath(this.getContainerName(), this.getKey());
            }
        }
        catch (IOException e) {
            this.error("Cannot create folder", e);
        }
    }

    @Override
    public void delete() {
        block8: {
            log.debug((Object)("delete:" + this.toString()));
            try {
                this.session.check();
                if (!this.isContainer()) {
                    this.session.message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                    this.session.CF.deleteObject(this.getContainerName(), this.getKey());
                } else if (this.attributes.isDirectory()) {
                    for (AbstractPath i : this.childs()) {
                        if (!this.session.isConnected()) break;
                        i.delete();
                    }
                    if (this.isContainer()) {
                        this.session.CF.deleteContainer(this.getContainerName());
                    }
                }
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot delete file", e);
                }
                if (!this.attributes.isDirectory()) break block8;
                this.error("Cannot delete folder", e);
            }
        }
    }

    @Override
    public boolean isRenameSupported() {
        return false;
    }

    @Override
    public void rename(AbstractPath renamed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toHttpURL() {
        Distribution distribution = this.readDistribution();
        if (null == distribution.getUrl()) {
            return super.toHttpURL();
        }
        StringBuffer b = new StringBuffer();
        b.append(distribution.getUrl());
        if (!this.isContainer()) {
            b.append(this.encode(this.getKey()));
        }
        return b.toString();
    }

    static {
        PathFactory.addFactory(Protocol.MOSSO, new Factory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<CFSession> {
        private Factory() {
        }

        @Override
        protected Path create(CFSession session, String path, int type) {
            return new CFPath(session, path, type);
        }

        @Override
        protected Path create(CFSession session, String parent, String name, int type) {
            return new CFPath(session, parent, name, type);
        }

        @Override
        protected Path create(CFSession session, String path, Local file) {
            return new CFPath(session, path, file);
        }

        @Override
        protected <T> Path create(CFSession session, T dict) {
            return new CFPath(session, dict);
        }
    }
}

