/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ec;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.s3.S3Session;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.model.cloudfront.Distribution;

public class ECSession
extends S3Session {
    protected ECSession(Host h) {
        super(h);
    }

    protected void configure() {
        super.configure();
        this.configuration.setProperty("s3service.s3-endpoint", this.host.getHostname());
        this.configuration.setProperty("s3service.disable-dns-buckets", String.valueOf(true));
        this.configuration.setProperty("s3service.s3-endpoint-virtual-path", Path.normalize("/services/Walrus"));
    }

    public Distribution[] listDistributions(String bucket) throws CloudFrontServiceException {
        return new Distribution[0];
    }

    static {
        SessionFactory.addFactory(Protocol.EUCALYPTUS, new Factory());
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new ECSession(h);
        }
    }
}

