/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.ftp.parser.CompositeFileEntryParser;
import ch.cyberduck.core.ftp.parser.EPLFFTPEntryParser;
import ch.cyberduck.core.ftp.parser.LaxUnixFTPEntryParser;
import ch.cyberduck.core.ftp.parser.RumpusFTPEntryParser;
import ch.cyberduck.core.ftp.parser.TrellixFTPEntryParser;
import java.util.TimeZone;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.MVSFTPEntryParser;
import org.apache.commons.net.ftp.parser.NTFTPEntryParser;
import org.apache.commons.net.ftp.parser.NetwareFTPEntryParser;
import org.apache.commons.net.ftp.parser.OS2FTPEntryParser;
import org.apache.commons.net.ftp.parser.OS400FTPEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.log4j.Logger;

public class FTPParserFactory
implements FTPFileEntryParserFactory {
    private static Logger log = Logger.getLogger(FTPParserFactory.class);

    public FTPFileEntryParser createFileEntryParser(String system, TimeZone timezone) throws ParserInitializationException {
        if (null != system) {
            String ukey = system.toUpperCase();
            if (ukey.indexOf("UNIX") >= 0) {
                return this.createUnixFTPEntryParser(timezone);
            }
            if (ukey.indexOf("VMS") >= 0) {
                throw new ParserInitializationException("\"" + system + "\" is not currently a supported system.");
            }
            if (ukey.indexOf("NETWARE") >= 0) {
                return this.createNetwareFTPEntryParser(timezone);
            }
            if (ukey.indexOf("WINDOWS") >= 0) {
                return this.createNTFTPEntryParser(timezone);
            }
            if (ukey.indexOf("OS/2") >= 0) {
                return this.createOS2FTPEntryParser(timezone);
            }
            if (ukey.indexOf("OS/400") >= 0) {
                return this.createOS400FTPEntryParser(timezone);
            }
            if (ukey.indexOf("MVS") >= 0) {
                return this.createMVSEntryParser(timezone);
            }
        }
        return this.createUnixFTPEntryParser(timezone);
    }

    public FTPFileEntryParser createFileEntryParser(String system) throws ParserInitializationException {
        return this.createFileEntryParser(system, TimeZone.getDefault());
    }

    public FTPFileEntryParser createFileEntryParser(FTPClientConfig config) throws ParserInitializationException {
        return this.createFileEntryParser(config.getServerSystemKey(), TimeZone.getTimeZone(config.getServerTimeZoneId()));
    }

    private FTPFileEntryParser createUnixFTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new LaxUnixFTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, new EPLFFTPEntryParser(), new RumpusFTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, new TrellixFTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }});
    }

    private FTPFileEntryParser createNetwareFTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new NetwareFTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, this.createUnixFTPEntryParser(timezone)});
    }

    private FTPFileEntryParser createNTFTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new NTFTPEntryParser(){

            public FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, this.createUnixFTPEntryParser(timezone)});
    }

    private FTPFileEntryParser createOS2FTPEntryParser(final TimeZone timezone) {
        return new OS2FTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        };
    }

    private FTPFileEntryParser createOS400FTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new OS400FTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, this.createUnixFTPEntryParser(timezone)});
    }

    private FTPFileEntryParser createMVSEntryParser(final TimeZone timezone) {
        return new MVSFTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        };
    }
}

