/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftps;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import com.enterprisedt.net.ftp.FTPActiveDataSocket;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPPassiveDataSocket;
import com.enterprisedt.net.ftp.FTPReply;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.X509TrustManager;

public class FTPSControlSocket
extends FTPControlSocket {
    protected boolean useDataConnectionSecurity = Preferences.instance().getProperty("ftp.tls.datachannel").equals("P");
    private X509TrustManager trustManager;

    protected FTPSControlSocket(String encoding, FTPMessageListener listener, X509TrustManager trustManager) {
        super(encoding, listener);
        this.trustManager = trustManager;
    }

    protected void startHandshake() throws IOException {
        this.controlSock = new CustomTrustSSLProtocolSocketFactory(this.trustManager).createSocket(this.controlSock, this.controlSock.getInetAddress().getHostName(), this.controlSock.getPort(), true);
        this.initStreams();
    }

    public void setUseDataConnectionSecurity(boolean b) {
        this.useDataConnectionSecurity = b;
    }

    protected FTPDataSocket createDataSocketActive() throws IOException, FTPException {
        if (this.useDataConnectionSecurity) {
            FTPActiveDataSocket socket = new FTPActiveDataSocket(new CustomTrustSSLProtocolSocketFactory(this.trustManager).createServerSocket(0));
            InetAddress localhost = this.controlSock.getLocalAddress();
            this.setDataPort(localhost, (short)socket.getLocalPort());
            return socket;
        }
        return super.createDataSocketActive();
    }

    protected FTPDataSocket createDataSocketPASV() throws IOException, FTPException {
        if (this.useDataConnectionSecurity) {
            FTPReply replyObj = this.sendCommand("PASV");
            this.validateReply(replyObj, "227");
            String reply = replyObj.getReplyText();
            int[] parts = this.parsePASVResponse(reply);
            String ipAddress = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
            int port = (parts[4] << 8) + parts[5];
            try {
                if (InetAddress.getByName(ipAddress).isSiteLocalAddress()) {
                    Socket socket = new CustomTrustSSLProtocolSocketFactory(this.trustManager).createSocket(this.controlSock.getInetAddress().getHostAddress(), port);
                    return new FTPPassiveDataSocket(socket);
                }
                return new FTPPassiveDataSocket(new CustomTrustSSLProtocolSocketFactory(this.trustManager).createSocket(ipAddress, port));
            }
            catch (ConnectException e) {
                throw new FTPException(e.getMessage());
            }
        }
        return super.createDataSocketPASV();
    }

    protected FTPDataSocket createDataSocketEPSV() throws IOException {
        FTPReply replyObj = this.sendCommand("EPSV");
        this.validateReply(replyObj, "229");
        String reply = replyObj.getReplyText();
        int port = this.parseEPSVResponse(reply);
        return new FTPPassiveDataSocket(new CustomTrustSSLProtocolSocketFactory(this.trustManager).createSocket(this.controlSock.getInetAddress().getHostAddress(), port));
    }
}

