/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Keychain;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.i18n.Locale;
import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.StreamGobbler;
import ch.ethz.ssh2.channel.ChannelClosedException;
import ch.ethz.ssh2.crypto.PEMDecoder;
import ch.ethz.ssh2.sftp.SFTPv3Client;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SFTPSession
extends Session {
    private static Logger log = Logger.getLogger(SFTPSession.class);
    protected Connection SSH;
    private ServerHostKeyVerifier verifier = null;
    private SFTPv3Client SFTP;

    private SFTPSession(Host h) {
        super(h);
    }

    public boolean isSecure() {
        if (super.isSecure()) {
            return this.SSH.isAuthenticationComplete();
        }
        return false;
    }

    public String getIdentification() {
        StringBuffer info = new StringBuffer(super.getIdentification() + "\n");
        if (this.SFTP != null) {
            info.append("SFTP Protocol version: ").append(this.SFTP.getProtocolVersion()).append("\n");
        }
        try {
            ConnectionInfo i = this.SSH.getConnectionInfo();
            info.append("Key Exchange (KEX) Algorithm: ").append(i.keyExchangeAlgorithm).append("\n");
            info.append("Number of key exchanges performed on this connection so far: ").append(i.keyExchangeCounter).append("\n");
            info.append("Host Key Algorithm: ").append(i.serverHostKeyAlgorithm).append("\n");
            info.append("Server to Client Crypto Algorithm: ").append(i.serverToClientCryptoAlgorithm).append("\n");
            info.append("Client to Server Crypto Algorithm: ").append(i.clientToServerCryptoAlgorithm).append("\n");
            info.append("Server to Client MAC Algorithm: ").append(i.serverToClientMACAlgorithm).append("\n");
            info.append("Client to Server MAC Algorithm: ").append(i.clientToServerMACAlgorithm).append("\n");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        return info.toString();
    }

    public void setHostKeyVerificationController(ServerHostKeyVerifier v) {
        this.verifier = v;
    }

    protected SFTPv3Client sftp() throws IOException {
        if (null == this.SFTP) {
            if (!this.isConnected()) {
                throw new ConnectionCanceledException();
            }
            if (!this.SSH.isAuthenticationComplete()) {
                throw new LoginCanceledException();
            }
            this.message(Locale.localizedString("Starting SFTP subsystem", "Status"));
            try {
                this.SFTP = new SFTPv3Client(this.SSH);
                this.message(Locale.localizedString("SFTP subsystem ready", "Status"));
                this.SFTP.setCharset(this.getEncoding());
            }
            catch (IOException e) {
                this.error(null, e.getMessage(), e);
            }
        }
        return this.SFTP;
    }

    protected SCPClient openScp() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (!this.SSH.isAuthenticationComplete()) {
            throw new LoginCanceledException();
        }
        SCPClient client = new SCPClient(this.SSH);
        client.setCharset(this.getEncoding());
        return client;
    }

    protected void connect() throws IOException, ConnectionCanceledException, LoginCanceledException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.message(MessageFormat.format(Locale.localizedString("Opening {0} connection to {1}", "Status"), this.host.getProtocol().getName(), this.host.getHostname()));
        this.SSH = new Connection(this.host.getHostname(true), this.host.getPort());
        int timeout = this.timeout();
        this.SSH.connect(this.verifier, timeout, timeout);
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.message(MessageFormat.format(Locale.localizedString("{0} connection opened", "Status"), this.host.getProtocol().getName()));
        this.login();
        if (!this.SSH.isAuthenticationComplete()) {
            throw new LoginCanceledException();
        }
        this.fireConnectionDidOpenEvent();
    }

    protected void login(Credentials credentials) throws IOException {
        if (this.host.getCredentials().isPublicKeyAuthentication()) {
            if (this.loginUsingPublicKeyAuthentication(credentials)) {
                this.message(Locale.localizedString("Login successful", "Credentials"));
                return;
            }
        } else if (this.loginUsingPasswordAuthentication(credentials) || this.loginUsingKBIAuthentication(credentials)) {
            this.message(Locale.localizedString("Login successful", "Credentials"));
            return;
        }
        this.message(Locale.localizedString("Login failed", "Credentials"));
        this.login.fail(this.host, Locale.localizedString("Login with username and password", "Credentials"));
        this.login();
    }

    private boolean loginUsingPublicKeyAuthentication(Credentials credentials) throws IOException {
        log.debug((Object)("loginUsingPublicKeyAuthentication:" + credentials));
        if (this.SSH.isAuthMethodAvailable(this.host.getCredentials().getUsername(), "publickey")) {
            Local identity = this.host.getCredentials().getIdentity();
            if (identity.exists()) {
                int len;
                char[] buff = new char[256];
                CharArrayWriter cw = new CharArrayWriter();
                FileReader fr = new FileReader(new File(identity.getAbsolute()));
                while ((len = fr.read(buff)) >= 0) {
                    cw.write(buff, 0, len);
                }
                fr.close();
                String passphrase = null;
                if (PEMDecoder.isPEMEncrypted(cw.toCharArray()) && StringUtils.isEmpty((String)(passphrase = Keychain.instance().getPasswordFromKeychain("SSHKeychain", identity.toURL())))) {
                    this.login.prompt(this.host, Locale.localizedString("Private key password protected", "Credentials"), Locale.localizedString("Enter the passphrase for the private key file", "Credentials") + " (" + identity + ")");
                    passphrase = credentials.getPassword();
                    if (credentials.usesKeychain() && PEMDecoder.isPEMEncrypted(cw.toCharArray())) {
                        Keychain.instance().addPasswordToKeychain("SSHKeychain", identity.toURL(), passphrase);
                    }
                }
                return this.SSH.authenticateWithPublicKey(this.host.getCredentials().getUsername(), new File(identity.getAbsolute()), passphrase);
            }
            log.error((Object)("Key file " + identity.getAbsolute() + " does not exist."));
        }
        return false;
    }

    private boolean loginUsingPasswordAuthentication(Credentials credentials) throws IOException {
        log.debug((Object)("loginUsingPasswordAuthentication:" + credentials));
        if (this.SSH.isAuthMethodAvailable(this.host.getCredentials().getUsername(), "password")) {
            return this.SSH.authenticateWithPassword(credentials.getUsername(), credentials.getPassword());
        }
        return false;
    }

    private boolean loginUsingKBIAuthentication(Credentials credentials) throws IOException {
        log.debug((Object)("loginUsingKBIAuthenticationmake:" + credentials));
        if (this.SSH.isAuthMethodAvailable(credentials.getUsername(), "keyboard-interactive")) {
            InteractiveLogic il = new InteractiveLogic(credentials);
            return this.SSH.authenticateWithKeyboardInteractive(credentials.getUsername(), il);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.fireConnectionWillCloseEvent();
            if (this.SFTP != null) {
                this.SFTP.close();
            }
            if (this.SSH != null) {
                this.SSH.close();
            }
        }
        finally {
            this.SFTP = null;
            this.SSH = null;
            this.fireConnectionDidCloseEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        try {
            super.interrupt();
            if (null == this.SSH) {
                return;
            }
            this.fireConnectionWillCloseEvent();
            this.SSH.close(null, true);
        }
        finally {
            this.SFTP = null;
            this.SSH = null;
            this.fireConnectionDidCloseEvent();
        }
    }

    public void check() throws IOException {
        this.check(true);
    }

    private void check(boolean sftp) throws IOException {
        try {
            super.check();
        }
        catch (ChannelClosedException e) {
            log.debug((Object)e.getMessage());
            this.interrupt();
            this.connect();
        }
        if (sftp && !this.sftp().isConnected()) {
            this.interrupt();
            this.connect();
        }
    }

    public Path workdir() throws IOException {
        if (null == this.SFTP) {
            throw new ConnectionCanceledException();
        }
        if (!this.SFTP.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (null == this.workdir) {
            this.workdir = PathFactory.createPath((Session)this, this.sftp().canonicalPath("."), 2);
        }
        return this.workdir;
    }

    protected void noop() throws IOException {
        if (this.isConnected()) {
            this.SSH.sendIgnorePacket();
        }
    }

    public boolean isSendCommandSupported() {
        return true;
    }

    public boolean isArchiveSupported() {
        return true;
    }

    public boolean isUnarchiveSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(String command) throws IOException {
        ch.ethz.ssh2.Session sess = this.SSH.openSession();
        try {
            String line;
            this.message(command);
            sess.execCommand(command, this.host.getEncoding());
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(new StreamGobbler(sess.getStdout())));
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader(new StreamGobbler(sess.getStderr())));
            while (null != (line = stdoutReader.readLine())) {
                this.log(false, line);
            }
            while (null != (line = stderrReader.readLine())) {
                this.log(false, line);
            }
        }
        finally {
            sess.close();
        }
    }

    public boolean isConnected() {
        return null != this.SSH;
    }

    static {
        SessionFactory.addFactory(Protocol.SFTP, new Factory());
    }

    private static class InteractiveLogic
    implements InteractiveCallback {
        int promptCount = 0;
        Credentials credentials;

        public InteractiveLogic(Credentials credentials) {
            this.credentials = credentials;
        }

        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws IOException {
            String[] result = new String[numPrompts];
            for (int i = 0; i < numPrompts; ++i) {
                result[i] = this.credentials.getPassword();
                ++this.promptCount;
            }
            return result;
        }

        public int getPromptCount() {
            return this.promptCount;
        }
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new SFTPSession(h);
        }
    }
}

