/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import ch.cyberduck.core.Preferences;
import com.enterprisedt.net.ftp.FTPActiveDataSocket;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPNullReplyException;
import com.enterprisedt.net.ftp.FTPPassiveDataSocket;
import com.enterprisedt.net.ftp.FTPReply;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FTPControlSocket {
    protected static Logger log = Logger.getLogger(FTPControlSocket.class);
    private static final String EOL = "\r\n";
    public static final int CONTROL_PORT = 21;
    private boolean strictReturnCodes = true;
    protected Socket controlSock = null;
    private Writer writer = null;
    private BufferedReader reader = null;
    private String encoding;
    private FTPMessageListener listener = null;
    private int timeout = 0;

    protected String getEncoding() {
        return this.encoding;
    }

    protected FTPControlSocket(String encoding, FTPMessageListener listener) {
        this.encoding = encoding;
        this.listener = listener;
    }

    protected void connect(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this.controlSock = new Socket(remoteAddr, controlPort);
        try {
            this.controlSock.setKeepAlive(true);
        }
        catch (SocketException e) {
            log.error((Object)e.getMessage());
        }
        try {
            this.controlSock.setSoTimeout(this.timeout);
        }
        catch (SocketException e) {
            log.error((Object)e.getMessage());
        }
        this.initStreams();
        this.validateConnection();
    }

    private void validateConnection() throws IOException, FTPException {
        this.validateReply(this.readReply(), "220");
    }

    protected void initStreams() throws IOException {
        InputStream is = this.controlSock.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(is, this.encoding));
        OutputStream os = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(os, this.encoding);
    }

    public String getRemoteHostName() {
        InetAddress addr = this.controlSock.getInetAddress();
        return addr.getHostName();
    }

    public void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
    }

    public void setTimeout(int millis) {
        this.timeout = millis;
    }

    public void logout() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.controlSock != null) {
                this.controlSock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected FTPDataSocket createDataSocket(FTPConnectMode connectMode) throws IOException, FTPException {
        try {
            if (connectMode == FTPConnectMode.ACTIVE) {
                return this.createDataSocketActive();
            }
            if (connectMode == FTPConnectMode.PASV) {
                return this.createDataSocketPassive();
            }
        }
        catch (FTPException e) {
            if (Preferences.instance().getBoolean("ftp.connectmode.fallback")) {
                if (connectMode == FTPConnectMode.ACTIVE) {
                    return this.createDataSocketPassive();
                }
                if (connectMode == FTPConnectMode.PASV) {
                    return this.createDataSocketActive();
                }
            }
            throw e;
        }
        return null;
    }

    protected FTPDataSocket createDataSocketActive() throws IOException, FTPException {
        FTPActiveDataSocket socket = new FTPActiveDataSocket(new ServerSocket(0));
        InetAddress localhost = this.controlSock.getLocalAddress();
        this.setDataPort(localhost, (short)socket.getLocalPort());
        return socket;
    }

    private static short toUnsignedShort(byte value) {
        return value < 0 ? (short)(value + 256) : (short)value;
    }

    private static byte[] toByteArray(short value) {
        byte[] bytes = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return bytes;
    }

    protected void setDataPort(InetAddress host, short port) throws IOException, FTPException {
        if (host instanceof Inet6Address) {
            this.setDataPortIPv6(host, port);
        } else {
            this.setDataPortIPv4(host, port);
        }
    }

    protected void setDataPortIPv6(InetAddress host, short port) throws IOException {
        FTPReply ftpreply = this.sendCommand("EPRT |2|" + host.getHostAddress() + "|" + port + "|");
        this.validateReply(ftpreply, "200");
    }

    protected void setDataPortIPv4(InetAddress host, short port) throws IOException {
        byte[] hostBytes = host.getAddress();
        byte[] portBytes = FTPControlSocket.toByteArray(port);
        String cmd = new StringBuffer("PORT ").append(FTPControlSocket.toUnsignedShort(hostBytes[0])).append(",").append(FTPControlSocket.toUnsignedShort(hostBytes[1])).append(",").append(FTPControlSocket.toUnsignedShort(hostBytes[2])).append(",").append(FTPControlSocket.toUnsignedShort(hostBytes[3])).append(",").append(FTPControlSocket.toUnsignedShort(portBytes[0])).append(",").append(FTPControlSocket.toUnsignedShort(portBytes[1])).toString();
        FTPReply reply = this.sendCommand(cmd);
        this.validateReply(reply, "200");
    }

    protected FTPDataSocket createDataSocketPassive() throws IOException, FTPException {
        if (this.controlSock.getInetAddress() instanceof Inet6Address) {
            return this.createDataSocketEPSV();
        }
        return this.createDataSocketPASV();
    }

    protected FTPDataSocket createDataSocketPASV() throws IOException {
        FTPReply replyObj = this.sendCommand("PASV");
        this.validateReply(replyObj, "227");
        String reply = replyObj.getReplyText();
        int[] parts = this.parsePASVResponse(reply);
        String ipAddress = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        int port = (parts[4] << 8) + parts[5];
        try {
            if (InetAddress.getByName(ipAddress).isSiteLocalAddress()) {
                return new FTPPassiveDataSocket(new Socket(this.controlSock.getInetAddress(), port));
            }
            return new FTPPassiveDataSocket(new Socket(ipAddress, port));
        }
        catch (ConnectException e) {
            throw new FTPException(e.getMessage());
        }
    }

    protected int[] parsePASVResponse(String reply) throws FTPException {
        int startIP = reply.indexOf(40);
        int endIP = reply.indexOf(41);
        if (startIP < 0) {
            for (startIP = 0; startIP < reply.length() && !Character.isDigit(reply.charAt(startIP)); ++startIP) {
            }
            --startIP;
        }
        if (endIP < 0) {
            for (endIP = reply.length() - 1; endIP > 0 && !Character.isDigit(reply.charAt(endIP)); --endIP) {
            }
            if (++endIP >= reply.length()) {
                reply = reply + ")";
            }
        }
        String ipData = reply.substring(startIP + 1, endIP).trim();
        int[] parts = new int[6];
        int len = ipData.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len && partCount <= 6; ++i) {
            char ch = ipData.charAt(i);
            if (Character.isDigit(ch)) {
                buf.append(ch);
            } else if (ch != ',' && ch != ' ') {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
            if (ch != ',' && i + 1 != len) continue;
            try {
                parts[partCount++] = Integer.parseInt(buf.toString());
                buf.setLength(0);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
        }
        return parts;
    }

    protected FTPDataSocket createDataSocketEPSV() throws IOException {
        FTPReply replyObj = this.sendCommand("EPSV");
        this.validateReply(replyObj, "229");
        String reply = replyObj.getReplyText();
        int port = this.parseEPSVResponse(reply);
        return new FTPPassiveDataSocket(new Socket(this.controlSock.getInetAddress(), port));
    }

    protected int parseEPSVResponse(String reply) {
        int i = reply.indexOf("(|||");
        int j = reply.indexOf("|)");
        return Integer.parseInt(reply.substring(i += "(|||".length(), j).trim());
    }

    public FTPReply sendCommand(String command) throws IOException {
        this.writeCommand(command);
        return this.readReply();
    }

    private void writeCommand(String command) throws IOException {
        this.log(command, true);
        this.writer.write(command + EOL);
        this.writer.flush();
    }

    protected FTPReply readReply() throws IOException {
        String line = this.reader.readLine();
        while (line != null && line.length() == 0) {
            line = this.reader.readLine();
        }
        if (line == null) {
            throw new FTPNullReplyException();
        }
        this.log(line, false);
        if (line.length() < 3) {
            throw new IOException("Short reply received");
        }
        String replyCode = line.substring(0, 3);
        StringBuffer reply = new StringBuffer("");
        if (line.length() > 3) {
            reply.append(line.substring(4));
        }
        Vector<String> dataLines = null;
        if (line.charAt(3) == '-') {
            dataLines = new Vector<String>();
            boolean complete = false;
            while (!complete) {
                line = this.reader.readLine();
                if (line == null) {
                    throw new FTPNullReplyException();
                }
                if (line.length() == 0) continue;
                this.log(line, false);
                if (line.length() > 3 && line.substring(0, 3).equals(replyCode) && line.charAt(3) == ' ') {
                    reply.append(line.substring(3));
                    complete = true;
                    continue;
                }
                reply.append(" ").append(line);
                dataLines.addElement(line);
            }
        }
        if (dataLines != null) {
            Object[] data = new String[dataLines.size()];
            dataLines.copyInto(data);
            return new FTPReply(replyCode, reply.toString(), (String[])data);
        }
        return new FTPReply(replyCode, reply.toString());
    }

    protected FTPReply validateReply(String reply, String expectedReplyCode) throws FTPException {
        FTPReply replyObj = new FTPReply(reply);
        if (this.validateReplyCode(replyObj, expectedReplyCode)) {
            return replyObj;
        }
        throw new FTPException(replyObj);
    }

    public FTPReply validateReply(String reply, String[] expectedReplyCodes) throws IOException, FTPException {
        FTPReply replyObj = new FTPReply(reply);
        return this.validateReply(replyObj, expectedReplyCodes);
    }

    public FTPReply validateReply(FTPReply reply, String[] expectedReplyCodes) throws FTPException {
        for (int i = 0; i < expectedReplyCodes.length; ++i) {
            if (!this.validateReplyCode(reply, expectedReplyCodes[i])) continue;
            return reply;
        }
        throw new FTPException(reply);
    }

    public FTPReply validateReply(FTPReply reply, String expectedReplyCode) throws FTPException {
        if (this.validateReplyCode(reply, expectedReplyCode)) {
            return reply;
        }
        throw new FTPException(reply);
    }

    private boolean validateReplyCode(FTPReply reply, String expectedReplyCode) {
        String replyCode = reply.getReplyCode();
        if (this.strictReturnCodes) {
            return replyCode.equals(expectedReplyCode);
        }
        return replyCode.charAt(0) == expectedReplyCode.charAt(0);
    }

    protected void log(String msg, boolean command) {
        if (msg.startsWith("PASS")) {
            msg = "PASS ********";
        }
        if (this.listener != null) {
            if (command) {
                this.listener.logCommand(msg);
            } else {
                this.listener.logReply(msg);
            }
        }
    }

    public void interrupt() throws IOException {
        if (null == this.controlSock) {
            log.warn((Object)"No control socket to interrupt");
            return;
        }
        this.controlSock.close();
        log.warn((Object)("Forced to close socket " + this.controlSock.toString()));
    }

    public boolean isConnected() {
        if (null == this.controlSock) {
            return false;
        }
        return null != this.reader && null != this.writer;
    }
}

