/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import ch.cyberduck.core.LocalFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.spearce.jgit.errors.InvalidPatternException;
import org.spearce.jgit.fnmatch.FileNameMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSshConfig {
    private static Logger log = Logger.getLogger(OpenSshConfig.class);
    private final File home;
    private final File configFile;
    private long lastModified;
    private Map<String, Host> hosts;

    public static OpenSshConfig create() {
        File home = new File(LocalFactory.createLocal("~").getAbsolute());
        File config = new File(new File(home, ".ssh"), "config");
        OpenSshConfig osc = new OpenSshConfig(home, config);
        osc.refresh();
        return osc;
    }

    protected OpenSshConfig(File h, File cfg) {
        this.home = h;
        this.configFile = cfg;
        this.hosts = Collections.emptyMap();
    }

    public Host lookup(String hostName) {
        Map<String, Host> cache = this.refresh();
        Host h = cache.get(hostName);
        if (h == null) {
            h = new Host();
        }
        if (h.patternsApplied) {
            return h;
        }
        for (Map.Entry<String, Host> e : cache.entrySet()) {
            if (!OpenSshConfig.isHostPattern(e.getKey()) || !OpenSshConfig.isHostMatch(e.getKey(), hostName)) continue;
            log.debug((Object)("Found host match in SSH config:" + e.getValue()));
            h.copyFrom(e.getValue());
        }
        if (h.hostName == null) {
            h.hostName = hostName;
        }
        if (h.user == null) {
            // empty if block
        }
        if (h.port == 0) {
            h.port = -1;
        }
        h.patternsApplied = true;
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, Host> refresh() {
        long mtime = this.configFile.lastModified();
        if (mtime != this.lastModified) {
            try {
                FileInputStream in = new FileInputStream(this.configFile);
                try {
                    this.hosts = this.parse(in);
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException none) {
                this.hosts = Collections.emptyMap();
            }
            catch (IOException err) {
                this.hosts = Collections.emptyMap();
            }
            this.lastModified = mtime;
        }
        return this.hosts;
    }

    private Map<String, Host> parse(InputStream in) throws IOException {
        String line;
        LinkedHashMap<String, Host> m = new LinkedHashMap<String, Host>();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ArrayList<Host> current = new ArrayList<Host>(4);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            String[] parts = line.split("[ \t]*[= \t]", 2);
            String keyword = parts[0].trim();
            String argValue = parts[1].trim();
            if ("Host".equalsIgnoreCase(keyword)) {
                current.clear();
                for (String pattern : argValue.split("[ \t]")) {
                    String name = OpenSshConfig.dequote(pattern);
                    Host c = (Host)m.get(name);
                    if (c == null) {
                        c = new Host();
                        m.put(name, c);
                    }
                    current.add(c);
                }
                continue;
            }
            if (current.isEmpty()) continue;
            if ("HostName".equalsIgnoreCase(keyword)) {
                for (Host c : current) {
                    if (c.hostName != null) continue;
                    c.hostName = OpenSshConfig.dequote(argValue);
                }
                continue;
            }
            if ("User".equalsIgnoreCase(keyword)) {
                for (Host c : current) {
                    if (c.user != null) continue;
                    c.user = OpenSshConfig.dequote(argValue);
                }
                continue;
            }
            if ("Port".equalsIgnoreCase(keyword)) {
                try {
                    int port = Integer.parseInt(OpenSshConfig.dequote(argValue));
                    for (Host c : current) {
                        if (c.port != 0) continue;
                        c.port = port;
                    }
                    continue;
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
            }
            if ("IdentityFile".equalsIgnoreCase(keyword)) {
                for (Host c : current) {
                    if (c.identityFile != null) continue;
                    c.identityFile = this.toFile(OpenSshConfig.dequote(argValue));
                }
                continue;
            }
            if ("PreferredAuthentications".equalsIgnoreCase(keyword)) {
                for (Host c : current) {
                    if (c.preferredAuthentications != null) continue;
                    c.preferredAuthentications = OpenSshConfig.nows(OpenSshConfig.dequote(argValue));
                }
                continue;
            }
            if (!"BatchMode".equalsIgnoreCase(keyword)) continue;
            for (Host c : current) {
                if (c.batchMode != null) continue;
                c.batchMode = OpenSshConfig.yesno(OpenSshConfig.dequote(argValue));
            }
        }
        return m;
    }

    private static boolean isHostPattern(String s) {
        return s.indexOf(42) >= 0 || s.indexOf(63) >= 0;
    }

    private static boolean isHostMatch(String pattern, String name) {
        FileNameMatcher fn;
        try {
            fn = new FileNameMatcher(pattern, null);
        }
        catch (InvalidPatternException e) {
            return false;
        }
        fn.append(name);
        return fn.isMatch();
    }

    private static String dequote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static String nows(String value) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isSpaceChar(value.charAt(i))) continue;
            b.append(value.charAt(i));
        }
        return b.toString();
    }

    private static Boolean yesno(String value) {
        if ("yes".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private File toFile(String path) {
        if (path.startsWith("~/")) {
            return new File(this.home, path.substring(2));
        }
        File ret = new File(path);
        if (ret.isAbsolute()) {
            return ret;
        }
        return new File(this.home, path);
    }

    public static class Host {
        boolean patternsApplied;
        String hostName;
        int port;
        File identityFile;
        String user;
        String preferredAuthentications;
        Boolean batchMode;

        void copyFrom(Host src) {
            if (this.hostName == null) {
                this.hostName = src.hostName;
            }
            if (this.port == 0) {
                this.port = src.port;
            }
            if (this.identityFile == null) {
                this.identityFile = src.identityFile;
            }
            if (this.user == null) {
                this.user = src.user;
            }
            if (this.preferredAuthentications == null) {
                this.preferredAuthentications = src.preferredAuthentications;
            }
            if (this.batchMode == null) {
                this.batchMode = src.batchMode;
            }
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        public File getIdentityFile() {
            return this.identityFile;
        }

        public String getUser() {
            return this.user;
        }

        public String getPreferredAuthentications() {
            return this.preferredAuthentications;
        }

        public boolean isBatchMode() {
            return this.batchMode != null && this.batchMode != false;
        }
    }
}

