/*
 * Decompiled with CFR 0.152.
 */
package com.mosso.client.cloudfiles;

import com.mosso.client.cloudfiles.FilesAccountInfo;
import com.mosso.client.cloudfiles.FilesAuthorizationException;
import com.mosso.client.cloudfiles.FilesCDNContainer;
import com.mosso.client.cloudfiles.FilesContainer;
import com.mosso.client.cloudfiles.FilesContainerExistsException;
import com.mosso.client.cloudfiles.FilesContainerInfo;
import com.mosso.client.cloudfiles.FilesContainerNotEmptyException;
import com.mosso.client.cloudfiles.FilesException;
import com.mosso.client.cloudfiles.FilesInvalidNameException;
import com.mosso.client.cloudfiles.FilesNotFoundException;
import com.mosso.client.cloudfiles.FilesObject;
import com.mosso.client.cloudfiles.FilesObjectMetaData;
import com.mosso.client.cloudfiles.FilesResponse;
import com.mosso.client.cloudfiles.FilesUtil;
import com.mosso.client.cloudfiles.IFilesTransferCallback;
import com.mosso.client.cloudfiles.wrapper.RequestEntityWrapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesClient {
    public static final String VERSION = "v1";
    private String username = null;
    private String password = null;
    private String account = null;
    private String authenticationURL;
    private int connectionTimeOut;
    private String storageURL = null;
    private String cdnManagementURL = null;
    private String authToken = null;
    private boolean isLoggedin = false;
    private boolean useETag = true;
    private HttpClient client = new HttpClient();
    private static Logger logger = Logger.getLogger(FilesClient.class);

    public FilesClient(String username, String password, String account, int connectionTimeOut) {
        this.username = username;
        this.password = password;
        this.account = account;
        this.authenticationURL = account != null && account.length() > 0 ? FilesUtil.getProperty("auth_url") + VERSION + "/" + account + FilesUtil.getProperty("auth_url_post") : FilesUtil.getProperty("auth_url");
        this.connectionTimeOut = connectionTimeOut;
        this.client.getParams().setParameter("http.socket.timeout", (Object)this.connectionTimeOut);
        this.setUserAgent("java-cloudfiles/1.3.1");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UserName: " + this.username));
            logger.debug((Object)("AuthenticationURL: " + this.authenticationURL));
            logger.debug((Object)("ConnectionTimeOut: " + this.connectionTimeOut));
        }
    }

    public FilesClient(String username, String password, String account) {
        this(username, password, account, FilesUtil.getIntProperty("connection_timeout"));
    }

    public FilesClient(String username, String apiAccessKey) {
        this(username, apiAccessKey, null, FilesUtil.getIntProperty("connection_timeout"));
    }

    public FilesClient() {
        this(FilesUtil.getProperty("username"), FilesUtil.getProperty("password"), FilesUtil.getProperty("account"), FilesUtil.getIntProperty("connection_timeout"));
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
        this.authenticationURL = account != null && account.length() > 0 ? FilesUtil.getProperty("auth_url") + VERSION + "/" + account + FilesUtil.getProperty("auth_url_post") : FilesUtil.getProperty("auth_url");
    }

    public boolean login() throws IOException, HttpException {
        GetMethod method = new GetMethod(this.authenticationURL);
        method.getParams().setSoTimeout(this.connectionTimeOut);
        method.setRequestHeader("x-auth-user", this.username);
        method.setRequestHeader("x-auth-key", this.password);
        logger.debug((Object)("Logging in user: " + this.username + " using URL: " + this.authenticationURL));
        this.client.executeMethod((HttpMethod)method);
        FilesResponse response = new FilesResponse((HttpMethod)method);
        if (response.loginSuccess()) {
            this.isLoggedin = true;
            this.storageURL = response.getStorageURL();
            this.cdnManagementURL = response.getCDNManagementURL();
            this.authToken = response.getAuthToken();
            logger.debug((Object)("storageURL: " + this.storageURL));
            logger.debug((Object)("authToken: " + this.authToken));
            logger.debug((Object)("cdnManagementURL:" + this.cdnManagementURL));
        }
        method.releaseConnection();
        return this.isLoggedin;
    }

    public List<FilesContainerInfo> listContainersInfo() throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listContainersInfo(-1, null);
    }

    public List<FilesContainerInfo> listContainersInfo(int limit) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listContainersInfo(limit, null);
    }

    public List<FilesContainerInfo> listContainersInfo(int limit, String marker) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        if (!this.isLoggedin()) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        GetMethod method = null;
        try {
            method = new GetMethod(this.storageURL);
            method.getParams().setSoTimeout(this.connectionTimeOut);
            method.setRequestHeader("X-Auth-Token", this.authToken);
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            if (limit > 0) {
                parameters.add(new NameValuePair("limit", String.valueOf(limit)));
            }
            if (marker != null) {
                parameters.add(new NameValuePair("marker", marker));
            }
            parameters.add(new NameValuePair("format", "xml"));
            method.setQueryString(parameters.toArray(new NameValuePair[parameters.size()]));
            this.client.executeMethod((HttpMethod)method);
            FilesResponse response = new FilesResponse((HttpMethod)method);
            if (response.getStatusCode() == 401) {
                method.removeRequestHeader("X-Auth-Token");
                if (this.login()) {
                    method = new GetMethod(this.storageURL);
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    method.setQueryString(parameters.toArray(new NameValuePair[parameters.size()]));
                    this.client.executeMethod((HttpMethod)method);
                    response = new FilesResponse((HttpMethod)method);
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 200) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(response.getResponseBodyAsStream());
                NodeList nodes = document.getChildNodes();
                Node accountNode = nodes.item(0);
                if (!"account".equals(accountNode.getNodeName())) {
                    logger.error((Object)"Got unexpected type of XML");
                    List<FilesContainerInfo> list = null;
                    return list;
                }
                ArrayList<FilesContainerInfo> containerList = new ArrayList<FilesContainerInfo>();
                NodeList containerNodes = accountNode.getChildNodes();
                for (int i = 0; i < containerNodes.getLength(); ++i) {
                    Node containerNode = containerNodes.item(i);
                    if (!"container".equals(containerNode.getNodeName())) continue;
                    String name = null;
                    int count = -1;
                    long size = -1L;
                    NodeList objectData = containerNode.getChildNodes();
                    for (int j = 0; j < objectData.getLength(); ++j) {
                        Node data = objectData.item(j);
                        if ("name".equals(data.getNodeName())) {
                            name = data.getTextContent();
                            continue;
                        }
                        if ("bytes".equals(data.getNodeName())) {
                            size = Long.parseLong(data.getTextContent());
                            continue;
                        }
                        if ("count".equals(data.getNodeName())) {
                            count = Integer.parseInt(data.getTextContent());
                            continue;
                        }
                        logger.warn((Object)("Unexpected container-info tag:" + data.getNodeName()));
                    }
                    if (name == null) continue;
                    FilesContainerInfo obj = new FilesContainerInfo(name, count, size);
                    containerList.add(obj);
                }
                ArrayList<FilesContainerInfo> arrayList = containerList;
                return arrayList;
            }
            if (response.getStatusCode() == 204) {
                ArrayList<FilesContainerInfo> arrayList = new ArrayList<FilesContainerInfo>();
                return arrayList;
            }
            try {
                if (response.getStatusCode() == 404) {
                    throw new FilesNotFoundException("Account not Found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new FilesException("Unexpected Return Code", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (Exception ex) {
                throw new FilesException("Unexpected problem, probably in parsing Server XML", ex);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public List<FilesContainer> listContainers() throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listContainers(-1, null);
    }

    public List<FilesContainer> listContainers(int limit) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listContainers(limit, null);
    }

    public List<FilesContainer> listContainers(int limit, String marker) throws IOException, HttpException, FilesException {
        if (!this.isLoggedin()) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        GetMethod method = null;
        try {
            method = new GetMethod(this.storageURL);
            method.getParams().setSoTimeout(this.connectionTimeOut);
            method.setRequestHeader("X-Auth-Token", this.authToken);
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            if (limit > 0) {
                parameters.add(new NameValuePair("limit", String.valueOf(limit)));
            }
            if (marker != null) {
                parameters.add(new NameValuePair("marker", marker));
            }
            if (parameters.size() > 0) {
                method.setQueryString(parameters.toArray(new NameValuePair[parameters.size()]));
            }
            this.client.executeMethod((HttpMethod)method);
            FilesResponse response = new FilesResponse((HttpMethod)method);
            if (response.getStatusCode() == 401) {
                method.releaseConnection();
                if (this.login()) {
                    method = new GetMethod(this.storageURL);
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    if (parameters.size() > 0) {
                        method.setQueryString(parameters.toArray(new NameValuePair[parameters.size()]));
                    }
                    this.client.executeMethod((HttpMethod)method);
                    response = new FilesResponse((HttpMethod)method);
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 200) {
                StrTokenizer tokenize = new StrTokenizer(FilesClient.inputStreamToString(response.getResponseBodyAsStream(), method.getResponseCharSet()));
                tokenize.setDelimiterString("\n");
                String[] containers = tokenize.getTokenArray();
                ArrayList<FilesContainer> containerList = new ArrayList<FilesContainer>();
                for (String container : containers) {
                    containerList.add(new FilesContainer(container, this));
                }
                ArrayList<FilesContainer> arrayList = containerList;
                return arrayList;
            }
            if (response.getStatusCode() == 204) {
                ArrayList<FilesContainer> arrayList = new ArrayList<FilesContainer>();
                return arrayList;
            }
            try {
                if (response.getStatusCode() == 404) {
                    throw new FilesNotFoundException("Account was not found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new FilesException("Unexpected resposne from server", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (Exception ex) {
                throw new FilesException("Unexpected error, probably parsing Server XML", ex);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public List<FilesObject> listObjectsStaringWith(String container, String startsWith, String path, int limit, String marker) throws IOException, HttpException, FilesException {
        if (!this.isLoggedin()) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        if (!this.isValidContianerName(container)) {
            throw new FilesInvalidNameException(container);
        }
        GetMethod method = null;
        try {
            method = new GetMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container));
            method.getParams().setSoTimeout(this.connectionTimeOut);
            method.setRequestHeader("X-Auth-Token", this.authToken);
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            parameters.add(new NameValuePair("format", "xml"));
            if (startsWith != null) {
                parameters.add(new NameValuePair("prefix", startsWith));
            }
            if (path != null) {
                parameters.add(new NameValuePair("path", path));
            }
            if (limit > 0) {
                parameters.add(new NameValuePair("limit", String.valueOf(limit)));
            }
            if (marker != null) {
                parameters.add(new NameValuePair("marker", marker));
            }
            if (parameters.size() > 0) {
                method.setQueryString(parameters.toArray(new NameValuePair[parameters.size()]));
            }
            this.client.executeMethod((HttpMethod)method);
            FilesResponse response = new FilesResponse((HttpMethod)method);
            if (response.getStatusCode() == 401) {
                method.removeRequestHeader("X-Auth-Token");
                if (this.login()) {
                    method = new GetMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container));
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    if (parameters.size() > 0) {
                        method.setQueryString(parameters.toArray(new NameValuePair[parameters.size()]));
                    }
                    this.client.executeMethod((HttpMethod)method);
                    response = new FilesResponse((HttpMethod)method);
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 200) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(response.getResponseBodyAsStream());
                NodeList nodes = document.getChildNodes();
                Node containerList = nodes.item(0);
                if (!"container".equals(containerList.getNodeName())) {
                    logger.error((Object)"Got unexpected type of XML");
                    List<FilesObject> list = null;
                    return list;
                }
                ArrayList<FilesObject> objectList = new ArrayList<FilesObject>();
                NodeList objectNodes = containerList.getChildNodes();
                for (int i = 0; i < objectNodes.getLength(); ++i) {
                    Node objectNode = objectNodes.item(i);
                    if (!"object".equals(objectNode.getNodeName())) continue;
                    String name = null;
                    String eTag = null;
                    long size = -1L;
                    String mimeType = null;
                    String lastModified = null;
                    NodeList objectData = objectNode.getChildNodes();
                    for (int j = 0; j < objectData.getLength(); ++j) {
                        Node data = objectData.item(j);
                        if ("name".equals(data.getNodeName())) {
                            name = data.getTextContent();
                            continue;
                        }
                        if ("content_type".equals(data.getNodeName())) {
                            mimeType = data.getTextContent();
                            continue;
                        }
                        if ("hash".equals(data.getNodeName())) {
                            eTag = data.getTextContent();
                            continue;
                        }
                        if ("bytes".equals(data.getNodeName())) {
                            size = Long.parseLong(data.getTextContent());
                            continue;
                        }
                        if ("last_modified".equals(data.getNodeName())) {
                            lastModified = data.getTextContent();
                            continue;
                        }
                        logger.warn((Object)("Unexpected tag:" + data.getNodeName()));
                    }
                    if (name == null) continue;
                    FilesObject obj = new FilesObject(name, container, this);
                    if (eTag != null) {
                        obj.setMd5sum(eTag);
                    }
                    if (mimeType != null) {
                        obj.setMimeType(mimeType);
                    }
                    if (size > 0L) {
                        obj.setSize(size);
                    }
                    if (lastModified != null) {
                        obj.setLastModified(lastModified);
                    }
                    objectList.add(obj);
                }
                ArrayList<FilesObject> arrayList = objectList;
                return arrayList;
            }
            if (response.getStatusCode() == 204) {
                logger.debug((Object)("Container " + container + " has no Objects"));
                ArrayList<FilesObject> arrayList = new ArrayList<FilesObject>();
                return arrayList;
            }
            try {
                if (response.getStatusCode() == 404) {
                    throw new FilesNotFoundException("Container was not found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new FilesException("Unexpected Server Result", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (Exception ex) {
                logger.error((Object)"Error parsing xml", (Throwable)ex);
                throw new FilesException("Error parsing server resposne", ex);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public List<FilesObject> listObjects(String container) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStaringWith(container, null, null, -1, null);
    }

    public List<FilesObject> listObjects(String container, int limit) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStaringWith(container, null, null, limit, null);
    }

    public List<FilesObject> listObjects(String container, String path) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStaringWith(container, null, path, -1, null);
    }

    public List<FilesObject> listObjects(String container, String path, int limit) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStaringWith(container, null, path, limit, null);
    }

    public List<FilesObject> listObjects(String container, String path, int limit, String marker) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStaringWith(container, null, path, limit, marker);
    }

    public List<FilesObject> listObjects(String container, int limit, String marker) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStaringWith(container, null, null, limit, marker);
    }

    public boolean containerExists(String container) throws IOException, HttpException {
        try {
            this.getContainerInfo(container);
            return true;
        }
        catch (FilesException fnfe) {
            return false;
        }
    }

    public FilesAccountInfo getAccountInfo() throws IOException, HttpException, FilesAuthorizationException, FilesException {
        if (this.isLoggedin()) {
            HeadMethod method = new HeadMethod(this.storageURL);
            method.getParams().setSoTimeout(this.connectionTimeOut);
            method.setRequestHeader("X-Auth-Token", this.authToken);
            this.client.executeMethod((HttpMethod)method);
            FilesResponse response = new FilesResponse((HttpMethod)method);
            if (response.getStatusCode() == 401) {
                method.removeRequestHeader("X-Auth-Token");
                if (this.login()) {
                    method = new HeadMethod(this.storageURL);
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    this.client.executeMethod((HttpMethod)method);
                    response = new FilesResponse((HttpMethod)method);
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 204) {
                int nContainers = response.getAccountContainerCount();
                long totalSize = response.getAccountBytesUsed();
                return new FilesAccountInfo(totalSize, nContainers);
            }
            throw new FilesException("Unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public FilesContainerInfo getContainerInfo(String container) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContianerName(container)) {
                HeadMethod method = null;
                try {
                    method = new HeadMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container));
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    this.client.executeMethod((HttpMethod)method);
                    FilesResponse response = new FilesResponse((HttpMethod)method);
                    if (response.getStatusCode() == 401) {
                        method.removeRequestHeader("X-Auth-Token");
                        if (this.login()) {
                            method = new HeadMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container));
                            method.getParams().setSoTimeout(this.connectionTimeOut);
                            method.setRequestHeader("X-Auth-Token", this.authToken);
                            this.client.executeMethod((HttpMethod)method);
                            response = new FilesResponse((HttpMethod)method);
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 204) {
                        int objCount = response.getContainerObjectCount();
                        long objSize = response.getContainerBytesUsed();
                        FilesContainerInfo filesContainerInfo = new FilesContainerInfo(container, objCount, objSize);
                        return filesContainerInfo;
                    }
                    if (response.getStatusCode() == 404) {
                        throw new FilesNotFoundException("Container not found: " + container, response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected result from server", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public void createContainer(String name) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContianerName(name)) {
                PutMethod method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(name));
                method.getParams().setSoTimeout(this.connectionTimeOut);
                method.setRequestHeader("X-Auth-Token", this.authToken);
                try {
                    this.client.executeMethod((HttpMethod)method);
                    FilesResponse response = new FilesResponse((HttpMethod)method);
                    if (response.getStatusCode() == 401) {
                        method.releaseConnection();
                        if (this.login()) {
                            method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(name));
                            method.getParams().setSoTimeout(this.connectionTimeOut);
                            method.setRequestHeader("X-Auth-Token", this.authToken);
                            this.client.executeMethod((HttpMethod)method);
                            response = new FilesResponse((HttpMethod)method);
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 201) {
                        return;
                    }
                    if (response.getStatusCode() == 202) {
                        throw new FilesContainerExistsException(name, response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected Response", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    method.releaseConnection();
                }
            }
            throw new FilesInvalidNameException(name);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteContainer(String name) throws IOException, HttpException, FilesAuthorizationException, FilesInvalidNameException, FilesNotFoundException, FilesContainerNotEmptyException {
        block12: {
            if (this.isLoggedin()) {
                if (this.isValidContianerName(name)) {
                    DeleteMethod method = new DeleteMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(name));
                    try {
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        this.client.executeMethod((HttpMethod)method);
                        FilesResponse response = new FilesResponse((HttpMethod)method);
                        if (response.getStatusCode() == 401) {
                            method.releaseConnection();
                            if (this.login()) {
                                method = new DeleteMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(name));
                                method.getParams().setSoTimeout(this.connectionTimeOut);
                                method.setRequestHeader("X-Auth-Token", this.authToken);
                                this.client.executeMethod((HttpMethod)method);
                                response = new FilesResponse((HttpMethod)method);
                            } else {
                                throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                            }
                        }
                        if (response.getStatusCode() == 204) {
                            logger.debug((Object)("Container Deleted : " + name));
                            boolean bl = true;
                            return bl;
                        }
                        if (response.getStatusCode() == 404) {
                            logger.debug((Object)"Container does not exist !");
                            throw new FilesNotFoundException("You can't delete an non-empty container", response.getResponseHeaders(), response.getStatusLine());
                        }
                        if (response.getStatusCode() == 409) {
                            logger.debug((Object)"Container is not empty, can not delete a none empty container !");
                            throw new FilesContainerNotEmptyException("You can't delete an non-empty container", response.getResponseHeaders(), response.getStatusLine());
                        }
                        break block12;
                    }
                    finally {
                        method.releaseConnection();
                    }
                }
                throw new FilesInvalidNameException(name);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cdnEnableContainer(String name) throws IOException, HttpException, FilesException {
        String returnValue;
        block10: {
            returnValue = null;
            if (this.isLoggedin()) {
                if (this.isValidContianerName(name)) {
                    PutMethod method = null;
                    try {
                        method = new PutMethod(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(name));
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        this.client.executeMethod((HttpMethod)method);
                        FilesResponse response = new FilesResponse((HttpMethod)method);
                        if (response.getStatusCode() == 401) {
                            method.releaseConnection();
                            if (this.login()) {
                                method = new PutMethod(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(name));
                                method.getParams().setSoTimeout(this.connectionTimeOut);
                                method.setRequestHeader("X-Auth-Token", this.authToken);
                                this.client.executeMethod((HttpMethod)method);
                                response = new FilesResponse((HttpMethod)method);
                            } else {
                                throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                            }
                        }
                        if (response.getStatusCode() == 201 || response.getStatusCode() == 202) {
                            returnValue = response.getCdnUrl();
                            break block10;
                        }
                        if (response.getStatusCode() == 401) {
                            logger.warn((Object)"Unauthorized access");
                            throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                        }
                        throw new FilesException("Unexpected Server Response", response.getResponseHeaders(), response.getStatusLine());
                    }
                    finally {
                        method.releaseConnection();
                    }
                }
                throw new FilesInvalidNameException(name);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cdnUpdateContainer(String name, int ttl, boolean enabled) throws IOException, HttpException, FilesException {
        String returnValue;
        block13: {
            returnValue = null;
            if (this.isLoggedin()) {
                if (this.isValidContianerName(name)) {
                    PostMethod method = null;
                    try {
                        method = new PostMethod(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(name));
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        if (ttl > 0) {
                            method.setRequestHeader("X-TTL", Integer.toString(ttl));
                        }
                        method.setRequestHeader("X-CDN-Enabled", Boolean.toString(enabled));
                        this.client.executeMethod((HttpMethod)method);
                        FilesResponse response = new FilesResponse((HttpMethod)method);
                        if (response.getStatusCode() == 401) {
                            method.releaseConnection();
                            if (this.login()) {
                                new PostMethod(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(name));
                                method.getParams().setSoTimeout(this.connectionTimeOut);
                                method.setRequestHeader("X-Auth-Token", this.authToken);
                                if (ttl > 0) {
                                    method.setRequestHeader("X-TTL", Integer.toString(ttl));
                                }
                                method.setRequestHeader("X-CDN-Enabled", Boolean.toString(enabled));
                                this.client.executeMethod((HttpMethod)method);
                                response = new FilesResponse((HttpMethod)method);
                            } else {
                                throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                            }
                        }
                        if (response.getStatusCode() == 202) {
                            returnValue = response.getCdnUrl();
                            break block13;
                        }
                        if (response.getStatusCode() == 401) {
                            logger.warn((Object)"Unauthorized access");
                            throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                        }
                        throw new FilesException("Unexpected Server Response", response.getResponseHeaders(), response.getStatusLine());
                    }
                    finally {
                        if (method != null) {
                            method.releaseConnection();
                        }
                    }
                }
                throw new FilesInvalidNameException(name);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        return returnValue;
    }

    public FilesCDNContainer getCDNContainerInfo(String container) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContianerName(container)) {
                HeadMethod method = null;
                try {
                    method = new HeadMethod(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(container));
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    this.client.executeMethod((HttpMethod)method);
                    FilesResponse response = new FilesResponse((HttpMethod)method);
                    if (response.getStatusCode() == 401) {
                        method.releaseConnection();
                        if (this.login()) {
                            method = new HeadMethod(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(container));
                            method.getParams().setSoTimeout(this.connectionTimeOut);
                            method.setRequestHeader("X-Auth-Token", this.authToken);
                            this.client.executeMethod((HttpMethod)method);
                            response = new FilesResponse((HttpMethod)method);
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 204) {
                        FilesCDNContainer result = new FilesCDNContainer(response.getCdnUrl());
                        result.setName(container);
                        for (Header hdr : response.getResponseHeaders()) {
                            String name = hdr.getName().toLowerCase();
                            if ("x-cdn-enabled".equals(name)) {
                                result.setEnabled(Boolean.valueOf(hdr.getValue()));
                                continue;
                            }
                            if (!"x-ttl".equals(name)) continue;
                            result.setTtl(Integer.parseInt(hdr.getValue()));
                        }
                        FilesCDNContainer filesCDNContainer = result;
                        return filesCDNContainer;
                    }
                    if (response.getStatusCode() == 401) {
                        logger.warn((Object)"Unauthorized access");
                        throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected result from server: ", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public void createPath(String container, String path) throws HttpException, IOException, FilesException {
        if (!this.isValidContianerName(container)) {
            throw new FilesInvalidNameException(container);
        }
        if (!this.isValidObjectName(path)) {
            throw new FilesInvalidNameException(path);
        }
        this.storeObject(container, new byte[0], "application/directory", path, new HashMap<String, String>());
    }

    public void createFullPath(String container, String path) throws HttpException, IOException, FilesException {
        String[] parts = path.split("/");
        for (int i = 0; i < parts.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                if (sb.length() != 0) {
                    sb.append("/");
                }
                sb.append(parts[j]);
            }
            this.createPath(container, sb.toString());
        }
    }

    public List<String> listCdnContainers(int limit) throws IOException, HttpException, FilesException {
        return this.listCdnContainers(limit, null);
    }

    public List<String> listCdnContainers() throws IOException, HttpException, FilesException {
        return this.listCdnContainers(-1, null);
    }

    public List<String> listCdnContainers(int limit, String marker) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            GetMethod method = null;
            try {
                method = new GetMethod(this.cdnManagementURL);
                method.getParams().setSoTimeout(this.connectionTimeOut);
                method.setRequestHeader("X-Auth-Token", this.authToken);
                LinkedList<NameValuePair> params = new LinkedList<NameValuePair>();
                if (limit > 0) {
                    params.add(new NameValuePair("limit", String.valueOf(limit)));
                }
                if (marker != null) {
                    params.add(new NameValuePair("marker", marker));
                }
                if (params.size() > 0) {
                    method.setQueryString(params.toArray(new NameValuePair[params.size()]));
                }
                this.client.executeMethod((HttpMethod)method);
                FilesResponse response = new FilesResponse((HttpMethod)method);
                if (response.getStatusCode() == 401) {
                    method.releaseConnection();
                    if (this.login()) {
                        method = new GetMethod(this.cdnManagementURL);
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        if (params.size() > 0) {
                            method.setQueryString(params.toArray(new NameValuePair[params.size()]));
                        }
                        this.client.executeMethod((HttpMethod)method);
                        response = new FilesResponse((HttpMethod)method);
                    } else {
                        throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                    }
                }
                if (response.getStatusCode() == 200) {
                    StrTokenizer tokenize = new StrTokenizer(FilesClient.inputStreamToString(response.getResponseBodyAsStream(), method.getResponseCharSet()));
                    tokenize.setDelimiterString("\n");
                    String[] containers = tokenize.getTokenArray();
                    ArrayList<String> returnValue = new ArrayList<String>();
                    for (String containerName : containers) {
                        returnValue.add(containerName);
                    }
                    ArrayList<String> arrayList = returnValue;
                    return arrayList;
                }
                if (response.getStatusCode() == 401) {
                    logger.warn((Object)"Unauthorized access");
                    throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new FilesException("Unexpected server response", response.getResponseHeaders(), response.getStatusLine());
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public List<FilesCDNContainer> listCdnContainerInfo() throws IOException, HttpException, FilesException {
        return this.listCdnContainerInfo(-1, null);
    }

    public List<FilesCDNContainer> listCdnContainerInfo(int limit) throws IOException, HttpException, FilesException {
        return this.listCdnContainerInfo(limit, null);
    }

    public List<FilesCDNContainer> listCdnContainerInfo(int limit, String marker) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            GetMethod method = null;
            try {
                method = new GetMethod(this.cdnManagementURL);
                method.getParams().setSoTimeout(this.connectionTimeOut);
                method.setRequestHeader("X-Auth-Token", this.authToken);
                LinkedList<NameValuePair> params = new LinkedList<NameValuePair>();
                params.add(new NameValuePair("format", "xml"));
                if (limit > 0) {
                    params.add(new NameValuePair("limit", String.valueOf(limit)));
                }
                if (marker != null) {
                    params.add(new NameValuePair("marker", marker));
                }
                method.setQueryString(params.toArray(new NameValuePair[params.size()]));
                this.client.executeMethod((HttpMethod)method);
                FilesResponse response = new FilesResponse((HttpMethod)method);
                if (response.getStatusCode() == 401) {
                    method.releaseConnection();
                    if (this.login()) {
                        method = new GetMethod(this.cdnManagementURL);
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        method.setQueryString(params.toArray(new NameValuePair[params.size()]));
                        this.client.executeMethod((HttpMethod)method);
                        response = new FilesResponse((HttpMethod)method);
                    } else {
                        throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                    }
                }
                if (response.getStatusCode() == 200) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(response.getResponseBodyAsStream());
                    NodeList nodes = document.getChildNodes();
                    Node accountNode = nodes.item(0);
                    if (!"account".equals(accountNode.getNodeName())) {
                        logger.error((Object)"Got unexpected type of XML");
                        List<FilesCDNContainer> list = null;
                        return list;
                    }
                    ArrayList<FilesCDNContainer> containerList = new ArrayList<FilesCDNContainer>();
                    NodeList containerNodes = accountNode.getChildNodes();
                    for (int i = 0; i < containerNodes.getLength(); ++i) {
                        Node containerNode = containerNodes.item(i);
                        if (!"container".equals(containerNode.getNodeName())) continue;
                        FilesCDNContainer container = new FilesCDNContainer();
                        NodeList objectData = containerNode.getChildNodes();
                        for (int j = 0; j < objectData.getLength(); ++j) {
                            Node data = objectData.item(j);
                            if ("name".equals(data.getNodeName())) {
                                container.setName(data.getTextContent());
                                continue;
                            }
                            if ("cdn_url".equals(data.getNodeName())) {
                                container.setCdnURL(data.getTextContent());
                                continue;
                            }
                            if ("cdn_enabled".equals(data.getNodeName())) {
                                container.setEnabled(Boolean.parseBoolean(data.getTextContent()));
                                continue;
                            }
                            if (!"ttl".equals(data.getNodeName())) continue;
                            container.setTtl(Integer.parseInt(data.getTextContent()));
                        }
                        if (container.getName() == null) continue;
                        containerList.add(container);
                    }
                    ArrayList<FilesCDNContainer> arrayList = containerList;
                    return arrayList;
                }
                try {
                    if (response.getStatusCode() == 401) {
                        logger.warn((Object)"Unauthorized access");
                        throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected server response", response.getResponseHeaders(), response.getStatusLine());
                }
                catch (SAXException ex) {
                    throw new FilesException("Problem parsing XML", ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new FilesException("Problem parsing XML", ex);
                }
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public boolean storeObjectAs(String container, File obj, String contentType, String name) throws IOException, HttpException, FilesException {
        return this.storeObjectAs(container, obj, contentType, name, new HashMap<String, String>(), null);
    }

    public boolean storeObjectAs(String container, File obj, String contentType, String name, IFilesTransferCallback callback) throws IOException, HttpException, FilesException {
        return this.storeObjectAs(container, obj, contentType, name, new HashMap<String, String>(), callback);
    }

    public boolean storeObjectAs(String container, File obj, String contentType, String name, Map<String, String> metadata) throws IOException, HttpException, FilesException {
        return this.storeObjectAs(container, obj, contentType, name, metadata, null);
    }

    public boolean storeObjectAs(String container, File obj, String contentType, String name, Map<String, String> metadata, IFilesTransferCallback callback) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContianerName(container) && this.isValidObjectName(name)) {
                if (!obj.exists()) {
                    throw new FileNotFoundException(name + " does not exist");
                }
                if (obj.isDirectory()) {
                    throw new IOException("The alleged file was a directory");
                }
                PutMethod method = null;
                try {
                    method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(name));
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    if (this.useETag) {
                        method.setRequestHeader("ETag", FilesClient.md5Sum(obj));
                    }
                    method.setRequestEntity((RequestEntity)new RequestEntityWrapper((RequestEntity)new FileRequestEntity(obj, contentType), callback));
                    for (String key : metadata.keySet()) {
                        method.setRequestHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                    }
                    this.client.executeMethod((HttpMethod)method);
                    FilesResponse response = new FilesResponse((HttpMethod)method);
                    if (response.getStatusCode() == 401) {
                        method.releaseConnection();
                        if (this.login()) {
                            method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(name));
                            method.getParams().setSoTimeout(this.connectionTimeOut);
                            method.setRequestHeader("X-Auth-Token", this.authToken);
                            if (this.useETag) {
                                method.setRequestHeader("ETag", FilesClient.md5Sum(obj));
                            }
                            method.setRequestEntity((RequestEntity)new RequestEntityWrapper((RequestEntity)new FileRequestEntity(obj, contentType), callback));
                            for (String key : metadata.keySet()) {
                                method.setRequestHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                            }
                            this.client.executeMethod((HttpMethod)method);
                            response = new FilesResponse((HttpMethod)method);
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 201) {
                        boolean bl = true;
                        return bl;
                    }
                    if (response.getStatusCode() == 412) {
                        throw new FilesException("Etag missmatch", response.getResponseHeaders(), response.getStatusLine());
                    }
                    if (response.getStatusCode() == 411) {
                        throw new FilesException("Length miss-match", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected Server Response", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
            }
            if (!this.isValidObjectName(name)) {
                throw new FilesInvalidNameException(name);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public boolean storeObject(String container, File obj, String contentType) throws IOException, HttpException, FilesException {
        return this.storeObjectAs(container, obj, contentType, obj.getName());
    }

    public boolean storeObject(String container, byte[] obj, String contentType, String name, Map<String, String> metadata) throws IOException, HttpException, FilesException {
        return this.storeObject(container, obj, contentType, name, metadata, null);
    }

    public boolean storeObject(String container, byte[] obj, String contentType, String name, Map<String, String> metadata, IFilesTransferCallback callback) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            String objName = name;
            if (this.isValidContianerName(container) && this.isValidObjectName(objName)) {
                PutMethod method = null;
                try {
                    method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    if (this.useETag) {
                        method.setRequestHeader("ETag", FilesClient.md5Sum(obj));
                    }
                    method.setRequestEntity((RequestEntity)new RequestEntityWrapper((RequestEntity)new ByteArrayRequestEntity(obj, contentType), callback));
                    for (String key : metadata.keySet()) {
                        method.setRequestHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                    }
                    this.client.executeMethod((HttpMethod)method);
                    FilesResponse response = new FilesResponse((HttpMethod)method);
                    if (response.getStatusCode() == 401) {
                        method.releaseConnection();
                        if (this.login()) {
                            method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                            method.getParams().setSoTimeout(this.connectionTimeOut);
                            method.setRequestHeader("X-Auth-Token", this.authToken);
                            if (this.useETag) {
                                method.setRequestHeader("ETag", FilesClient.md5Sum(obj));
                            }
                            method.setRequestEntity((RequestEntity)new RequestEntityWrapper((RequestEntity)new ByteArrayRequestEntity(obj, contentType), callback));
                            for (String key : metadata.keySet()) {
                                method.setRequestHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                            }
                            this.client.executeMethod((HttpMethod)method);
                            response = new FilesResponse((HttpMethod)method);
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 201) {
                        boolean bl = true;
                        return bl;
                    }
                    if (response.getStatusCode() == 412) {
                        throw new FilesException("Etag missmatch", response.getResponseHeaders(), response.getStatusLine());
                    }
                    if (response.getStatusCode() == 411) {
                        throw new FilesException("Length miss-match", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected Server Response", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
            }
            if (!this.isValidObjectName(objName)) {
                throw new FilesInvalidNameException(objName);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public boolean storeStreamedObject(String container, InputStream data, String contentType, String name, Map<String, String> metadata) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            String objName = name;
            if (this.isValidContianerName(container) && this.isValidObjectName(objName)) {
                PutMethod method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                method.setContentChunked(true);
                method.getParams().setSoTimeout(this.connectionTimeOut);
                method.setRequestHeader("X-Auth-Token", this.authToken);
                method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(data, contentType));
                for (String key : metadata.keySet()) {
                    method.setRequestHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                }
                method.removeRequestHeader("Content-Length");
                try {
                    this.client.executeMethod((HttpMethod)method);
                    FilesResponse response = new FilesResponse((HttpMethod)method);
                    if (response.getStatusCode() == 201) {
                        logger.debug((Object)("Object stored : " + name));
                        boolean bl = true;
                        return bl;
                    }
                    logger.error((Object)response.getStatusLine());
                    throw new FilesException("Unexpected result", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    method.releaseConnection();
                }
            }
            if (!this.isValidObjectName(objName)) {
                throw new FilesInvalidNameException(objName);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public boolean storeObjectAs(String container, String name, RequestEntity entity, Map<String, String> metadata, String md5sum) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            String objName = name;
            if (this.isValidContianerName(container) && this.isValidObjectName(objName)) {
                PutMethod method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                method.getParams().setSoTimeout(this.connectionTimeOut);
                method.setRequestHeader("X-Auth-Token", this.authToken);
                method.setRequestEntity(entity);
                if (this.useETag && md5sum != null) {
                    method.setRequestHeader("ETag", md5sum);
                }
                method.setRequestHeader("Content-Type", entity.getContentType());
                for (String key : metadata.keySet()) {
                    method.setRequestHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                }
                try {
                    this.client.executeMethod((HttpMethod)method);
                    FilesResponse response = new FilesResponse((HttpMethod)method);
                    if (response.getStatusCode() == 401) {
                        this.login();
                        method = new PutMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        method.setRequestEntity(entity);
                        method.setRequestHeader("Content-Type", entity.getContentType());
                        for (String key : metadata.keySet()) {
                            method.setRequestHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                        }
                        this.client.executeMethod((HttpMethod)method);
                        response = new FilesResponse((HttpMethod)method);
                    }
                    if (response.getStatusCode() == 201) {
                        logger.debug((Object)("Object stored : " + name));
                        boolean bl = true;
                        return bl;
                    }
                    logger.debug((Object)response.getStatusLine());
                    throw new FilesException("Unexpected result", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    method.releaseConnection();
                }
            }
            if (!this.isValidObjectName(objName)) {
                throw new FilesInvalidNameException(objName);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(String container, String objName) throws IOException, HttpException, FilesException {
        block9: {
            if (this.isLoggedin()) {
                if (this.isValidContianerName(container) && this.isValidObjectName(objName)) {
                    DeleteMethod method = null;
                    try {
                        method = new DeleteMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        this.client.executeMethod((HttpMethod)method);
                        FilesResponse response = new FilesResponse((HttpMethod)method);
                        if (response.getStatusCode() == 204) {
                            logger.debug((Object)("Object Deleted : " + objName));
                            break block9;
                        }
                        if (response.getStatusCode() == 404) {
                            throw new FilesNotFoundException("Object was not found " + objName, response.getResponseHeaders(), response.getStatusLine());
                        }
                        throw new FilesException("Unexpected status from server", response.getResponseHeaders(), response.getStatusLine());
                    }
                    finally {
                        if (method != null) {
                            method.releaseConnection();
                        }
                    }
                }
                if (!this.isValidObjectName(objName)) {
                    throw new FilesInvalidNameException(objName);
                }
                throw new FilesInvalidNameException(container);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FilesObjectMetaData getObjectMetaData(String container, String objName) throws IOException, HttpException, FilesAuthorizationException, FilesInvalidNameException {
        HeadMethod method;
        if (!this.isLoggedin()) throw new FilesAuthorizationException("You must be logged in", null, null);
        if (this.isValidContianerName(container) && this.isValidObjectName(objName)) {
            method = new HeadMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
            method.getParams().setSoTimeout(this.connectionTimeOut);
            method.setRequestHeader("X-Auth-Token", this.authToken);
            this.client.executeMethod((HttpMethod)method);
            FilesResponse response = new FilesResponse((HttpMethod)method);
            if (response.getStatusCode() == 204) {
                logger.debug((Object)("Object metadata retreived  : " + objName));
                String mimeType = response.getContentType();
                String lastModified = response.getLastModified();
                String eTag = response.getETag();
                String contentLength = response.getContentLength();
                FilesObjectMetaData metaData = new FilesObjectMetaData(mimeType, contentLength, eTag, lastModified);
                Header[] headers = response.getResponseHeaders();
                HashMap<String, String> headerMap = new HashMap<String, String>();
                for (Header h : headers) {
                    if (!h.getName().startsWith("X-Object-Meta-")) continue;
                    headerMap.put(h.getName().substring("X-Object-Meta-".length()), FilesClient.unencodeURI(h.getValue()));
                }
                if (headerMap.size() <= 0) return metaData;
                metaData.setMetaData(headerMap);
                return metaData;
            }
            if (response.getStatusCode() == 404) {
                logger.info((Object)("Object " + objName + " was not found  !"));
                return null;
            }
        } else {
            if (this.isValidObjectName(objName)) throw new FilesInvalidNameException(container);
            throw new FilesInvalidNameException(objName);
        }
        method.releaseConnection();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getObject(String container, String objName) throws IOException, HttpException, FilesAuthorizationException, FilesInvalidNameException, FilesNotFoundException {
        GetMethod method;
        if (!this.isLoggedin()) throw new FilesAuthorizationException("You must be logged in", null, null);
        if (this.isValidContianerName(container) && this.isValidObjectName(objName)) {
            method = new GetMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
            method.getParams().setSoTimeout(this.connectionTimeOut);
            method.setRequestHeader("X-Auth-Token", this.authToken);
            this.client.executeMethod((HttpMethod)method);
            FilesResponse response = new FilesResponse((HttpMethod)method);
            if (response.getStatusCode() == 200) {
                logger.debug((Object)("Object data retreived  : " + objName));
                return response.getResponseBody();
            }
            if (response.getStatusCode() == 404) {
                throw new FilesNotFoundException("Container: " + container + " did not have object " + objName, response.getResponseHeaders(), response.getStatusLine());
            }
        } else {
            if (this.isValidObjectName(objName)) throw new FilesInvalidNameException(container);
            throw new FilesInvalidNameException(objName);
        }
        method.releaseConnection();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getObjectAsStream(String container, String objName) throws IOException, HttpException, FilesAuthorizationException, FilesInvalidNameException {
        GetMethod method;
        if (!this.isLoggedin()) throw new FilesAuthorizationException("You must be logged in", null, null);
        if (this.isValidContianerName(container) && this.isValidObjectName(objName)) {
            if (objName.length() > 1024) {
                logger.warn((Object)"Object Name supplied was truncated to Max allowed of 1024 characters !");
                objName = objName.substring(0, 1024);
                logger.warn((Object)("Truncated Object Name is: " + objName));
            }
            method = new GetMethod(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
            method.getParams().setSoTimeout(this.connectionTimeOut);
            method.setRequestHeader("X-Auth-Token", this.authToken);
            this.client.executeMethod((HttpMethod)method);
            FilesResponse response = new FilesResponse((HttpMethod)method);
            if (response.getStatusCode() == 200) {
                logger.info((Object)("Object data retreived  : " + objName));
                return response.getResponseBodyAsStream();
            }
            if (response.getStatusCode() == 404) {
                logger.info((Object)("Object " + objName + " was not found  !"));
                return null;
            }
        } else {
            if (this.isValidObjectName(objName)) throw new FilesInvalidNameException(container);
            throw new FilesInvalidNameException(objName);
        }
        method.releaseConnection();
        return null;
    }

    static void writeInputStreamToFile(InputStream is, File f) throws IOException {
        BufferedOutputStream bf = new BufferedOutputStream(new FileOutputStream(f));
        byte[] buffer = new byte[1024];
        int read = 0;
        while ((read = is.read(buffer)) > 0) {
            bf.write(buffer, 0, read);
        }
        is.close();
        bf.flush();
        bf.close();
    }

    static String inputStreamToString(InputStream stream, String encoding) throws IOException {
        char[] buffer = new char[4096];
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(stream, encoding);
        int nRead = 0;
        while ((nRead = isr.read(buffer)) >= 0) {
            sb.append(buffer, 0, nRead);
        }
        isr.close();
        return sb.toString();
    }

    public static String md5Sum(File f) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(f);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            ((InputStream)is).close();
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String md5 = bigInt.toString(16);
            while (md5.length() != 32) {
                md5 = "0" + md5;
            }
            return md5;
        }
        catch (NoSuchAlgorithmException e) {
            logger.fatal((Object)"The JRE is misconfigured on this computer", (Throwable)e);
            return null;
        }
    }

    public static String md5Sum(byte[] data) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] md5sum = digest.digest(data);
            BigInteger bigInt = new BigInteger(1, md5sum);
            String md5 = bigInt.toString(16);
            while (md5.length() != 32) {
                md5 = "0" + md5;
            }
            return md5;
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.fatal((Object)"Major problems with your Java configuration", (Throwable)nsae);
            return null;
        }
    }

    public static String sanitizeForURI(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(str).replaceAll("\\+", "%20").replaceAll("%2F", "/");
        }
        catch (EncoderException ee) {
            logger.warn((Object)"Error trying to encode string for URI", (Throwable)ee);
            return str;
        }
    }

    public static String unencodeURI(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.decode(str);
        }
        catch (DecoderException ee) {
            logger.warn((Object)"Error trying to encode string for URI", (Throwable)ee);
            return str;
        }
    }

    public int getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public String getStorageURL() {
        return this.storageURL;
    }

    public String getStorageToken() {
        return this.authToken;
    }

    public boolean isLoggedin() {
        return this.isLoggedin;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthenticationURL() {
        return this.authenticationURL;
    }

    public void setAuthenticationURL(String authenticationURL) {
        this.authenticationURL = authenticationURL;
    }

    public boolean getUseETag() {
        return this.useETag;
    }

    public void setUseETag(boolean useETag) {
        this.useETag = useETag;
    }

    public void setUserAgent(String userAgent) {
        this.client.getParams().setParameter("http.useragent", (Object)userAgent);
    }

    public String getUserAgent() {
        return this.client.getParams().getParameter("http.useragent").toString();
    }

    private boolean isValidContianerName(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        if (length == 0 || length > 256) {
            return false;
        }
        return name.indexOf(47) == -1;
    }

    private boolean isValidObjectName(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        return length != 0 && length <= 1024;
    }

    public String getCdnManagementURL() {
        return this.cdnManagementURL;
    }

    public void setHostConfiguration(HostConfiguration config) {
        this.client.setHostConfiguration(config);
    }
}

