/*
 * Decompiled with CFR 0.152.
 */
package com.mosso.client.cloudfiles;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FilesUtil {
    private static Logger logger = Logger.getLogger(FilesUtil.class);
    private static final String file = "cloudfiles.properties";
    private static Properties props = null;

    private static void loadPropertiesFromClasspath() throws IOException {
        props = new Properties();
        InputStream inputStream = FilesUtil.class.getClassLoader().getResourceAsStream(file);
        if (inputStream == null) {
            throw new FileNotFoundException("Property file 'cloudfiles.properties' not found in the classpath");
        }
        props.load(inputStream);
    }

    public static String getProperty(String key) {
        if (props == null) {
            try {
                FilesUtil.loadPropertiesFromClasspath();
            }
            catch (Exception IOException2) {
                logger.warn((Object)"Unable to load properties file.");
                return null;
            }
        }
        return props.getProperty(key);
    }

    public static int getIntProperty(String key) {
        String property = FilesUtil.getProperty(key);
        if (property == null) {
            logger.warn((Object)("Could not load integer property " + key));
            return -1;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)("Invalid format for a number in properties file: " + property), (Throwable)nfe);
            return -1;
        }
    }
}

