/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.util;

import org.w3c.dom.Node;

public class QName {
    private String namespaceURI;
    private String localName;
    private int hashCode;

    public QName(String namespaceURI, String localName) {
        this.namespaceURI = (namespaceURI == null ? "" : namespaceURI).intern();
        this.localName = localName.intern();
        this.hashCode = new StringBuffer().append(this.namespaceURI.hashCode()).append('_').append(this.localName.hashCode()).toString().hashCode();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QName) {
            QName that = (QName)obj;
            return this.namespaceURI == that.namespaceURI && this.localName == that.localName;
        }
        return false;
    }

    public boolean matches(Node node) {
        return node != null && node.getNamespaceURI() != null && node.getLocalName() != null && node.getNamespaceURI().intern() == this.namespaceURI && node.getLocalName().intern() == this.localName;
    }

    public String toString() {
        return this.namespaceURI + ':' + this.localName;
    }
}

