/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDAbstractTableDelegate;
import ch.cyberduck.ui.cocoa.CDControllerCell;
import ch.cyberduck.ui.cocoa.CDListDataSource;
import ch.cyberduck.ui.cocoa.CDTaskController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;

public class CDActivityController
extends CDWindowController {
    private static Logger log = Logger.getLogger(CDActivityController.class);
    private static CDActivityController instance = null;
    private final Map<BackgroundAction, CDTaskController> tasks = Collections.synchronizedMap(new LinkedHashMap());
    private final AbstractCollectionListener<BackgroundAction> backgroundActionListener = new AbstractCollectionListener<BackgroundAction>(){

        public void collectionItemAdded(final BackgroundAction action) {
            CDActivityController.this.invoke((MainAction)new WindowMainAction(CDActivityController.this){

                public void run() {
                    log.debug((Object)("collectionItemAdded:" + action));
                    CDActivityController.this.tasks.put(action, new CDTaskController(action));
                    CDActivityController.this.reload();
                }
            });
        }

        public void collectionItemRemoved(final BackgroundAction action) {
            CDActivityController.this.invoke((MainAction)new WindowMainAction(CDActivityController.this){

                public void run() {
                    log.debug((Object)("collectionItemRemoved:" + action));
                    CDTaskController controller = (CDTaskController)CDActivityController.this.tasks.remove(action);
                    if (null == controller) {
                        return;
                    }
                    controller.invalidate();
                    CDActivityController.this.reload();
                }
            });
        }
    };
    private final TableColumnFactory tableColumnsFactory = new TableColumnFactory();
    private NSTableView table;
    private CDListDataSource model;
    private CDAbstractTableDelegate<CDTaskController> delegate;
    private final NSCell prototype = CDControllerCell.controllerCell();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDActivityController instance() {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (null == instance) {
                instance = new CDActivityController();
            }
            return instance;
        }
    }

    private CDActivityController() {
        this.loadBundle();
        this.init();
    }

    protected void invalidate() {
        BackgroundActionRegistry.instance().removeListener(this.backgroundActionListener);
        this.table.setDataSource(null);
        this.table.setDelegate(null);
        super.invalidate();
    }

    private void init() {
        BackgroundAction[] actions;
        BackgroundActionRegistry.instance().addListener(this.backgroundActionListener);
        for (BackgroundAction action : actions = (BackgroundAction[])BackgroundActionRegistry.instance().toArray((Object[])new BackgroundAction[BackgroundActionRegistry.instance().size()])) {
            this.tasks.put(action, new CDTaskController(action));
        }
        this.reload();
    }

    private void reload() {
        while (this.table.subviews().count().intValue() > 0) {
            Rococoa.cast(this.table.subviews().lastObject(), NSView.class).removeFromSuperviewWithoutNeedingDisplay();
        }
        this.table.reloadData();
    }

    public void setWindow(NSWindow window) {
        window.setTitle(Locale.localizedString((String)"Activity"));
        super.setWindow(window);
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTable(NSTableView table) {
        this.table = table;
        this.model = new CDListDataSource(){

            public NSInteger numberOfRowsInTableView(NSTableView view) {
                return new NSInteger(CDActivityController.this.tasks.size());
            }

            public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                return null;
            }
        };
        this.table.setDataSource(this.model.id());
        this.delegate = new CDAbstractTableDelegate<CDTaskController>(){

            @Override
            public void enterKeyPressed(ID sender) {
            }

            @Override
            public void deleteKeyPressed(ID sender) {
            }

            @Override
            public String tooltip(CDTaskController c) {
                return null;
            }

            @Override
            public boolean tableView_shouldSelectRow(NSTableView view, int row) {
                return false;
            }

            @Override
            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            @Override
            public void tableRowDoubleClicked(ID sender) {
            }

            @Override
            public void selectionDidChange(NSNotification notification) {
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSCell cell, NSTableColumn tableColumn, NSInteger row) {
                Collection values = CDActivityController.this.tasks.values();
                Rococoa.cast(cell, CDControllerCell.class).setView(values.toArray(new CDTaskController[values.size()])[row.intValue()].view());
            }
        };
        this.table.setDelegate(this.delegate.id());
        NSTableColumn c = this.tableColumnsFactory.create("Default");
        c.setMinWidth(80.0);
        c.setWidth(300.0);
        c.setResizingMask(1);
        c.setDataCell(this.prototype);
        this.table.addTableColumn(c);
        this.table.sizeToFit();
    }

    protected String getBundleName() {
        return "Activity";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        private TableColumnFactory() {
        }

        private NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }
}

