/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Archive;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.ConnectionAdapter;
import ch.cyberduck.core.ConnectionListener;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.HiddenFilesPathFilter;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostCollection;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.Keychain;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.NullPathFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.RendezvousCollection;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.Speedometer;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAdapter;
import ch.cyberduck.core.TransferListener;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.ssl.SSLSession;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.util.URLSchemeHandlerConfiguration;
import ch.cyberduck.ui.cocoa.CDAbstractPathTableDelegate;
import ch.cyberduck.ui.cocoa.CDAbstractTableDelegate;
import ch.cyberduck.ui.cocoa.CDBookmarkCell;
import ch.cyberduck.ui.cocoa.CDBookmarkController;
import ch.cyberduck.ui.cocoa.CDBookmarkTableDataSource;
import ch.cyberduck.ui.cocoa.CDBrowserListViewModel;
import ch.cyberduck.ui.cocoa.CDBrowserOutlineViewModel;
import ch.cyberduck.ui.cocoa.CDBrowserTableDataSource;
import ch.cyberduck.ui.cocoa.CDCommandController;
import ch.cyberduck.ui.cocoa.CDConnectionController;
import ch.cyberduck.ui.cocoa.CDController;
import ch.cyberduck.ui.cocoa.CDCreateFileController;
import ch.cyberduck.ui.cocoa.CDDuplicateFileController;
import ch.cyberduck.ui.cocoa.CDFolderController;
import ch.cyberduck.ui.cocoa.CDGotoController;
import ch.cyberduck.ui.cocoa.CDHostKeyController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDInfoController;
import ch.cyberduck.ui.cocoa.CDLoginController;
import ch.cyberduck.ui.cocoa.CDMainController;
import ch.cyberduck.ui.cocoa.CDOutlineCell;
import ch.cyberduck.ui.cocoa.CDSheetCallback;
import ch.cyberduck.ui.cocoa.CDTranscriptController;
import ch.cyberduck.ui.cocoa.CDTransferController;
import ch.cyberduck.ui.cocoa.CDTransferPrompt;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.CDWindowListener;
import ch.cyberduck.ui.cocoa.PathPasteboard;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSComboBox;
import ch.cyberduck.ui.cocoa.application.NSControl;
import ch.cyberduck.ui.cocoa.application.NSDrawer;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSImageCell;
import ch.cyberduck.ui.cocoa.application.NSLayoutManager;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSPrintInfo;
import ch.cyberduck.ui.cocoa.application.NSPrintOperation;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSSavePanel;
import ch.cyberduck.ui.cocoa.application.NSSegmentedCell;
import ch.cyberduck.ui.cocoa.application.NSSegmentedControl;
import ch.cyberduck.ui.cocoa.application.NSTabView;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextFieldCell;
import ch.cyberduck.ui.cocoa.application.NSToolbar;
import ch.cyberduck.ui.cocoa.application.NSToolbarItem;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.delegate.ArchiveMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.BackPathHistoryMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.EditMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.ForwardPathHistoryMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSAppleScript;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSFileManager;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.model.CDPathReference;
import ch.cyberduck.ui.cocoa.odb.Editor;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanel;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanelController;
import ch.cyberduck.ui.cocoa.quicklook.QuickLookFactory;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import ch.cyberduck.ui.growl.Growl;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDBrowserController
extends CDWindowController
implements NSToolbar.Delegate,
QLPreviewPanelController {
    private static Logger log = Logger.getLogger(CDBrowserController.class);
    private NSToolbar toolbar;
    private boolean showHiddenFiles;
    private PathFilter<Path> filenameFilter;
    private CDTranscriptController transcript;
    private NSDrawer logDrawer;
    private static final int TAB_BOOKMARKS = 0;
    private static final int TAB_LIST_VIEW = 1;
    private static final int TAB_OUTLINE_VIEW = 2;
    private NSTabView browserTabView;
    private NSMenu editMenu;
    private EditMenuDelegate editMenuDelegate;
    private NSMenu archiveMenu;
    private ArchiveMenuDelegate archiveMenuDelegate;
    private NSButton bonjourButton;
    private NSButton historyButton;
    private NSButton bookmarkButton;
    private NSSegmentedControl bookmarkSwitchView;
    private static final int SWITCH_BOOKMARK_VIEW = 0;
    private NSSegmentedControl browserSwitchView;
    private static final int SWITCH_LIST_VIEW = 0;
    private static final int SWITCH_OUTLINE_VIEW = 1;
    private CDBrowserOutlineViewModel browserOutlineModel;
    private NSOutlineView browserOutlineView;
    private AbstractBrowserTableDelegate<Path> browserOutlineViewDelegate;
    private CDBrowserListViewModel browserListModel;
    private NSTableView browserListView;
    private AbstractBrowserTableDelegate<Path> browserListViewDelegate;
    private final NSTextFieldCell outlineCellPrototype;
    private final NSImageCell imageCellPrototype;
    private final NSTextFieldCell textCellPrototype;
    private final NSTextFieldCell filenameCellPrototype;
    private final TableColumnFactory browserListColumnsFactory;
    private final TableColumnFactory browserOutlineColumnsFactory;
    private final TableColumnFactory bookmarkTableColumnFactory;
    private CDBookmarkTableDataSource bookmarkModel;
    private NSTableView bookmarkTable;
    private CDAbstractTableDelegate<Host> bookmarkTableDelegate;
    private NSPopUpButton actionPopupButton;
    private NSComboBox quickConnectPopup;
    private CDController quickConnectPopupModel;
    private NSTextField searchField;
    private NSButton editBookmarkButton;
    private NSButton addBookmarkButton;
    private NSButton deleteBookmarkButton;
    private static final int NAVIGATION_LEFT_SEGMENT_BUTTON = 0;
    private static final int NAVIGATION_RIGHT_SEGMENT_BUTTON = 1;
    private static final int NAVIGATION_UP_SEGMENT_BUTTON = 0;
    private NSSegmentedControl navigationButton;
    private NSMenu backMenu;
    private MenuDelegate backMenuDelegate;
    private NSMenu forwardMenu;
    private MenuDelegate forwardMenuDelegate;
    private NSSegmentedControl upButton;
    private Path workdir;
    private NSPopUpButton pathPopupButton;
    private NSPopUpButton encodingPopup;
    protected NSProgressIndicator spinner;
    private NSTextField statusLabel;
    private NSButton securityLabel;
    private CDInfoController inspector;
    private static String lastSelectedDownloadDirectory = null;
    private NSOpenPanel downloadToPanel;
    private NSSavePanel downloadAsPanel;
    private NSOpenPanel syncPanel;
    private static String lastSelectedUploadDirectory = null;
    private NSOpenPanel uploadPanel;
    private List<Path> backHistory;
    private List<Path> forwardHistory;
    private ConnectionListener listener;
    private Session session;
    private static final String TOOLBAR_NEW_CONNECTION = "New Connection";
    private static final String TOOLBAR_BROWSER_VIEW = "Browser View";
    private static final String TOOLBAR_TRANSFERS = "Transfers";
    private static final String TOOLBAR_QUICK_CONNECT = "Quick Connect";
    private static final String TOOLBAR_TOOLS = "Tools";
    private static final String TOOLBAR_REFRESH = "Refresh";
    private static final String TOOLBAR_ENCODING = "Encoding";
    private static final String TOOLBAR_SYNCHRONIZE = "Synchronize";
    private static final String TOOLBAR_DOWNLOAD = "Download";
    private static final String TOOLBAR_UPLOAD = "Upload";
    private static final String TOOLBAR_EDIT = "Edit";
    private static final String TOOLBAR_DELETE = "Delete";
    private static final String TOOLBAR_NEW_FOLDER = "New Folder";
    private static final String TOOLBAR_NEW_BOOKMARK = "New Bookmark";
    private static final String TOOLBAR_GET_INFO = "Get Info";
    private static final String TOOLBAR_WEBVIEW = "Open";
    private static final String TOOLBAR_DISCONNECT = "Disconnect";
    private static final String TOOLBAR_GO_TO_FOLDER = "Go to Folder";
    private static final String TOOLBAR_TERMINAL = "Terminal";
    private static final String TOOLBAR_ARCHIVE = "Archive";
    private static final String TOOLBAR_QUICKLOOK = "Quick Look";
    private Map<String, NSToolbarItem> toolbarItems;
    private NSButton quicklookButton;

    public CDBrowserController() {
        if (Preferences.instance().getBoolean("browser.showHidden")) {
            this.filenameFilter = new NullPathFilter();
            this.showHiddenFiles = true;
        } else {
            this.filenameFilter = new HiddenFilesPathFilter();
            this.showHiddenFiles = false;
        }
        this.outlineCellPrototype = CDOutlineCell.outlineCell();
        this.imageCellPrototype = NSImageCell.imageCell();
        this.textCellPrototype = NSTextFieldCell.textFieldCell();
        this.filenameCellPrototype = NSTextFieldCell.textFieldCell();
        this.browserListColumnsFactory = new TableColumnFactory();
        this.browserOutlineColumnsFactory = new TableColumnFactory();
        this.bookmarkTableColumnFactory = new TableColumnFactory();
        this.quickConnectPopupModel = new QuickConnectModel();
        this.backHistory = new ch.cyberduck.core.Collection();
        this.forwardHistory = new ch.cyberduck.core.Collection();
        this.listener = null;
        this.toolbarItems = new HashMap<String, NSToolbarItem>();
        this.loadBundle();
    }

    @Override
    protected String getBundleName() {
        return "Browser";
    }

    public static void validateToolbarItems() {
        for (CDBrowserController controller : CDMainController.getBrowsers()) {
            controller.window().toolbar().validateVisibleItems();
        }
    }

    public static void updateBookmarkTableRowHeight() {
        for (CDBrowserController controller : CDMainController.getBrowsers()) {
            controller._updateBookmarkCell();
        }
    }

    public static void updateBrowserTableAttributes() {
        for (CDBrowserController controller : CDMainController.getBrowsers()) {
            controller._updateBrowserAttributes(controller.browserListView);
            controller._updateBrowserAttributes(controller.browserOutlineView);
        }
    }

    public static void updateBrowserTableColumns() {
        for (CDBrowserController controller : CDMainController.getBrowsers()) {
            controller._updateBrowserColumns(controller.browserListView);
            controller._updateBrowserColumns(controller.browserOutlineView);
        }
    }

    @Override
    public void awakeFromNib() {
        this._updateBrowserColumns(this.browserListView);
        this._updateBrowserColumns(this.browserOutlineView);
        if (Preferences.instance().getBoolean("browser.logDrawer.isOpen")) {
            this.logDrawer.open();
        }
        this.toolbar = NSToolbar.toolbarWithIdentifier("Cyberduck Toolbar");
        this.toolbar.setDelegate(this.id());
        this.toolbar.setAllowsUserCustomization(true);
        this.toolbar.setAutosavesConfiguration(true);
        this.window().setToolbar(this.toolbar);
        this.window().makeFirstResponder(this.quickConnectPopup);
        this.toggleBookmarks(true);
        if (this.getSelectedTabView() != 0) {
            this.browserSwitchClicked(Preferences.instance().getInteger("browser.view"));
        }
        this.validateNavigationButtons();
        super.awakeFromNib();
    }

    protected Comparator<Path> getComparator() {
        return this.getSelectedBrowserDelegate().getSortingComparator();
    }

    protected PathFilter<Path> getFileFilter() {
        return this.filenameFilter;
    }

    protected void setPathFilter(final String searchString) {
        log.debug((Object)("setPathFilter:" + searchString));
        if (StringUtils.isBlank((String)searchString)) {
            this.searchField.setStringValue("");
            this.filenameFilter = this.getShowHiddenFiles() ? new NullPathFilter() : new HiddenFilesPathFilter();
        } else {
            this.filenameFilter = new PathFilter<Path>(){

                public boolean accept(Path file) {
                    if (file.getName().toLowerCase().indexOf(searchString.toLowerCase()) != -1) {
                        return true;
                    }
                    if (file.attributes.isDirectory() && CDBrowserController.this.getSelectedBrowserView() == CDBrowserController.this.browserOutlineView) {
                        return file.isCached();
                    }
                    return false;
                }
            };
        }
        this.reloadData(true);
    }

    public void setShowHiddenFiles(boolean showHidden) {
        if (showHidden) {
            this.filenameFilter = new NullPathFilter();
            this.showHiddenFiles = true;
        } else {
            this.filenameFilter = new HiddenFilesPathFilter();
            this.showHiddenFiles = false;
        }
    }

    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    private void getFocus() {
        if (this.getSelectedTabView() == 0) {
            int row;
            if (this.isMounted() && (row = this.bookmarkModel.getSource().indexOf((Object)this.getSession().getHost())) != -1) {
                this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(new NSInteger(row)), false);
                this.bookmarkTable.scrollRowToVisible(new NSInteger(row));
            }
            this.updateStatusLabel((Object)((Object)this.bookmarkTable.numberOfRows()) + " " + Locale.localizedString((String)"Bookmarks"));
            this.window().makeFirstResponder(this.bookmarkTable);
        } else {
            if (this.isMounted()) {
                this.window().makeFirstResponder(this.getSelectedBrowserView());
            } else {
                this.window().makeFirstResponder(this.quickConnectPopup);
            }
            this.updateStatusLabel();
        }
    }

    public void reloadData(boolean preserveSelection) {
        if (preserveSelection) {
            this.reloadData((List<Path>)this.getSelectedPaths());
        } else {
            this.reloadData(Collections.<Path>emptyList());
        }
    }

    protected void reloadData(List<Path> selected) {
        log.debug((Object)"reloadData");
        NSTableView browser = this.getSelectedBrowserView();
        browser.reloadData();
        this.setSelectedPaths(selected);
    }

    private void selectRow(Path path, boolean expand) {
        log.debug((Object)("selectRow:" + path));
        NSTableView browser = this.getSelectedBrowserView();
        if (this.getSelectedBrowserModel().contains(browser, path)) {
            this.selectRow(this.getSelectedBrowserModel().indexOf(browser, path), expand);
        }
    }

    private void selectRow(int row, boolean expand) {
        log.debug((Object)("selectRow:" + row));
        if (-1 == row) {
            return;
        }
        NSTableView browser = this.getSelectedBrowserView();
        NSInteger index = new NSInteger(row);
        browser.selectRowIndexes(NSIndexSet.indexSetWithIndex(index), expand);
        browser.scrollRowToVisible(index);
    }

    protected void setSelectedPath(Path selected) {
        ch.cyberduck.core.Collection list = new ch.cyberduck.core.Collection();
        list.add(selected);
        this.setSelectedPaths((List<Path>)list);
    }

    protected void setSelectedPaths(List<Path> selected) {
        log.debug((Object)"setSelectedPaths");
        this.deselectAll();
        if (!selected.isEmpty()) {
            switch (this.browserSwitchView.selectedSegment()) {
                case 0: {
                    for (Path path : selected) {
                        this.selectRow(path, true);
                    }
                    break;
                }
                case 1: {
                    for (Path path : selected) {
                        int row = this.browserOutlineView.rowForItem((NSObject)path.getReference().unique()).intValue();
                        this.selectRow(row, true);
                    }
                    break;
                }
            }
        }
    }

    protected Path getSelectedPath() {
        ch.cyberduck.core.Collection<Path> selected = this.getSelectedPaths();
        if (selected.size() > 0) {
            return (Path)selected.get(0);
        }
        return null;
    }

    protected ch.cyberduck.core.Collection<Path> getSelectedPaths() {
        ch.cyberduck.core.Collection selectedFiles = new ch.cyberduck.core.Collection();
        if (this.isMounted()) {
            Path selected;
            NSIndexSet iterator = this.getSelectedBrowserView().selectedRowIndexes();
            NSUInteger index = iterator.firstIndex();
            while (!index.equals((Object)NSIndexSet.NSNotFound) && null != (selected = this.pathAtRow(index.intValue()))) {
                selectedFiles.add((Object)selected);
                index = iterator.indexGreaterThanIndex(index);
            }
        }
        return selectedFiles;
    }

    protected int getSelectionCount() {
        return this.getSelectedBrowserView().numberOfSelectedRows().intValue();
    }

    private void deselectAll() {
        log.debug((Object)"deselectAll");
        NSTableView browser = this.getSelectedBrowserView();
        if (null == browser) {
            return;
        }
        browser.deselectAll(null);
    }

    private Path pathAtRow(int row) {
        switch (this.browserSwitchView.selectedSegment()) {
            case 0: {
                AttributedList<Path> childs = this.browserListModel.childs(this.workdir());
                if (row >= childs.size()) break;
                return (Path)childs.get(row);
            }
            case 1: {
                if (row >= this.browserOutlineView.numberOfRows().intValue()) break;
                return this.lookup(new CDPathReference(this.browserOutlineView.itemAtRow(new NSInteger(row))));
            }
        }
        log.warn((Object)("No item at row:" + row));
        return null;
    }

    @Override
    public void setWindow(NSWindow window) {
        window.setTitle(NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleName").toString());
        window.setMiniwindowImage(CDIconCache.iconNamed("cyberduck-document.icns"));
        window.setMovableByWindowBackground(true);
        window.setDelegate(this.id());
        super.setWindow(window);
    }

    public void drawerWillOpen(NSNotification notification) {
        this.logDrawer.setContentSize(new NSSize(this.logDrawer.contentSize().width.doubleValue(), Preferences.instance().getDouble("browser.logDrawer.size.height")));
    }

    public void drawerDidOpen(NSNotification notification) {
        Preferences.instance().setProperty("browser.logDrawer.isOpen", true);
    }

    public void drawerWillClose(NSNotification notification) {
        Preferences.instance().setProperty("browser.logDrawer.size.height", this.logDrawer.contentSize().height.intValue());
    }

    public void drawerDidClose(NSNotification notification) {
        Preferences.instance().setProperty("browser.logDrawer.isOpen", false);
    }

    public void setLogDrawer(NSDrawer logDrawer) {
        this.logDrawer = logDrawer;
        this.transcript = new CDTranscriptController();
        this.logDrawer.setContentView(this.transcript.getLogView());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerWillOpen:"), "NSDrawerWillOpenNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerDidOpen:"), "NSDrawerDidOpenNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerWillClose:"), "NSDrawerWillCloseNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerDidClose:"), "NSDrawerDidCloseNotification", this.logDrawer);
    }

    private int getSelectedTabView() {
        return this.browserTabView.indexOfTabViewItem(this.browserTabView.selectedTabViewItem());
    }

    public void setBrowserTabView(NSTabView browserTabView) {
        this.browserTabView = browserTabView;
    }

    public NSTableView getSelectedBrowserView() {
        switch (this.browserSwitchView.selectedSegment()) {
            case 0: {
                return this.browserListView;
            }
            case 1: {
                return this.browserOutlineView;
            }
        }
        log.fatal((Object)"No selected brower view");
        return null;
    }

    public CDBrowserTableDataSource getSelectedBrowserModel() {
        switch (this.browserSwitchView.selectedSegment()) {
            case 0: {
                return this.browserListModel;
            }
            case 1: {
                return this.browserOutlineModel;
            }
        }
        log.fatal((Object)"No selected brower view");
        return null;
    }

    public AbstractBrowserTableDelegate<Path> getSelectedBrowserDelegate() {
        switch (this.browserSwitchView.selectedSegment()) {
            case 0: {
                return this.browserListViewDelegate;
            }
            case 1: {
                return this.browserOutlineViewDelegate;
            }
        }
        log.fatal((Object)"No selected brower view");
        return null;
    }

    public void setEditMenu(NSMenu editMenu) {
        this.editMenu = editMenu;
        this.editMenuDelegate = new EditMenuDelegate();
        this.editMenu.setDelegate(this.editMenuDelegate.id());
    }

    public void setArchiveMenu(NSMenu archiveMenu) {
        this.archiveMenu = archiveMenu;
        this.archiveMenuDelegate = new ArchiveMenuDelegate();
        this.archiveMenu.setDelegate(this.archiveMenuDelegate.id());
    }

    public void setBonjourButton(NSButton bonjourButton) {
        this.bonjourButton = bonjourButton;
        this.bonjourButton.setImage(CDIconCache.iconNamed("rendezvous", 16));
        this.setRecessedBezelStyle(this.bonjourButton);
        this.bonjourButton.setTarget(this.id());
        this.bonjourButton.setAction(Foundation.selector("bookmarkButtonClicked:"));
    }

    public void setHistoryButton(NSButton historyButton) {
        this.historyButton = historyButton;
        this.historyButton.setImage(CDIconCache.iconNamed("history", 16));
        this.setRecessedBezelStyle(this.historyButton);
        this.historyButton.setTarget(this.id());
        this.historyButton.setAction(Foundation.selector("bookmarkButtonClicked:"));
    }

    public void setBookmarkButton(NSButton bookmarkButton) {
        this.bookmarkButton = bookmarkButton;
        this.bookmarkButton.setImage(CDIconCache.iconNamed("bookmarks", 20, 16));
        this.setRecessedBezelStyle(this.bookmarkButton);
        this.bookmarkButton.setTarget(this.id());
        this.bookmarkButton.setAction(Foundation.selector("bookmarkButtonClicked:"));
        this.bookmarkButton.setState(1);
    }

    public void bookmarkButtonClicked(NSButton sender) {
        if (sender != this.bonjourButton) {
            this.bonjourButton.setState(0);
        }
        if (sender != this.historyButton) {
            this.historyButton.setState(0);
        }
        if (sender != this.bookmarkButton) {
            this.bookmarkButton.setState(0);
        }
        sender.setState(1);
        this.updateBookmarkSource();
    }

    private void setRecessedBezelStyle(NSButton b) {
        b.setBezelStyle(13);
        b.setButtonType(1);
        b.setImagePosition(2);
        b.setFont(NSFont.boldSystemFontOfSize(11.0));
        b.setShowsBorderOnlyWhileMouseInside(true);
        b.sizeToFit();
    }

    private void updateBookmarkSource() {
        if (this.bonjourButton.state() == 1) {
            this.bookmarkModel.setSource((BookmarkCollection)RendezvousCollection.defaultCollection());
        } else if (this.historyButton.state() == 1) {
            this.bookmarkModel.setSource((BookmarkCollection)HistoryCollection.defaultCollection());
        } else if (this.bookmarkButton.state() == 1) {
            this.bookmarkModel.setSource((BookmarkCollection)HostCollection.defaultCollection());
        }
        this.bookmarkTableDelegate.selectionDidChange(null);
        this.setBookmarkFilter(null);
        this.reloadBookmarks();
        this.getFocus();
    }

    public void reloadBookmarks() {
        this.bookmarkTable.reloadData();
        this.updateStatusLabel();
    }

    public void setBookmarkSwitchView(NSSegmentedControl bookmarkSwitchView) {
        this.bookmarkSwitchView = bookmarkSwitchView;
        this.bookmarkSwitchView.setSegmentCount(1);
        NSImage image = CDIconCache.iconNamed("bookmarks.tiff");
        this.bookmarkSwitchView.setImage_forSegment(image, 0);
        NSSegmentedCell cell = Rococoa.cast(this.bookmarkSwitchView.cell(), NSSegmentedCell.class);
        cell.setTrackingMode(1);
        cell.setControlSize(0);
        this.bookmarkSwitchView.setTarget(this.id());
        this.bookmarkSwitchView.setAction(Foundation.selector("bookmarkSwitchClicked:"));
        this.bookmarkSwitchView.setSelectedSegment(0);
    }

    public void bookmarkSwitchClicked(ID sender) {
        this.toggleBookmarks(this.getSelectedTabView() != 0);
    }

    public void toggleBookmarks(boolean open) {
        log.debug((Object)("bookmarkSwitchClicked:" + open));
        this.bookmarkSwitchView.setSelected_forSegment(open, 0);
        if (open) {
            this.browserTabView.selectTabViewItemAtIndex(0);
            this.updateBookmarkSource();
        } else {
            this.setBookmarkFilter(null);
            this.selectBrowser(Preferences.instance().getInteger("browser.view"));
        }
        this.getFocus();
        this.validateNavigationButtons();
    }

    public void setBrowserSwitchView(NSSegmentedControl browserSwitchView) {
        this.browserSwitchView = browserSwitchView;
        this.browserSwitchView.setSegmentCount(2);
        NSImage list = CDIconCache.iconNamed("list.tiff");
        list.setTemplate(true);
        this.browserSwitchView.setImage_forSegment(list, 0);
        NSImage outline = CDIconCache.iconNamed("outline.tiff");
        outline.setTemplate(true);
        this.browserSwitchView.setImage_forSegment(outline, 1);
        this.browserSwitchView.setTarget(this.id());
        this.browserSwitchView.setAction(Foundation.selector("browserSwitchButtonClicked:"));
        NSSegmentedCell cell = Rococoa.cast(this.browserSwitchView.cell(), NSSegmentedCell.class);
        cell.setTrackingMode(0);
        cell.setControlSize(0);
        this.browserSwitchView.setSelectedSegment(Preferences.instance().getInteger("browser.view"));
    }

    public void browserSwitchButtonClicked(NSSegmentedControl sender) {
        this.browserSwitchClicked(sender.selectedSegment());
    }

    public void browserSwitchMenuClicked(NSMenuItem sender) {
        this.browserSwitchView.setSelectedSegment(sender.tag());
        this.browserSwitchClicked(sender.tag());
    }

    private void browserSwitchClicked(int selected) {
        this.toggleBookmarks(false);
        this.selectBrowser(selected);
        this.reloadData(false);
        this.getFocus();
        Preferences.instance().setProperty("browser.view", selected);
    }

    private void selectBrowser(int selected) {
        this.browserSwitchView.setSelectedSegment(selected);
        switch (selected) {
            case 0: {
                this.browserTabView.selectTabViewItemAtIndex(1);
                break;
            }
            case 1: {
                this.browserTabView.selectTabViewItemAtIndex(2);
            }
        }
    }

    @Override
    public boolean acceptsPreviewPanelControl(QLPreviewPanel panel) {
        log.debug((Object)"acceptsPreviewPanelControl");
        return true;
    }

    @Override
    public void beginPreviewPanelControl(QLPreviewPanel panel) {
        log.debug((Object)"beginPreviewPanelControl");
        QuickLookFactory.instance().willBeginQuickLook();
    }

    @Override
    public void endPreviewPanelControl(QLPreviewPanel panel) {
        log.debug((Object)"endPreviewPanelControl");
        QuickLookFactory.instance().didEndQuickLook();
    }

    public void setBrowserOutlineView(NSOutlineView view) {
        this.browserOutlineView = view;
        this.browserOutlineView.registerForDraggedTypes(NSArray.arrayWithObjects("Apple URL pasteboard type", "NSFilenamesPboardType", "Apple files promise pasteboard type"));
        NSLayoutManager l = NSLayoutManager.layoutManager();
        this.browserOutlineView.setRowHeight(new CGFloat(l.defaultLineHeightForFont(NSFont.systemFontOfSize(Preferences.instance().getFloat("browser.font.size"))).intValue() + 2));
        this._updateBrowserAttributes(this.browserOutlineView);
        this.browserOutlineView.setAllowsMultipleSelection(true);
        this.browserOutlineView.setAllowsEmptySelection(true);
        this.browserOutlineView.setAllowsColumnResizing(true);
        this.browserOutlineView.setAllowsColumnSelection(false);
        this.browserOutlineView.setAllowsColumnReordering(true);
        this.browserOutlineModel = new CDBrowserOutlineViewModel(this);
        this.browserOutlineView.setDataSource(this.browserOutlineModel.id());
        this.browserOutlineViewDelegate = new AbstractBrowserOutlineViewDelegate<Path>(){

            @Override
            public void enterKeyPressed(ID sender) {
                if (Preferences.instance().getBoolean("browser.enterkey.rename")) {
                    if (CDBrowserController.this.browserOutlineView.numberOfSelectedRows().intValue() == 1) {
                        CDBrowserController.this.browserOutlineView.editRow(CDBrowserController.this.browserOutlineView.columnWithIdentifier("FILENAME"), CDBrowserController.this.browserOutlineView.selectedRow(), true);
                    }
                } else {
                    this.tableRowDoubleClicked(sender);
                }
            }

            @Override
            public void outlineView_willDisplayCell_forTableColumn_item(NSOutlineView view, NSTextFieldCell cell, NSTableColumn tableColumn, NSObject item) {
                if (tableColumn.identifier().equals("FILENAME")) {
                    Path path = CDBrowserController.this.lookup(new CDPathReference(item));
                    if (null == path) {
                        return;
                    }
                    cell.setEditable(path.isRenameSupported());
                    Rococoa.cast(cell, CDOutlineCell.class).setIcon(CDBrowserController.this.browserOutlineModel.iconForPath(path));
                }
                if (!CDBrowserController.this.isConnected()) {
                    cell.setTextColor(NSColor.disabledControlTextColor());
                } else {
                    cell.setTextColor(NSColor.controlTextColor());
                }
            }

            @Override
            public boolean outlineView_shouldExpandItem(NSOutlineView view, NSObject item) {
                NSEvent event = NSApplication.sharedApplication().currentEvent();
                if (event != null && 6 == event.type()) {
                    if (!Preferences.instance().getBoolean("browser.view.autoexpand")) {
                        log.debug((Object)"Returning false to #outlineViewShouldExpandItem while dragging because browser.view.autoexpand == false");
                        return false;
                    }
                    NSInteger draggingColumn = view.columnAtPoint(view.convertPoint_fromView(event.locationInWindow(), null));
                    if (draggingColumn.intValue() != 0) {
                        log.debug((Object)("Returning false to #outlineViewShouldExpandItem for column:" + (Object)((Object)draggingColumn)));
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void outlineViewItemDidExpand(NSNotification notification) {
                CDBrowserController.this.updateStatusLabel();
            }

            @Override
            public void outlineViewItemDidCollapse(NSNotification notification) {
                CDBrowserController.this.updateStatusLabel();
            }
        };
        this.browserOutlineView.setDelegate(this.browserOutlineViewDelegate.id());
        NSTableColumn c = this.browserOutlineColumnsFactory.create("FILENAME");
        c.headerCell().setStringValue(Locale.localizedString((String)"Filename"));
        c.setMinWidth(new CGFloat(100.0));
        c.setWidth(new CGFloat(250.0));
        c.setMaxWidth(new CGFloat(1000.0));
        c.setResizingMask(3);
        NSTextFieldCell cell = this.outlineCellPrototype;
        cell.setTarget(this.browserOutlineView.target());
        cell.setAction(this.browserOutlineView.action());
        c.setDataCell(cell);
        this.browserOutlineView.addTableColumn(c);
        this.browserOutlineView.setOutlineTableColumn(c);
    }

    public void setBrowserListView(NSTableView view) {
        this.browserListView = view;
        this.browserListView.registerForDraggedTypes(NSArray.arrayWithObjects("Apple URL pasteboard type", "NSFilenamesPboardType", "Apple files promise pasteboard type"));
        NSLayoutManager l = NSLayoutManager.layoutManager();
        this.browserListView.setRowHeight(new CGFloat(l.defaultLineHeightForFont(NSFont.systemFontOfSize(Preferences.instance().getFloat("browser.font.size"))).intValue() + 2));
        this._updateBrowserAttributes(this.browserListView);
        this.browserListView.setAllowsMultipleSelection(true);
        this.browserListView.setAllowsEmptySelection(true);
        this.browserListView.setAllowsColumnResizing(true);
        this.browserListView.setAllowsColumnSelection(false);
        this.browserListView.setAllowsColumnReordering(true);
        this.browserListModel = new CDBrowserListViewModel(this);
        this.browserListView.setDataSource(this.browserListModel.id());
        this.browserListViewDelegate = new AbstractBrowserListViewDelegate<Path>(){

            @Override
            public void enterKeyPressed(ID sender) {
                if (Preferences.instance().getBoolean("browser.enterkey.rename")) {
                    if (CDBrowserController.this.browserListView.numberOfSelectedRows().intValue() == 1) {
                        CDBrowserController.this.browserListView.editRow(CDBrowserController.this.browserListView.columnWithIdentifier("FILENAME"), CDBrowserController.this.browserListView.selectedRow(), true);
                    }
                } else {
                    this.tableRowDoubleClicked(sender);
                }
            }

            @Override
            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSTextFieldCell cell, NSTableColumn tableColumn, NSInteger row) {
                String identifier = tableColumn.identifier();
                if (identifier.equals("FILENAME")) {
                    Path item = (Path)CDBrowserController.this.browserListModel.childs(CDBrowserController.this.workdir()).get(row.intValue());
                    cell.setEditable(item.isRenameSupported());
                }
                if (cell.isKindOfClass(Foundation.getClass(NSTextFieldCell.class.getSimpleName()))) {
                    if (!CDBrowserController.this.isConnected()) {
                        cell.setTextColor(NSColor.disabledControlTextColor());
                    } else {
                        cell.setTextColor(NSColor.controlTextColor());
                    }
                }
            }
        };
        this.browserListView.setDelegate(this.browserListViewDelegate.id());
        NSTableColumn c = this.browserListColumnsFactory.create("ICON");
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setDataCell(this.imageCellPrototype);
        c.dataCell().setAlignment(2);
        this.browserListView.addTableColumn(c);
        c = this.browserListColumnsFactory.create("FILENAME");
        c.headerCell().setStringValue(Locale.localizedString((String)"Filename"));
        c.setMinWidth(100.0);
        c.setWidth(250.0);
        c.setMaxWidth(1000.0);
        c.setResizingMask(3);
        NSTextFieldCell cell = this.filenameCellPrototype;
        cell.setEditable(true);
        cell.setTarget(view.target());
        cell.setAction(view.action());
        c.setDataCell(cell);
        this.browserListView.addTableColumn(c);
    }

    protected void _updateBrowserAttributes(NSTableView tableView) {
        tableView.setUsesAlternatingRowBackgroundColors(Preferences.instance().getBoolean("browser.alternatingRows"));
        if (Preferences.instance().getBoolean("browser.horizontalLines") && Preferences.instance().getBoolean("browser.verticalLines")) {
            tableView.setGridStyleMask(new NSUInteger(NSTableView.NSTableViewSolidHorizontalGridLineMask.intValue() | NSTableView.NSTableViewSolidVerticalGridLineMask.intValue()));
        } else if (Preferences.instance().getBoolean("browser.verticalLines")) {
            tableView.setGridStyleMask(NSTableView.NSTableViewSolidVerticalGridLineMask);
        } else if (Preferences.instance().getBoolean("browser.horizontalLines")) {
            tableView.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        } else {
            tableView.setGridStyleMask(NSTableView.NSTableViewGridNone);
        }
    }

    protected void _updateBookmarkCell() {
        int size = Preferences.instance().getInteger("bookmark.icon.size");
        if (16 == size) {
            this.bookmarkTable.setRowHeight(new CGFloat(18.0));
        }
        if (32 == size) {
            this.bookmarkTable.setRowHeight(new CGFloat(45.0));
        }
        if (64 == size) {
            this.bookmarkTable.setRowHeight(new CGFloat(70.0));
        }
        double width = (double)size * 1.5;
        NSTableColumn c = this.bookmarkTable.tableColumnWithIdentifier("ICON");
        c.setMinWidth(width);
        c.setMaxWidth(width);
        c.setWidth(width);
    }

    protected void _updateBrowserColumns(NSTableView table) {
        NSTableColumn c;
        table.removeTableColumn(table.tableColumnWithIdentifier("SIZE"));
        if (Preferences.instance().getBoolean("browser.columnSize")) {
            c = this.browserListColumnsFactory.create("SIZE");
            c.headerCell().setStringValue(Locale.localizedString((String)"Size"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(150.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("MODIFIED"));
        if (Preferences.instance().getBoolean("browser.columnModification")) {
            c = this.browserListColumnsFactory.create("MODIFIED");
            c.headerCell().setStringValue(Locale.localizedString((String)"Modified"));
            c.setMinWidth(100.0);
            c.setWidth(150.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("OWNER"));
        if (Preferences.instance().getBoolean("browser.columnOwner")) {
            c = this.browserListColumnsFactory.create("OWNER");
            c.headerCell().setStringValue(Locale.localizedString((String)"Owner"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("GROUP"));
        if (Preferences.instance().getBoolean("browser.columnGroup")) {
            c = this.browserListColumnsFactory.create("GROUP");
            c.headerCell().setStringValue(Locale.localizedString((String)"Group"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("PERMISSIONS"));
        if (Preferences.instance().getBoolean("browser.columnPermissions")) {
            c = this.browserListColumnsFactory.create("PERMISSIONS");
            c.headerCell().setStringValue(Locale.localizedString((String)"Permissions"));
            c.setMinWidth(100.0);
            c.setWidth(100.0);
            c.setMaxWidth(800.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("KIND"));
        if (Preferences.instance().getBoolean("browser.columnKind")) {
            c = this.browserListColumnsFactory.create("KIND");
            c.headerCell().setStringValue(Locale.localizedString((String)"Kind"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.setIndicatorImage_inTableColumn(this.browserListViewDelegate.isSortedAscending() ? CDIconCache.iconNamed("NSAscendingSortIndicator") : CDIconCache.iconNamed("NSDescendingSortIndicator"), table.tableColumnWithIdentifier(Preferences.instance().getProperty("browser.sort.column")));
        table.setAutosaveTableColumns(true);
        table.sizeToFit();
        this.reloadData(false);
    }

    public void setBookmarkTable(NSTableView view) {
        this.bookmarkTable = view;
        this.bookmarkModel = new CDBookmarkTableDataSource(this, (BookmarkCollection)HostCollection.defaultCollection());
        this.bookmarkTable.setDataSource(this.bookmarkModel.id());
        this.bookmarkTableDelegate = new CDAbstractTableDelegate<Host>(){

            @Override
            public String tooltip(Host bookmark) {
                return bookmark.toURL();
            }

            @Override
            public void tableRowDoubleClicked(ID sender) {
                CDBrowserController.this.connectBookmarkButtonClicked(sender);
            }

            @Override
            public void enterKeyPressed(ID sender) {
                this.tableRowDoubleClicked(sender);
            }

            @Override
            public void deleteKeyPressed(ID sender) {
                if (CDBrowserController.this.bookmarkModel.getSource().allowsDelete()) {
                    CDBrowserController.this.deleteBookmarkButtonClicked(sender);
                }
            }

            @Override
            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            @Override
            public void selectionDidChange(NSNotification notification) {
                CDBrowserController.this.addBookmarkButton.setEnabled(CDBrowserController.this.bookmarkModel.getSource().allowsAdd());
                int selected = CDBrowserController.this.bookmarkTable.numberOfSelectedRows().intValue();
                CDBrowserController.this.editBookmarkButton.setEnabled(CDBrowserController.this.bookmarkModel.getSource().allowsEdit() && selected == 1);
                CDBrowserController.this.deleteBookmarkButton.setEnabled(CDBrowserController.this.bookmarkModel.getSource().allowsDelete() && selected > 0);
            }
        };
        this.bookmarkTable.setDelegate(this.bookmarkTableDelegate.id());
        this.bookmarkTable.registerForDraggedTypes(NSArray.arrayWithObjects("Apple URL pasteboard type", "NSStringPboardType", "NSFilenamesPboardType", "Apple files promise pasteboard type", "HostPBoardType"));
        NSTableColumn c = this.bookmarkTableColumnFactory.create("ICON");
        c.headerCell().setStringValue("");
        c.setResizingMask(0);
        c.setDataCell(this.imageCellPrototype);
        this.bookmarkTable.addTableColumn(c);
        c = this.bookmarkTableColumnFactory.create("BOOKMARK");
        c.headerCell().setStringValue(Locale.localizedString((String)"Bookmarks"));
        c.setMinWidth(150.0);
        c.setResizingMask(1);
        c.setDataCell(CDBookmarkCell.bookmarkCell());
        this.bookmarkTable.addTableColumn(c);
        c = this.bookmarkTableColumnFactory.create("STATUS");
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setDataCell(this.imageCellPrototype);
        c.dataCell().setAlignment(2);
        this.bookmarkTable.addTableColumn(c);
        this._updateBookmarkCell();
        this.bookmarkTable.setUsesAlternatingRowBackgroundColors(Preferences.instance().getBoolean("browser.alternatingRows"));
        this.bookmarkTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        this.bookmarkTable.setAllowsMultipleSelection(true);
        this.bookmarkTable.setAllowsEmptySelection(true);
        this.bookmarkTable.setAllowsColumnResizing(false);
        this.bookmarkTable.setAllowsColumnSelection(false);
        this.bookmarkTable.setAllowsColumnReordering(false);
        this.bookmarkTable.sizeToFit();
    }

    public void setActionPopupButton(NSPopUpButton actionPopupButton) {
        this.actionPopupButton = actionPopupButton;
        this.actionPopupButton.setPullsDown(true);
        this.actionPopupButton.setAutoenablesItems(true);
        this.actionPopupButton.itemAtIndex(0).setImage(CDIconCache.iconNamed("gear.tiff"));
    }

    public void setQuickConnectPopup(NSComboBox quickConnectPopup) {
        this.quickConnectPopup = quickConnectPopup;
        this.quickConnectPopup.setTarget(this.id());
        this.quickConnectPopup.setCompletes(true);
        this.quickConnectPopup.setAction(Foundation.selector("quickConnectSelectionChanged:"));
        this.quickConnectPopup.setUsesDataSource(true);
        this.quickConnectPopup.setDataSource(this.quickConnectPopupModel.id());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("quickConnectWillPopUp:"), "NSComboBoxWillPopUpNotification", this.quickConnectPopup);
        this.quickConnectWillPopUp(null);
    }

    public void quickConnectWillPopUp(NSNotification notification) {
        int size = HostCollection.defaultCollection().size();
        this.quickConnectPopup.setNumberOfVisibleItems(size > 10 ? new NSInteger(10L) : new NSInteger(size));
    }

    public void quickConnectSelectionChanged(NSControl sender) {
        if (null == sender) {
            return;
        }
        String input = sender.stringValue();
        if (StringUtils.isBlank((String)input)) {
            return;
        }
        input = input.trim();
        for (Host h : HostCollection.defaultCollection()) {
            if (!h.getNickname().equals(input)) continue;
            this.mount(h);
            return;
        }
        this.mount(Host.parse((String)input));
    }

    public void setSearchField(NSTextField searchField) {
        this.searchField = searchField;
        this.searchField.setEnabled(false);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("searchFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.searchField);
    }

    public void searchButtonClicked(ID sender) {
        this.window().makeFirstResponder(this.searchField);
    }

    public void searchFieldTextDidChange(NSNotification notification) {
        if (this.getSelectedTabView() == 0) {
            this.setBookmarkFilter(this.searchField.stringValue());
        } else {
            this.setPathFilter(this.searchField.stringValue());
        }
    }

    private void setBookmarkFilter(final String searchString) {
        if (StringUtils.isBlank((String)searchString)) {
            this.searchField.setStringValue("");
            this.bookmarkModel.setFilter(null);
        } else {
            this.bookmarkModel.setFilter(new HostFilter(){

                public boolean accept(Host host) {
                    return host.getNickname().toLowerCase().contains(searchString.toLowerCase()) || host.getHostname().toLowerCase().contains(searchString.toLowerCase());
                }
            });
        }
        this.reloadBookmarks();
    }

    public void connectBookmarkButtonClicked(ID sender) {
        if (this.bookmarkTable.numberOfSelectedRows().intValue() == 1) {
            Host selected = (Host)this.bookmarkModel.getSource().get(this.bookmarkTable.selectedRow().intValue());
            this.mount(selected);
        }
    }

    public void setEditBookmarkButton(NSButton editBookmarkButton) {
        this.editBookmarkButton = editBookmarkButton;
        this.editBookmarkButton.setEnabled(false);
        this.editBookmarkButton.setTarget(this.id());
        this.editBookmarkButton.setAction(Foundation.selector("editBookmarkButtonClicked:"));
    }

    public void editBookmarkButtonClicked(ID sender) {
        CDBookmarkController c = CDBookmarkController.Factory.create((Host)this.bookmarkModel.getSource().get(this.bookmarkTable.selectedRow().intValue()));
        c.window().makeKeyAndOrderFront(null);
    }

    public void setAddBookmarkButton(NSButton addBookmarkButton) {
        this.addBookmarkButton = addBookmarkButton;
        this.addBookmarkButton.setTarget(this.id());
        this.addBookmarkButton.setAction(Foundation.selector("addBookmarkButtonClicked:"));
    }

    public void addBookmarkButtonClicked(ID sender) {
        Host item;
        if (this.isMounted()) {
            Path selected = this.getSelectedPath();
            if (null == selected || !selected.attributes.isDirectory()) {
                selected = this.workdir();
            }
            item = new Host(this.session.getHost().getAsDictionary());
            item.setDefaultPath(selected.getAbsolute());
        } else {
            item = new Host(Protocol.forName((String)Preferences.instance().getProperty("connection.protocol.default")), Preferences.instance().getProperty("connection.hostname.default"), Preferences.instance().getInteger("connection.port.default"));
        }
        this.toggleBookmarks(true);
        this.bookmarkModel.setFilter(null);
        this.bookmarkModel.getSource().add((Object)item);
        int row = this.bookmarkModel.getSource().lastIndexOf((Object)item);
        NSInteger index = new NSInteger(row);
        this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(index), false);
        this.bookmarkTable.scrollRowToVisible(index);
        CDBookmarkController c = CDBookmarkController.Factory.create(item);
        c.window().makeKeyAndOrderFront(null);
    }

    public void setDeleteBookmarkButton(NSButton deleteBookmarkButton) {
        this.deleteBookmarkButton = deleteBookmarkButton;
        this.deleteBookmarkButton.setEnabled(false);
        this.deleteBookmarkButton.setTarget(this.id());
        this.deleteBookmarkButton.setAction(Foundation.selector("deleteBookmarkButtonClicked:"));
    }

    public void deleteBookmarkButtonClicked(ID sender) {
        NSIndexSet iterator = this.bookmarkTable.selectedRowIndexes();
        NSUInteger[] indexes = new NSUInteger[iterator.count().intValue()];
        int i = 0;
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            indexes[i] = index;
            ++i;
            index = iterator.indexGreaterThanIndex(index);
        }
        this.bookmarkTable.deselectAll(null);
        int j = 0;
        for (i = 0; i < indexes.length; ++i) {
            int row = indexes[i].intValue() - j;
            NSInteger index2 = new NSInteger(row);
            this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(index2), false);
            this.bookmarkTable.scrollRowToVisible(index2);
            Host host = (Host)this.bookmarkModel.getSource().get(row);
            NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Delete Bookmark"), Locale.localizedString((String)"Do you want to delete the selected bookmark?") + " (" + host.getNickname() + ")", Locale.localizedString((String)TOOLBAR_DELETE), Locale.localizedString((String)"Cancel"), null);
            switch (alert.runModal()) {
                case 1: {
                    this.bookmarkModel.getSource().remove(row);
                    ++j;
                }
            }
        }
        this.bookmarkTable.deselectAll(null);
    }

    public void setNavigationButton(NSSegmentedControl navigationButton) {
        this.navigationButton = navigationButton;
        this.navigationButton.setTarget(this.id());
        this.navigationButton.setAction(Foundation.selector("navigationButtonClicked:"));
        this.backMenu = NSMenu.menu();
        this.backMenuDelegate = new BackPathHistoryMenuDelegate(this);
        this.backMenu.setDelegate(this.backMenuDelegate.id());
        this.navigationButton.setMenu_forSegment(this.backMenu, 0);
        this.forwardMenu = NSMenu.menu();
        this.forwardMenuDelegate = new ForwardPathHistoryMenuDelegate(this);
        this.forwardMenu.setDelegate(this.forwardMenuDelegate.id());
        this.navigationButton.setMenu_forSegment(this.forwardMenu, 1);
    }

    public void navigationButtonClicked(NSSegmentedControl sender) {
        switch (sender.selectedSegment()) {
            case 0: {
                this.backButtonClicked(sender);
                break;
            }
            case 1: {
                this.forwardButtonClicked(sender);
            }
        }
    }

    public void backButtonClicked(NSSegmentedControl sender) {
        Path selected = this.getPreviousPath();
        if (selected != null) {
            Path previous = this.workdir();
            if (previous.getParent().equals((Object)selected)) {
                this.setWorkdir(selected, previous);
            } else {
                this.setWorkdir(selected);
            }
        }
    }

    public void forwardButtonClicked(NSSegmentedControl sender) {
        Path selected = this.getForwardPath();
        if (selected != null) {
            this.setWorkdir(selected);
        }
    }

    public void setUpButton(NSSegmentedControl upButton) {
        this.upButton = upButton;
        this.upButton.setTarget(this.id());
        this.upButton.setAction(Foundation.selector("upButtonClicked:"));
    }

    public void upButtonClicked(ID sender) {
        Path previous = this.workdir();
        this.setWorkdir(previous.getParent(), previous);
    }

    public void setPathPopup(NSPopUpButton pathPopupButton) {
        this.pathPopupButton = pathPopupButton;
        this.pathPopupButton.setTarget(this.id());
        this.pathPopupButton.setAction(Foundation.selector("pathPopupSelectionChanged:"));
    }

    private void addPathToNavigation(Path p) {
        this.pathPopupButton.addItemWithTitle(p.getAbsolute());
        this.pathPopupButton.lastItem().setRepresentedObject(p.getAbsolute());
        this.pathPopupButton.lastItem().setImage(CDIconCache.instance().iconForPath(p, (Integer)16));
    }

    private void validateNavigationButtons() {
        if (!this.isMounted()) {
            this.pathPopupButton.removeAllItems();
        } else {
            this.pathPopupButton.removeAllItems();
            this.addPathToNavigation(this.workdir);
            Path p = this.workdir;
            while (!p.getParent().equals((Object)p)) {
                this.addPathToNavigation(p);
                p = p.getParent();
            }
            this.addPathToNavigation(p);
        }
        this.navigationButton.setEnabled_forSegment(this.isMounted() && this.getBackHistory().size() > 1, 0);
        this.navigationButton.setEnabled_forSegment(this.isMounted() && this.getForwardHistory().size() > 0, 1);
        this.upButton.setEnabled_forSegment(this.isMounted() && !this.workdir().isRoot(), 0);
        this.pathPopupButton.setEnabled(this.isMounted());
        boolean enabled = this.isMounted() || this.getSelectedTabView() == 0;
        this.searchField.setEnabled(enabled);
        if (!enabled) {
            this.searchField.setStringValue("");
        }
    }

    public void pathPopupSelectionChanged(ID sender) {
        String selected = this.pathPopupButton.itemAtIndex(this.pathPopupButton.indexOfSelectedItem()).representedObject();
        Path previous = this.workdir();
        if (selected != null) {
            Path path = PathFactory.createPath((Session)this.session, (String)selected, (int)2);
            this.setWorkdir(path);
            if (previous.getParent().equals((Object)path)) {
                this.setWorkdir(path, previous);
            } else {
                this.setWorkdir(path);
            }
        }
    }

    public void setEncodingPopup(NSPopUpButton encodingPopup) {
        this.encodingPopup = encodingPopup;
        this.encodingPopup.setTarget(this.id());
        this.encodingPopup.setAction(Foundation.selector("encodingButtonClicked:"));
        this.encodingPopup.removeAllItems();
        this.encodingPopup.addItemsWithTitles(NSArray.arrayWithObjects(CDMainController.availableCharsets()));
        this.encodingPopup.selectItemWithTitle(Preferences.instance().getProperty("browser.charset.encoding"));
    }

    public void encodingButtonClicked(NSPopUpButton sender) {
        this.encodingChanged(sender.titleOfSelectedItem());
    }

    public void encodingMenuClicked(NSMenuItem sender) {
        this.encodingChanged(sender.title());
    }

    public void encodingChanged(final String encoding) {
        if (null == encoding) {
            return;
        }
        this.setEncoding(encoding);
        if (this.isMounted()) {
            if (this.session.getEncoding().equals(encoding)) {
                return;
            }
            this.background((BackgroundAction)new BrowserBackgroundAction(this){

                public void run() {
                    CDBrowserController.this.unmountImpl();
                }

                public void cleanup() {
                    CDBrowserController.this.session.getHost().setEncoding(encoding);
                    CDBrowserController.this.reloadButtonClicked(null);
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Disconnecting {0}", (String)"Status"), CDBrowserController.this.session.getHost().getHostname());
                }
            });
        }
    }

    private void setEncoding(String encoding) {
        this.encodingPopup.selectItemWithTitle(encoding);
    }

    public void toggleLogDrawer(ID sender) {
        this.logDrawer.toggle(this.id());
    }

    public void setSpinner(NSProgressIndicator spinner) {
        this.spinner = spinner;
        this.spinner.setDisplayedWhenStopped(false);
        this.spinner.setIndeterminate(true);
    }

    public NSProgressIndicator getSpinner() {
        return this.spinner;
    }

    public void setStatusLabel(NSTextField statusLabel) {
        this.statusLabel = statusLabel;
    }

    public void updateStatusLabel() {
        String label = Locale.localizedString((String)"Disconnected", (String)"Status");
        if (this.getSelectedTabView() == 0) {
            label = (Object)((Object)this.bookmarkTable.numberOfRows()) + " " + Locale.localizedString((String)"Bookmarks");
        } else if (this.isMounted() && this.isConnected()) {
            label = (Object)((Object)this.getSelectedBrowserView().numberOfRows()) + " " + Locale.localizedString((String)"Files");
        }
        this.updateStatusLabel(label);
    }

    public void updateStatusLabel(String label) {
        this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(label, TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public void setSecurityLabel(NSButton securityLabel) {
        this.securityLabel = securityLabel;
        this.securityLabel.setImage(CDIconCache.iconNamed("unlocked.tiff"));
        this.securityLabel.setEnabled(false);
        this.securityLabel.setTarget(this.id());
        this.securityLabel.setAction(Foundation.selector("securityLabelClicked:"));
    }

    public void securityLabelClicked(ID sender) {
        if (this.session instanceof SSLSession) {
            X509Certificate[] certificates = ((SSLSession)this.session).getTrustManager().getAcceptedIssuers();
            if (0 == certificates.length) {
                log.warn((Object)"No accepted certificates found");
                return;
            }
            Keychain.instance().displayCertificates(certificates);
        }
    }

    public void quicklookButtonClicked(ID sender) {
        if (QuickLookFactory.instance().isOpen()) {
            QuickLookFactory.instance().close();
        } else {
            AbstractBrowserTableDelegate<Path> delegate = this.getSelectedBrowserDelegate();
            ((AbstractBrowserTableDelegate)delegate).updateQuickLookSelection((ch.cyberduck.core.Collection<Path>)this.getSelectedPaths());
        }
    }

    public void reloadButtonClicked(ID sender) {
        if (this.isMounted()) {
            ch.cyberduck.core.Collection<Path> selected = this.getSelectedPaths();
            switch (this.browserSwitchView.selectedSegment()) {
                case 0: {
                    this.workdir().invalidate();
                    break;
                }
                case 1: {
                    this.workdir().invalidate();
                    for (int i = 0; i < this.browserOutlineView.numberOfRows().intValue(); ++i) {
                        Path item = this.lookup(new CDPathReference(this.browserOutlineView.itemAtRow(new NSInteger(i))));
                        if (null == item) continue;
                        item.invalidate();
                    }
                    break;
                }
            }
            this.reloadData((List<Path>)selected);
        }
    }

    public void newBrowserButtonClicked(ID sender) {
        Path selected = this.getSelectedPath();
        if (null == selected || !selected.attributes.isDirectory()) {
            selected = this.workdir();
        }
        CDBrowserController c = new CDBrowserController();
        c.cascade();
        c.window().makeKeyAndOrderFront(null);
        Host host = new Host(this.getSession().getHost().getAsDictionary());
        host.setDefaultPath(selected.getAbsolute());
        c.mount(host);
    }

    protected void duplicatePath(Path source, Path destination, boolean edit) {
        this.duplicatePaths(Collections.singletonMap(source, destination), edit);
    }

    protected void duplicatePaths(Map<Path, Path> selected, final boolean edit) {
        final Map<Path, Path> normalized = this.checkHierarchy(selected);
        this.checkOverwrite(normalized.values(), (BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                Iterator sourcesIter = normalized.keySet().iterator();
                Iterator destinationsIter = normalized.values().iterator();
                while (sourcesIter.hasNext() && !this.isCanceled()) {
                    Path source = (Path)sourcesIter.next();
                    Path destination = (Path)destinationsIter.next();
                    source.copy((AbstractPath)destination);
                    source.getParent().invalidate();
                    destination.getParent().invalidate();
                    if (CDBrowserController.this.isConnected()) continue;
                    break;
                }
            }

            public void cleanup() {
                for (Path duplicate : normalized.values()) {
                    if (edit) {
                        Editor editor = EditorFactory.createEditor(CDBrowserController.this, duplicate);
                        editor.open();
                    }
                    if (duplicate.getName().charAt(0) != '.') continue;
                    CDBrowserController.this.setShowHiddenFiles(true);
                }
                CDBrowserController.this.reloadData(new ArrayList<Path>(normalized.values()));
            }
        });
    }

    protected void renamePath(Path path, Path renamed) {
        this.renamePaths(Collections.singletonMap(path, renamed));
    }

    protected void renamePaths(Map<Path, Path> selected) {
        final Map<Path, Path> normalized = this.checkHierarchy(selected);
        this.checkMove(normalized.values(), (BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                Iterator originalIterator = normalized.keySet().iterator();
                Iterator renamedIterator = normalized.values().iterator();
                while (originalIterator.hasNext() && !this.isCanceled()) {
                    Path original = (Path)originalIterator.next();
                    original.getParent().invalidate();
                    Path renamed = (Path)renamedIterator.next();
                    original.rename((AbstractPath)renamed);
                    renamed.invalidate();
                    renamed.getParent().invalidate();
                    if (CDBrowserController.this.isConnected()) continue;
                    break;
                }
            }

            public void cleanup() {
                CDBrowserController.this.reloadData(new ArrayList<Path>(normalized.values()));
            }
        });
    }

    private void checkOverwrite(Collection<Path> selected, final BackgroundAction action) {
        if (selected.size() > 0) {
            StringBuffer alertText = new StringBuffer(Locale.localizedString((String)"A file with the same name already exists. Do you want to replace the existing file?"));
            Iterator<Path> iter = null;
            boolean shouldWarn = false;
            iter = selected.iterator();
            for (int i = 0; i < 10 && iter.hasNext(); ++i) {
                Path item = iter.next();
                if (!item.exists()) continue;
                alertText.append("\n" + Character.toString('\u2022') + " " + item.getName());
                shouldWarn = true;
            }
            if (iter.hasNext()) {
                alertText.append("\n" + Character.toString('\u2022') + " ...)");
            }
            if (shouldWarn) {
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Overwrite"), alertText.toString(), Locale.localizedString((String)"Overwrite"), Locale.localizedString((String)"Cancel"), null);
                this.alert(alert, new CDSheetCallback(){

                    public void callback(int returncode) {
                        if (returncode == 1) {
                            CDBrowserController.this.background(action);
                        }
                    }
                });
            } else {
                this.background(action);
            }
        }
    }

    private void checkMove(final Collection<Path> selected, final BackgroundAction action) {
        if (selected.size() > 0) {
            if (Preferences.instance().getBoolean("browser.confirmMove")) {
                StringBuffer alertText = new StringBuffer(Locale.localizedString((String)"Do you want to move the selected files?"));
                Iterator<Path> iter = null;
                iter = selected.iterator();
                for (int i = 0; i < 10 && iter.hasNext(); ++i) {
                    Path item = iter.next();
                    alertText.append("\n" + Character.toString('\u2022') + " " + item.getName());
                }
                if (iter.hasNext()) {
                    alertText.append("\n" + Character.toString('\u2022') + " ...)");
                }
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Move"), alertText.toString(), Locale.localizedString((String)"Move"), Locale.localizedString((String)"Cancel"), null);
                this.alert(alert, new CDSheetCallback(){

                    public void callback(int returncode) {
                        if (returncode == 1) {
                            CDBrowserController.this.checkOverwrite(selected, action);
                        }
                    }
                });
            } else {
                this.checkOverwrite(selected, action);
            }
        }
    }

    private Map<Path, Path> checkHierarchy(Map<Path, Path> selected) {
        HashMap<Path, Path> normalized = new HashMap<Path, Path>();
        Iterator<Path> sourcesIter = selected.keySet().iterator();
        Iterator<Path> destinationsIter = selected.values().iterator();
        while (sourcesIter.hasNext()) {
            Path f = sourcesIter.next();
            Path r = destinationsIter.next();
            boolean duplicate = false;
            Iterator normalizedIter = normalized.keySet().iterator();
            while (normalizedIter.hasNext()) {
                Path n = (Path)normalizedIter.next();
                if (f.isChild((AbstractPath)n)) {
                    duplicate = true;
                    break;
                }
                if (!n.isChild((AbstractPath)f)) continue;
                normalizedIter.remove();
            }
            if (duplicate) continue;
            normalized.put(f, r);
        }
        return normalized;
    }

    protected List<Path> checkHierarchy(List<Path> selected) {
        ch.cyberduck.core.Collection normalized = new ch.cyberduck.core.Collection();
        for (Path f : selected) {
            boolean duplicate = false;
            for (Path n : normalized) {
                if (!f.isChild((AbstractPath)n)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            normalized.add(f);
        }
        return normalized;
    }

    public void deletePath(Path file) {
        this.deletePaths(Collections.singletonList(file));
    }

    public void deletePaths(List<Path> selected) {
        final List<Path> normalized = this.checkHierarchy(selected);
        if (normalized.isEmpty()) {
            return;
        }
        StringBuffer alertText = new StringBuffer(Locale.localizedString((String)"Really delete the following files? This cannot be undone."));
        Iterator<Path> iter = null;
        iter = normalized.iterator();
        for (int i = 0; i < 10 && iter.hasNext(); ++i) {
            alertText.append("\n").append(Character.toString('\u2022')).append(" ").append(iter.next().getName());
        }
        if (iter.hasNext()) {
            alertText.append("\n").append(Character.toString('\u2022')).append(" (...)");
        }
        NSAlert alert = NSAlert.alert(Locale.localizedString((String)TOOLBAR_DELETE), alertText.toString(), Locale.localizedString((String)TOOLBAR_DELETE), Locale.localizedString((String)"Cancel"), null);
        this.alert(alert, new CDSheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    CDBrowserController.this.deletePathsImpl(normalized);
                }
            }
        });
    }

    private void deletePathsImpl(final List<Path> files) {
        this.background((BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                for (Path file : files) {
                    if (this.isCanceled()) break;
                    Path f = file;
                    f.delete();
                    f.getParent().invalidate();
                    if (CDBrowserController.this.isConnected()) continue;
                    break;
                }
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Deleting {0}", (String)"Status"), "");
            }

            public void cleanup() {
                CDBrowserController.this.reloadData(false);
            }
        });
    }

    private boolean isEditable(Path selected) {
        if (selected.attributes.isFile()) {
            return !selected.getBinaryFiletypePattern().matcher(selected.getName()).matches();
        }
        return false;
    }

    public void gotoButtonClicked(ID sender) {
        CDGotoController sheet = new CDGotoController(this);
        sheet.beginSheet();
    }

    public void createFileButtonClicked(ID sender) {
        CDCreateFileController sheet = new CDCreateFileController(this);
        sheet.beginSheet();
    }

    public void duplicateFileButtonClicked(ID sender) {
        CDDuplicateFileController sheet = new CDDuplicateFileController(this);
        sheet.beginSheet();
    }

    public void createFolderButtonClicked(ID sender) {
        CDFolderController sheet = new CDFolderController(this);
        sheet.beginSheet();
    }

    public void renameFileButtonClicked(ID sender) {
        NSTableView browser = this.getSelectedBrowserView();
        browser.editRow(browser.columnWithIdentifier("FILENAME"), browser.selectedRow(), true);
    }

    public void sendCustomCommandClicked(ID sender) {
        CDCommandController sheet = new CDCommandController((CDWindowController)this, this.session);
        sheet.beginSheet();
    }

    public void editMenuClicked(NSMenuItem sender) {
        for (Path selected : this.getSelectedPaths()) {
            String identifier = EditorFactory.getSupportedOdbEditors().get(sender.title());
            if (identifier == null) continue;
            Editor editor = EditorFactory.createEditor(this, identifier, selected);
            editor.open();
        }
    }

    public void editButtonClicked(ID sender) {
        for (Path selected : this.getSelectedPaths()) {
            Editor editor = EditorFactory.createEditor(this, selected);
            editor.open();
        }
    }

    public void openBrowserButtonClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(this.getSelectedPathWebUrl()));
    }

    protected String getSelectedPathWebUrl() {
        Path selected = this.getSelectionCount() == 1 ? this.getSelectedPath() : this.workdir();
        return selected.toHttpURL();
    }

    public void infoButtonClicked(ID sender) {
        if (this.getSelectionCount() > 0) {
            ch.cyberduck.core.Collection<Path> selected = this.getSelectedPaths();
            if (Preferences.instance().getBoolean("browser.info.isInspector")) {
                if (null == this.inspector || null == this.inspector.window()) {
                    this.inspector = CDInfoController.Factory.create(this, selected);
                } else {
                    this.inspector.setFiles((List<Path>)selected);
                }
                this.inspector.window().makeKeyAndOrderFront(null);
            } else {
                CDInfoController c = CDInfoController.Factory.create(this, selected);
                c.window().makeKeyAndOrderFront(null);
            }
        }
    }

    public void deleteFileButtonClicked(ID sender) {
        this.deletePaths((List<Path>)this.getSelectedPaths());
    }

    public void downloadToButtonClicked(ID sender) {
        this.downloadToPanel = NSOpenPanel.openPanel();
        this.downloadToPanel.setCanChooseDirectories(true);
        this.downloadToPanel.setCanCreateDirectories(true);
        this.downloadToPanel.setCanChooseFiles(false);
        this.downloadToPanel.setAllowsMultipleSelection(false);
        this.downloadToPanel.setPrompt(Locale.localizedString((String)"Download To"));
        this.downloadToPanel.setTitle(Locale.localizedString((String)"Download To"));
        this.downloadToPanel.beginSheetForDirectory(lastSelectedDownloadDirectory, null, this.window, this.id(), Foundation.selector("downloadToPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void downloadToPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.close();
        if (returncode == 1) {
            Session session = this.getTransferSession();
            ch.cyberduck.core.Collection roots = new ch.cyberduck.core.Collection();
            for (Path selected : this.getSelectedPaths()) {
                Path path = PathFactory.createPath((Session)session, (Object)selected.getAsDictionary());
                path.setLocal(LocalFactory.createLocal((String)sheet.filename(), (String)path.getLocal().getName()));
                roots.add(path);
            }
            DownloadTransfer q = new DownloadTransfer((List)roots);
            this.transfer((Transfer)q);
        }
        lastSelectedDownloadDirectory = sheet.filename();
        this.downloadToPanel = null;
    }

    public void downloadAsButtonClicked(ID sender) {
        this.downloadAsPanel = NSSavePanel.savePanel();
        this.downloadAsPanel.setMessage(Locale.localizedString((String)"Download the selected file to..."));
        this.downloadAsPanel.setNameFieldLabel(Locale.localizedString((String)"Download As:"));
        this.downloadAsPanel.setPrompt(Locale.localizedString((String)TOOLBAR_DOWNLOAD));
        this.downloadAsPanel.setTitle(Locale.localizedString((String)TOOLBAR_DOWNLOAD));
        this.downloadAsPanel.setCanCreateDirectories(true);
        this.downloadAsPanel.beginSheetForDirectory(null, this.getSelectedPath().getLocal().getName(), this.window, this.id(), Foundation.selector("downloadAsPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void downloadAsPanelDidEnd_returnCode_contextInfo(NSSavePanel sheet, int returncode, ID contextInfo) {
        String filename;
        sheet.close();
        if (returncode == 1 && (filename = sheet.filename()) != null) {
            Path selection = PathFactory.createPath((Session)this.getTransferSession(), (Object)this.getSelectedPath().getAsDictionary());
            selection.setLocal(LocalFactory.createLocal((String)filename));
            DownloadTransfer q = new DownloadTransfer(selection);
            this.transfer((Transfer)q);
        }
    }

    public void syncButtonClicked(ID sender) {
        Path selection = this.getSelectionCount() == 1 && this.getSelectedPath().attributes.isDirectory() ? this.getSelectedPath() : this.workdir();
        this.syncPanel = NSOpenPanel.openPanel();
        this.syncPanel.setCanChooseDirectories(selection.attributes.isDirectory());
        this.syncPanel.setCanChooseFiles(selection.attributes.isFile());
        this.syncPanel.setCanCreateDirectories(true);
        this.syncPanel.setAllowsMultipleSelection(false);
        this.syncPanel.setMessage(Locale.localizedString((String)TOOLBAR_SYNCHRONIZE) + " " + selection.getName() + " " + Locale.localizedString((String)"with"));
        this.syncPanel.setPrompt(Locale.localizedString((String)"Choose"));
        this.syncPanel.setTitle(Locale.localizedString((String)TOOLBAR_SYNCHRONIZE));
        this.syncPanel.beginSheetForDirectory(null, null, this.window, this.id(), Foundation.selector("syncPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void syncPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.close();
        if (returncode == 1 && sheet.filenames().count().intValue() > 0) {
            Path selection = this.getSelectionCount() == 1 && this.getSelectedPath().attributes.isDirectory() ? PathFactory.createPath((Session)this.getTransferSession(), (Object)this.getSelectedPath().getAsDictionary()) : PathFactory.createPath((Session)this.getTransferSession(), (Object)this.workdir().getAsDictionary());
            selection.setLocal(LocalFactory.createLocal((String)sheet.filenames().lastObject().toString()));
            SyncTransfer q = new SyncTransfer(selection);
            this.transfer((Transfer)q, selection);
        }
    }

    public void downloadButtonClicked(ID sender) {
        Session session = this.getTransferSession();
        ch.cyberduck.core.Collection roots = new ch.cyberduck.core.Collection();
        for (Path selected : this.getSelectedPaths()) {
            Path path = PathFactory.createPath((Session)session, (Object)selected.getAsDictionary());
            path.setLocal(null);
            roots.add(path);
        }
        DownloadTransfer q = new DownloadTransfer((List)roots);
        this.transfer((Transfer)q);
    }

    public void uploadButtonClicked(ID sender) {
        this.uploadPanel = NSOpenPanel.openPanel();
        this.uploadPanel.setCanChooseDirectories(true);
        this.uploadPanel.setCanCreateDirectories(false);
        this.uploadPanel.setCanChooseFiles(true);
        this.uploadPanel.setAllowsMultipleSelection(true);
        this.uploadPanel.setPrompt(Locale.localizedString((String)TOOLBAR_UPLOAD));
        this.uploadPanel.setTitle(Locale.localizedString((String)TOOLBAR_UPLOAD));
        this.uploadPanel.beginSheetForDirectory(lastSelectedUploadDirectory, null, this.window, this.id(), Foundation.selector("uploadPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void uploadPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.close();
        if (returncode == 1) {
            NSObject next;
            Path destination = this.getSelectedPath();
            if (null == destination) {
                destination = this.workdir();
            } else if (!destination.attributes.isDirectory()) {
                destination = destination.getParent();
            }
            NSArray selected = sheet.filenames();
            NSEnumerator iterator = selected.objectEnumerator();
            Session session = this.getTransferSession();
            ch.cyberduck.core.Collection roots = new ch.cyberduck.core.Collection();
            while ((next = iterator.nextObject()) != null) {
                roots.add(PathFactory.createPath((Session)session, (String)destination.getAbsolute(), (Local)LocalFactory.createLocal((String)next.toString())));
            }
            UploadTransfer q = new UploadTransfer((List)roots);
            this.transfer((Transfer)q, destination);
        }
        lastSelectedUploadDirectory = new File(sheet.filename()).getParent();
        this.uploadPanel = null;
    }

    protected Session getTransferSession() {
        if (!this.isMounted()) {
            return null;
        }
        if (this.session.getMaxConnections() == 1) {
            return this.session;
        }
        Host h = new Host(this.session.getHost().getAsDictionary());
        h.getCredentials().setPassword(this.session.getHost().getCredentials().getPassword());
        return SessionFactory.createSession((Host)h);
    }

    protected void transfer(final Transfer transfer, final Path workdir) {
        TransferAdapter l = new TransferAdapter(){

            public void transferDidEnd() {
                if (CDBrowserController.this.isMounted()) {
                    workdir.invalidate();
                    if (!transfer.isCanceled()) {
                        CDBrowserController.this.invoke((MainAction)new WindowMainAction(CDBrowserController.this){

                            public void run() {
                                CDBrowserController.this.reloadData(true);
                            }

                            public boolean isValid() {
                                return super.isValid() && CDBrowserController.this.isConnected();
                            }
                        });
                    }
                }
            }
        };
        transfer.addListener((TransferListener)l);
        this.addListener(new CDWindowListener((TransferListener)l){
            final /* synthetic */ TransferListener val$l;
            {
                this.val$l = transferListener;
            }

            public void windowWillClose() {
                transfer.removeListener(this.val$l);
            }
        });
        this.transfer(transfer);
    }

    protected void transfer(Transfer transfer) {
        this.transfer(transfer, transfer.getSession().getMaxConnections() == 1);
    }

    protected void transfer(Transfer transfer, boolean useBrowserConnection) {
        this.transfer(transfer, useBrowserConnection, CDTransferPrompt.create(this, transfer));
    }

    protected void transfer(final Transfer transfer, boolean useBrowserConnection, final TransferPrompt prompt) {
        if (useBrowserConnection) {
            final Speedometer meter = new Speedometer(transfer);
            long delay = 0L;
            long period = 500L;
            TransferAdapter l = new TransferAdapter(){
                private Timer progressTimer;

                public void willTransferPath(Path path) {
                    meter.reset();
                    this.progressTimer = new Timer();
                    this.progressTimer.scheduleAtFixedRate(new TimerTask(){

                        public void run() {
                            CDBrowserController.this.invoke((MainAction)new WindowMainAction(CDBrowserController.this){

                                public void run() {
                                    CDBrowserController.this.updateStatusLabel(meter.getProgress());
                                }
                            });
                        }
                    }, 0L, 500L);
                }

                public void didTransferPath(Path path) {
                    this.progressTimer.cancel();
                    meter.reset();
                }

                public void bandwidthChanged(BandwidthThrottle bandwidth) {
                    meter.reset();
                }
            };
            transfer.addListener((TransferListener)l);
            this.addListener(new CDWindowListener((TransferListener)l){
                final /* synthetic */ TransferListener val$l;
                {
                    this.val$l = transferListener;
                }

                public void windowWillClose() {
                    transfer.removeListener(this.val$l);
                }
            });
            this.background((BackgroundAction)new BrowserBackgroundAction(this){

                public void run() {
                    TransferOptions options = new TransferOptions();
                    options.closeSession = false;
                    transfer.start(prompt, options);
                }

                public void cancel() {
                    transfer.cancel();
                    super.cancel();
                }

                public void cleanup() {
                    CDBrowserController.this.updateStatusLabel();
                }

                public String getActivity() {
                    return transfer.getName();
                }
            });
        } else {
            CDTransferController.instance().startTransfer(transfer);
        }
    }

    public void insideButtonClicked(ID sender) {
        Path selected = this.getSelectedPath();
        if (null == selected) {
            return;
        }
        if (selected.attributes.isDirectory()) {
            this.setWorkdir(selected);
        } else if (selected.attributes.isFile() || this.getSelectionCount() > 1) {
            if (Preferences.instance().getBoolean("browser.doubleclick.edit")) {
                this.editButtonClicked(null);
            } else {
                this.downloadButtonClicked(null);
            }
        }
    }

    public void connectButtonClicked(ID sender) {
        final CDConnectionController controller = CDConnectionController.instance(this);
        this.addListener(new CDWindowListener(){

            public void windowWillClose() {
                controller.invalidate();
            }
        });
        controller.beginSheet();
    }

    public void interruptButtonClicked(ID sender) {
        for (BackgroundAction action : (BackgroundAction[])BackgroundActionRegistry.instance().toArray((Object[])new BackgroundAction[BackgroundActionRegistry.instance().size()])) {
            action.cancel();
        }
        this.interrupt();
    }

    public void disconnectButtonClicked(ID sender) {
        if (this.isActivityRunning()) {
            this.interruptButtonClicked(sender);
        } else {
            this.disconnect();
        }
    }

    public void showHiddenFilesClicked(NSMenuItem sender) {
        if (sender.state() == 1) {
            this.setShowHiddenFiles(false);
            sender.setState(0);
        } else if (sender.state() == 0) {
            this.setShowHiddenFiles(true);
            sender.setState(1);
        }
        if (this.isMounted()) {
            this.reloadData(true);
        }
    }

    public boolean hasSession() {
        return this.session != null;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isMounted() {
        return this.hasSession() && this.workdir() != null;
    }

    public boolean isConnected() {
        if (this.isMounted()) {
            return this.session.isConnected();
        }
        return false;
    }

    public void cut(ID sender) {
        for (Path selected : this.getSelectedPaths()) {
            PathPasteboard.getPasteboard(this.getSession().getHost()).add(selected.getAsDictionary());
        }
        NSPasteboard generalPasteboard = NSPasteboard.generalPasteboard();
        generalPasteboard.declareTypes(NSArray.arrayWithObject(NSString.stringWithString("NSStringPboardType")), null);
        if (!generalPasteboard.setStringForType(this.getSelectedPath().getAbsolute(), "NSStringPboardType")) {
            log.error((Object)"Error writing absolute path of selected item to NSPasteboard.StringPboardType.");
        }
    }

    public void paste(ID sender) {
        PathPasteboard<NSDictionary> pasteboard = PathPasteboard.getPasteboard(this.getSession().getHost());
        if (pasteboard.isEmpty()) {
            return;
        }
        HashMap<Path, Path> files = new HashMap<Path, Path>();
        Path parent = this.workdir();
        if (this.getSelectionCount() == 1) {
            Path selected = this.getSelectedPath();
            parent = selected.attributes.isDirectory() ? selected : selected.getParent();
        }
        for (Path next : pasteboard.getFiles(this.getSession())) {
            Path current = PathFactory.createPath((Session)this.getSession(), (String)next.getAbsolute(), (int)next.attributes.getType());
            Path renamed = PathFactory.createPath((Session)this.getSession(), (String)parent.getAbsolute(), (String)current.getName(), (int)next.attributes.getType());
            files.put(current, renamed);
        }
        pasteboard.clear();
        this.renamePaths(files);
    }

    public void pasteFromFinder(ID sender) {
        NSObject o;
        NSPasteboard pboard = NSPasteboard.generalPasteboard();
        if (pboard.availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null) {
            NSArray elements = Rococoa.cast(o, NSArray.class);
            Path workdir = this.workdir();
            Session session = this.getTransferSession();
            ch.cyberduck.core.Collection roots = new ch.cyberduck.core.Collection();
            for (int i = 0; i < elements.count().intValue(); ++i) {
                Path p = PathFactory.createPath((Session)session, (String)workdir.getAbsolute(), (Local)LocalFactory.createLocal((String)elements.objectAtIndex(new NSUInteger(i)).toString()));
                roots.add(p);
            }
            UploadTransfer q = new UploadTransfer((List)roots);
            if (q.numberOfRoots() > 0) {
                this.transfer((Transfer)q, workdir);
            }
        }
    }

    public void copyURLButtonClicked(ID sender) {
        StringBuffer url = new StringBuffer();
        if (this.getSelectionCount() > 0) {
            Iterator iter = this.getSelectedPaths().iterator();
            while (iter.hasNext()) {
                url.append(((Path)iter.next()).toURL());
                if (!iter.hasNext()) continue;
                url.append("\n");
            }
        } else {
            url.append(this.workdir().toURL());
        }
        NSPasteboard pboard = NSPasteboard.generalPasteboard();
        pboard.declareTypes(NSArray.arrayWithObject(NSString.stringWithString("NSStringPboardType")), null);
        if (!pboard.setStringForType(url.toString(), "NSStringPboardType")) {
            log.error((Object)"Error writing URL to NSPasteboard.StringPboardType.");
        }
    }

    public void copyWebURLButtonClicked(ID sender) {
        NSPasteboard pboard = NSPasteboard.generalPasteboard();
        pboard.declareTypes(NSArray.arrayWithObject("NSStringPboardType"), null);
        if (!pboard.setString_forType(this.getSelectedPathWebUrl(), "NSStringPboardType")) {
            log.error((Object)"Error writing URL to NSPasteboard.StringPboardType.");
        }
    }

    public void openTerminalButtonClicked(ID sender) {
        boolean identity = this.getSession().getHost().getCredentials().isPublicKeyAuthentication();
        String workdir = null;
        if (this.getSelectionCount() == 1) {
            Path selected = this.getSelectedPath();
            if (selected.attributes.isDirectory()) {
                workdir = selected.getAbsolute();
            }
        }
        if (null == workdir) {
            workdir = this.workdir.getAbsolute();
        }
        String command = "tell application \"Terminal\"\ndo script \"ssh -t " + (identity ? "-i " + this.getSession().getHost().getCredentials().getIdentity().getAbsolute() : "") + " " + this.getSession().getHost().getCredentials().getUsername() + "@" + this.getSession().getHost().getHostname() + " " + "-p " + this.getSession().getHost().getPort() + " " + "\\\"cd " + workdir + " && exec \\\\$SHELL\\\"\"" + "\n" + "end tell";
        NSAppleScript as = NSAppleScript.createWithSource(command);
        as.executeAndReturnError((ByReference)new PointerByReference());
        NSWorkspace.sharedWorkspace().launchApplication(NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier("com.apple.Terminal"));
    }

    public void archiveMenuClicked(NSMenuItem sender) {
        Archive archive = Archive.forName((String)sender.representedObject());
        this.archiveClicked(archive);
    }

    public void archiveButtonClicked(NSToolbarItem sender) {
        this.archiveClicked(Archive.TARGZ);
    }

    private void archiveClicked(final Archive archive) {
        final ch.cyberduck.core.Collection<Path> selected = this.getSelectedPaths();
        this.checkOverwrite(Collections.singletonList(archive.getArchive(selected)), (BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                CDBrowserController.this.session.archive(archive, (List)selected);
            }

            public void cleanup() {
                CDBrowserController.this.reloadData(Collections.singletonList(archive.getArchive((List)selected)));
            }

            public String getActivity() {
                return archive.getCompressCommand((List)selected);
            }
        });
    }

    public void unarchiveButtonClicked(ID sender) {
        final ArrayList expanded = new ArrayList();
        for (final Path selected : this.getSelectedPaths()) {
            final Archive archive = Archive.forName((String)selected.getName());
            if (null == archive) continue;
            this.checkOverwrite(archive.getExpanded(Collections.singletonList(selected)), (BackgroundAction)new BrowserBackgroundAction(this){

                public void run() {
                    CDBrowserController.this.session.unarchive(archive, selected);
                }

                public void cleanup() {
                    expanded.addAll(archive.getExpanded(Collections.singletonList(selected)));
                    CDBrowserController.this.reloadData(expanded);
                }

                public String getActivity() {
                    return archive.getDecompressCommand(selected);
                }
            });
        }
    }

    public boolean isActivityRunning() {
        BackgroundAction current = BackgroundActionRegistry.instance().getCurrent();
        if (null == current) {
            return false;
        }
        if (current instanceof BrowserBackgroundAction) {
            return ((BrowserBackgroundAction)current).getController() == this;
        }
        return false;
    }

    public Path lookup(CDPathReference path) {
        if (this.isMounted()) {
            return (Path)this.getSession().cache().lookup((PathReference)path);
        }
        return null;
    }

    protected Path workdir() {
        return this.workdir;
    }

    public void setWorkdir(Path directory) {
        this.setWorkdir(directory, Collections.<Path>emptyList());
    }

    public void setWorkdir(Path directory, Path selected) {
        this.setWorkdir(directory, Collections.singletonList(selected));
    }

    public void setWorkdir(final Path directory, final List<Path> selected) {
        log.debug((Object)("setWorkdir:" + directory));
        if (null == directory) {
            this.workdir = null;
            this.validateNavigationButtons();
            this.reloadData(false);
            return;
        }
        this.background((BackgroundAction)new BrowserBackgroundAction(this){

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Listing directory {0}", (String)"Status"), directory.getName());
            }

            public void run() {
                if (directory.isCached()) {
                    directory.childs().attributes().setReadable(true);
                }
                directory.childs();
                if (directory.childs().attributes().isReadable()) {
                    CDBrowserController.this.workdir = directory;
                    CDBrowserController.this.addPathToHistory(CDBrowserController.this.workdir);
                }
            }

            public void cleanup() {
                CDBrowserController.this.setPathFilter(null);
                CDBrowserController.this.browserSwitchClicked(Preferences.instance().getInteger("browser.view"));
                CDBrowserController.this.validateNavigationButtons();
                CDBrowserController.this.reloadData(selected);
            }
        });
    }

    public void addPathToHistory(Path p) {
        if (this.backHistory.size() > 0 && p.equals((Object)this.backHistory.get(this.backHistory.size() - 1))) {
            return;
        }
        this.backHistory.add(p);
    }

    public Path getPreviousPath() {
        int size = this.backHistory.size();
        if (size > 1) {
            this.forwardHistory.add(this.backHistory.get(size - 1));
            Path p = this.backHistory.get(size - 2);
            this.backHistory.remove(size - 1);
            this.backHistory.remove(size - 2);
            return p;
        }
        if (1 == size) {
            this.forwardHistory.add(this.backHistory.get(size - 1));
            return this.backHistory.get(size - 1);
        }
        return null;
    }

    public Path getForwardPath() {
        int size = this.forwardHistory.size();
        if (size > 0) {
            Path p = this.forwardHistory.get(size - 1);
            this.forwardHistory.remove(size - 1);
            return p;
        }
        return null;
    }

    public List<Path> getBackHistory() {
        return this.backHistory;
    }

    public void clearBackHistory() {
        this.backHistory.clear();
    }

    public List<Path> getForwardHistory() {
        return this.forwardHistory;
    }

    public void clearForwardHistory() {
        this.forwardHistory.clear();
    }

    private Session init(final Host host) {
        if (this.hasSession()) {
            this.session.removeConnectionListener(this.listener);
        }
        this.session = SessionFactory.createSession((Host)host);
        if (this.session instanceof SFTPSession) {
            ((SFTPSession)this.session).setHostKeyVerificationController((ServerHostKeyVerifier)new CDHostKeyController(this));
        }
        this.session.setLoginController((LoginController)new CDLoginController(this));
        this.setWorkdir(null);
        this.setEncoding(this.session.getEncoding());
        this.session.addProgressListener(new ProgressListener(){

            public void message(final String message) {
                CDBrowserController.this.invoke((MainAction)new WindowMainAction(CDBrowserController.this){

                    public void run() {
                        CDBrowserController.this.updateStatusLabel(message);
                    }
                });
            }
        });
        this.listener = new ConnectionAdapter(){

            public void connectionWillOpen() {
                CDBrowserController.this.invoke((MainAction)new WindowMainAction(CDBrowserController.this){

                    public void run() {
                        CDBrowserController.this.bookmarkTable.setNeedsDisplay();
                        CDBrowserController.this.window.setTitle(host.getNickname());
                        CDBrowserController.this.window.setRepresentedFilename("");
                    }
                });
            }

            public void connectionDidOpen() {
                CDBrowserController.this.invoke((MainAction)new WindowMainAction(CDBrowserController.this){

                    public void run() {
                        CDBrowserController.this.getSelectedBrowserView().setNeedsDisplay();
                        CDBrowserController.this.bookmarkTable.setNeedsDisplay();
                        Growl.instance().notify("Connection opened", host.getHostname());
                        HistoryCollection history = HistoryCollection.defaultCollection();
                        history.add(host);
                        CDBrowserController.this.window.setRepresentedFilename(history.getFile(host).getAbsolute());
                        if (Preferences.instance().getBoolean("browser.confirmDisconnect")) {
                            CDBrowserController.this.window.setDocumentEdited(true);
                        }
                        CDBrowserController.this.securityLabel.setImage(CDBrowserController.this.session.isSecure() ? CDIconCache.iconNamed("locked.tiff") : CDIconCache.iconNamed("unlocked.tiff"));
                        CDBrowserController.this.securityLabel.setEnabled(CDBrowserController.this.session instanceof SSLSession);
                    }
                });
            }

            public void connectionDidClose() {
                CDBrowserController.this.invoke((MainAction)new WindowMainAction(CDBrowserController.this){

                    public void run() {
                        CDBrowserController.this.getSelectedBrowserView().setNeedsDisplay();
                        CDBrowserController.this.bookmarkTable.setNeedsDisplay();
                        if (!CDBrowserController.this.isMounted()) {
                            CDBrowserController.this.window.setTitle(NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleName").toString());
                            CDBrowserController.this.window.setRepresentedFilename("");
                        }
                        CDBrowserController.this.window.setDocumentEdited(false);
                        CDBrowserController.this.securityLabel.setImage(CDIconCache.iconNamed("unlocked.tiff"));
                        CDBrowserController.this.securityLabel.setEnabled(false);
                        CDBrowserController.this.updateStatusLabel();
                    }
                });
            }
        };
        this.session.addConnectionListener(this.listener);
        this.transcript.clear();
        this.backHistory.clear();
        this.forwardHistory.clear();
        this.session.addTranscriptListener(new TranscriptListener(){

            public void log(final boolean request, final String message) {
                if (CDBrowserController.this.logDrawer.state() == 2) {
                    CDBrowserController.this.invoke((MainAction)new WindowMainAction(CDBrowserController.this){

                        public void run() {
                            CDBrowserController.this.transcript.log(request, message);
                        }
                    });
                }
            }
        });
        return this.session;
    }

    public void mount(final Host host) {
        log.debug((Object)("mount:" + host));
        this.unmount(new Runnable(){

            public void run() {
                final Session session = CDBrowserController.this.init(host);
                CDBrowserController.this.background((BackgroundAction)new BrowserBackgroundAction(CDBrowserController.this){

                    public void run() {
                        CDBrowserController.this.workdir = session.mount();
                    }

                    public void cleanup() {
                        CDBrowserController.this.setWorkdir(CDBrowserController.this.workdir);
                        if (!session.isConnected()) {
                            log.warn((Object)("Mount failed:" + host));
                            CDBrowserController.this.unmountImpl();
                        }
                    }

                    public String getActivity() {
                        return MessageFormat.format(Locale.localizedString((String)"Mounting {0}", (String)"Status"), host.getHostname());
                    }
                });
            }
        });
    }

    public boolean unmount() {
        return this.unmount(new Runnable(){

            public void run() {
            }
        });
    }

    public boolean unmount(final Runnable disconnected) {
        return this.unmount(new CDSheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    CDBrowserController.this.unmountImpl(disconnected);
                }
            }
        }, disconnected);
    }

    public boolean unmount(CDSheetCallback callback, Runnable disconnected) {
        log.debug((Object)"unmount");
        if (this.isConnected() || this.isActivityRunning()) {
            if (Preferences.instance().getBoolean("browser.confirmDisconnect")) {
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Disconnect from") + " " + this.session.getHost().getHostname(), Locale.localizedString((String)"The connection will be closed."), Locale.localizedString((String)TOOLBAR_DISCONNECT), Locale.localizedString((String)"Cancel"), null);
                this.alert(alert, callback);
                return false;
            }
            this.unmountImpl(disconnected);
            return true;
        }
        disconnected.run();
        return true;
    }

    private void unmountImpl(final Runnable disconnected) {
        if (this.isActivityRunning()) {
            this.interrupt();
        }
        final Session session = this.getSession();
        this.background((BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                CDBrowserController.this.unmountImpl();
            }

            public void cleanup() {
                CDBrowserController.this.inspector = null;
                session.cache().clear();
                session.getHost().getCredentials().setPassword(null);
                disconnected.run();
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Disconnecting {0}", (String)"Status"), session.getHost().getHostname());
            }
        });
    }

    private void unmountImpl() {
        if (this.hasSession()) {
            this.session.close();
        }
    }

    private void interrupt() {
        if (this.hasSession()) {
            BackgroundAction current;
            if (this.isActivityRunning() && null != (current = BackgroundActionRegistry.instance().getCurrent())) {
                current.cancel();
            }
            this.background((BackgroundAction)new BrowserBackgroundAction(this){
                private final Object lock;
                {
                    this.lock = new Object();
                }

                public void run() {
                    if (CDBrowserController.this.hasSession()) {
                        CDBrowserController.this.session.interrupt();
                    }
                }

                public void cleanup() {
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Disconnecting {0}", (String)"Status"), CDBrowserController.this.session.getHost().getHostname());
                }

                public int retry() {
                    return 0;
                }

                public Object lock() {
                    return this.lock;
                }
            });
        }
    }

    private void disconnect() {
        this.background((BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                CDBrowserController.this.unmountImpl();
            }

            public void cleanup() {
                if (Preferences.instance().getBoolean("browser.disconnect.showBookmarks")) {
                    CDBrowserController.this.toggleBookmarks(true);
                }
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Disconnecting {0}", (String)"Status"), CDBrowserController.this.session.getHost().getHostname());
            }
        });
    }

    public void printDocument(ID sender) {
        NSPrintInfo print = NSPrintInfo.sharedPrintInfo();
        print.setOrientation(1);
        NSPrintOperation op = NSPrintOperation.printOperationWithView_printInfo(this.getSelectedBrowserView(), print);
        op.runOperationModalForWindow_delegate_didRunSelector_contextInfo(this.window(), this.id(), Foundation.selector("printOperationDidRun:success:contextInfo:"), null);
    }

    public void printOperationDidRun_success_contextInfo(NSPrintOperation printOperation, boolean success, ID contextInfo) {
        if (success) {
            log.info((Object)("Successfully printed" + (Object)((Object)contextInfo)));
        }
    }

    public static NSUInteger applicationShouldTerminate(final NSApplication app) {
        for (final CDBrowserController controller : CDMainController.getBrowsers()) {
            if (controller.unmount(new CDSheetCallback(){

                public void callback(int returncode) {
                    if (returncode == 1) {
                        controller.window().close();
                        if (NSApplication.NSTerminateNow.equals((Object)CDBrowserController.applicationShouldTerminate(app))) {
                            app.terminate(null);
                        }
                    }
                    if (returncode == 0) {
                        app.replyToApplicationShouldTerminate(false);
                    }
                }
            }, new Runnable(){

                public void run() {
                }
            })) continue;
            return NSApplication.NSTerminateLater;
        }
        return NSApplication.NSTerminateNow;
    }

    @Override
    public boolean windowShouldClose(final NSWindow sender) {
        return this.unmount(new Runnable(){

            public void run() {
                sender.close();
            }
        });
    }

    public boolean validateMenuItem(NSMenuItem item) {
        Selector action = item.action();
        if (action.equals((Object)Foundation.selector("pasteFromFinder:"))) {
            NSObject o;
            boolean valid = false;
            if (this.isMounted() && NSPasteboard.generalPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null && (o = NSPasteboard.generalPasteboard().propertyListForType("NSFilenamesPboardType")) != null) {
                NSArray elements = Rococoa.cast(o, NSArray.class);
                if (elements.count().intValue() == 1) {
                    item.setTitle(Locale.localizedString((String)"Paste") + " \"" + elements.objectAtIndex(new NSUInteger(0L)) + "\"");
                } else {
                    item.setTitle(Locale.localizedString((String)"Paste from Finder") + " (" + elements.count().intValue() + " " + Locale.localizedString((String)"files") + ")");
                }
                valid = true;
            }
            if (!valid) {
                item.setTitle(Locale.localizedString((String)"Paste from Finder"));
            }
        } else if (action.equals((Object)Foundation.selector("paste:"))) {
            if (this.isMounted() && !PathPasteboard.getPasteboard(this.getSession().getHost()).isEmpty()) {
                if (PathPasteboard.getPasteboard(this.getSession().getHost()).size() == 1) {
                    item.setTitle(Locale.localizedString((String)"Paste") + " \"" + PathPasteboard.getPasteboard(this.getSession().getHost()).getFiles(this.getSession()).get(0).getName() + "\"");
                } else {
                    item.setTitle(Locale.localizedString((String)"Paste") + " (" + PathPasteboard.getPasteboard(this.getSession().getHost()).size() + " " + Locale.localizedString((String)"files") + ")");
                }
            } else {
                item.setTitle(Locale.localizedString((String)"Paste"));
            }
        } else if (action.equals((Object)Foundation.selector("cut:"))) {
            int count = this.getSelectionCount();
            if (this.isMounted() && count > 0) {
                if (count > 1) {
                    item.setTitle(Locale.localizedString((String)"Cut") + " " + this.getSelectionCount() + " " + Locale.localizedString((String)"files"));
                } else {
                    item.setTitle(Locale.localizedString((String)"Cut") + " \"" + this.getSelectedPath().getName() + "\"");
                }
            } else {
                item.setTitle(Locale.localizedString((String)"Cut"));
            }
        } else if (action.equals((Object)Foundation.selector("showHiddenFilesClicked:"))) {
            item.setState(this.getFileFilter() instanceof NullPathFilter ? 1 : 0);
        } else if (action.equals((Object)Foundation.selector("encodingMenuClicked:"))) {
            if (this.isMounted()) {
                item.setState(this.session.getEncoding().equalsIgnoreCase(item.title()) ? 1 : 0);
            } else {
                item.setState(Preferences.instance().getProperty("browser.charset.encoding").equalsIgnoreCase(item.title()) ? 1 : 0);
            }
        } else if (action.equals((Object)Foundation.selector("browserSwitchMenuClicked:"))) {
            if (item.tag() == Preferences.instance().getInteger("browser.view")) {
                item.setState(1);
            } else {
                item.setState(0);
            }
        } else if (action.equals((Object)Foundation.selector("archiveMenuClicked:"))) {
            Archive archive = Archive.forName((String)item.representedObject());
            item.setTitle(archive.getTitle(this.getSelectedPaths()));
        } else if (action.equals((Object)Foundation.selector("quicklookButtonClicked:"))) {
            item.setKeyEquivalent(" ");
            item.setKeyEquivalentModifierMask(0);
        }
        return this.validateItem(action);
    }

    private boolean validateItem(Selector action) {
        if (action.equals((Object)Foundation.selector("cut:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("pasteFromFinder:"))) {
            NSObject o;
            NSPasteboard pboard;
            return this.isMounted() && (pboard = NSPasteboard.generalPasteboard()).availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null;
        }
        if (action.equals((Object)Foundation.selector("paste:"))) {
            if (this.isMounted()) {
                return !PathPasteboard.getPasteboard(this.getSession().getHost()).isEmpty();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("encodingMenuClicked:"))) {
            return !this.isActivityRunning();
        }
        if (action.equals((Object)Foundation.selector("connectBookmarkButtonClicked:"))) {
            return this.bookmarkTable.numberOfSelectedRows().intValue() == 1;
        }
        if (action.equals((Object)Foundation.selector("addBookmarkButtonClicked:"))) {
            return this.bookmarkModel.getSource().allowsAdd();
        }
        if (action.equals((Object)Foundation.selector("deleteBookmarkButtonClicked:"))) {
            return this.bookmarkModel.getSource().allowsDelete() && this.bookmarkTable.selectedRow().intValue() != -1;
        }
        if (action.equals((Object)Foundation.selector("editBookmarkButtonClicked:"))) {
            return this.bookmarkModel.getSource().allowsEdit() && this.bookmarkTable.numberOfSelectedRows().intValue() == 1;
        }
        if (action.equals((Object)Foundation.selector("editButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() > 0) {
                String editor = EditorFactory.getSelectedEditor();
                if (null == editor) {
                    return false;
                }
                for (Path selected : this.getSelectedPaths()) {
                    if (this.isEditable(selected)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("editMenuClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() > 0) {
                for (Path selected : this.getSelectedPaths()) {
                    if (this.isEditable(selected)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("searchButtonClicked:"))) {
            return this.isMounted() || this.getSelectedTabView() == 0;
        }
        if (action.equals((Object)Foundation.selector("quicklookButtonClicked:"))) {
            return QuickLookFactory.instance().isAvailable() && this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("openBrowserButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("sendCustomCommandClicked:"))) {
            return this.isMounted() && this.getSession().isSendCommandSupported();
        }
        if (action.equals((Object)Foundation.selector("gotoButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("infoButtonClicked:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("createFolderButtonClicked:"))) {
            return this.isMounted() && this.workdir().isMkdirSupported();
        }
        if (action.equals((Object)Foundation.selector("createFileButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("duplicateFileButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() == 1) {
                Path selected = this.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return selected.attributes.isFile();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("renameFileButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() == 1) {
                Path selected = this.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return selected.isRenameSupported();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("deleteFileButtonClicked:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("reloadButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("newBrowserButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("uploadButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("syncButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("downloadAsButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() == 1) {
                Path selected = this.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return !selected.attributes.isVolume();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("downloadToButtonClicked:")) || action.equals((Object)Foundation.selector("downloadButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() > 0) {
                Path selected = this.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return !selected.attributes.isVolume();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("insideButtonClicked:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("upButtonClicked:"))) {
            return this.isMounted() && !this.workdir().isRoot();
        }
        if (action.equals((Object)Foundation.selector("backButtonClicked:"))) {
            return this.isMounted() && this.getBackHistory().size() > 1;
        }
        if (action.equals((Object)Foundation.selector("forwardButtonClicked:"))) {
            return this.isMounted() && this.getForwardHistory().size() > 0;
        }
        if (action.equals((Object)Foundation.selector("copyURLButtonClicked:")) || action.equals((Object)Foundation.selector("copyWebURLButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("printDocument:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("disconnectButtonClicked:"))) {
            if (!this.isConnected()) {
                return this.isActivityRunning();
            }
            return this.isConnected();
        }
        if (action.equals((Object)Foundation.selector("interruptButtonClicked:"))) {
            return this.isActivityRunning();
        }
        if (action.equals((Object)Foundation.selector("gotofolderButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("openTerminalButtonClicked:"))) {
            return this.isMounted() && this.getSession() instanceof SFTPSession;
        }
        if (action.equals((Object)Foundation.selector("archiveButtonClicked:")) || action.equals((Object)Foundation.selector("archiveMenuClicked:"))) {
            if (this.isMounted()) {
                if (!this.getSession().isArchiveSupported()) {
                    return false;
                }
                if (this.getSelectionCount() > 0) {
                    for (Path selected : this.getSelectedPaths()) {
                        if (!selected.attributes.isFile() || !Archive.isArchive((String)selected.getName())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("unarchiveButtonClicked:"))) {
            if (this.isMounted()) {
                if (!this.getSession().isUnarchiveSupported()) {
                    return false;
                }
                if (this.getSelectionCount() > 0) {
                    for (Path selected : this.getSelectedPaths()) {
                        if (selected.attributes.isDirectory()) {
                            return false;
                        }
                        if (Archive.isArchive((String)selected.getName())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean validateToolbarItem(NSToolbarItem item) {
        Path selected;
        String identifier = item.itemIdentifier();
        if (identifier.equals(TOOLBAR_EDIT)) {
            String selectedEditor = EditorFactory.getSelectedEditor();
            if (null == selectedEditor) {
                item.setImage(CDIconCache.iconNamed("pencil.tiff"));
            } else {
                item.setImage(NSWorkspace.sharedWorkspace().iconForFile(NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(selectedEditor)));
            }
        }
        if (identifier.equals(TOOLBAR_DISCONNECT)) {
            if (this.isActivityRunning()) {
                item.setLabel(Locale.localizedString((String)"Stop"));
                item.setPaletteLabel(Locale.localizedString((String)"Stop"));
                item.setToolTip(Locale.localizedString((String)"Cancel current operation in progress"));
                item.setImage(CDIconCache.iconNamed("stop", 32));
            } else {
                item.setLabel(Locale.localizedString((String)TOOLBAR_DISCONNECT));
                item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_DISCONNECT));
                item.setToolTip(Locale.localizedString((String)"Disconnect from server"));
                item.setImage(CDIconCache.iconNamed("eject.tiff"));
            }
        }
        if (identifier.equals(TOOLBAR_ARCHIVE) && null != (selected = this.getSelectedPath())) {
            if (Archive.isArchive((String)selected.getName())) {
                item.setLabel(Locale.localizedString((String)"Unarchive", (String)TOOLBAR_ARCHIVE));
                item.setPaletteLabel(Locale.localizedString((String)"Unarchive"));
                item.setAction(Foundation.selector("unarchiveButtonClicked:"));
            } else {
                item.setLabel(Locale.localizedString((String)TOOLBAR_ARCHIVE, (String)TOOLBAR_ARCHIVE));
                item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_ARCHIVE));
                item.setAction(Foundation.selector("archiveButtonClicked:"));
            }
        }
        if (identifier.equals(TOOLBAR_QUICKLOOK)) {
            // empty if block
        }
        return this.validateItem(item.action());
    }

    @Override
    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String itemIdentifier, boolean flag) {
        if (!this.toolbarItems.containsKey(itemIdentifier)) {
            this.toolbarItems.put(itemIdentifier, NSToolbarItem.itemWithIdentifier(itemIdentifier));
        }
        NSToolbarItem item = this.toolbarItems.get(itemIdentifier);
        if (itemIdentifier.equals(TOOLBAR_BROWSER_VIEW)) {
            item.setLabel(Locale.localizedString((String)"View"));
            item.setPaletteLabel(Locale.localizedString((String)"View"));
            item.setToolTip(Locale.localizedString((String)"Switch Browser View"));
            item.setView(this.browserSwitchView);
            NSMenuItem viewMenu = NSMenuItem.itemWithTitle(Locale.localizedString((String)"View"), null, "");
            NSMenu viewSubmenu = NSMenu.menu();
            viewSubmenu.addItemWithTitle_action_keyEquivalent(Locale.localizedString((String)"List"), Foundation.selector("browserSwitchMenuClicked:"), "");
            viewSubmenu.itemWithTitle(Locale.localizedString((String)"List")).setTag(0);
            viewSubmenu.addItemWithTitle_action_keyEquivalent(Locale.localizedString((String)"Outline"), Foundation.selector("browserSwitchMenuClicked:"), "");
            viewSubmenu.itemWithTitle(Locale.localizedString((String)"Outline")).setTag(1);
            viewMenu.setSubmenu(viewSubmenu);
            item.setMenuFormRepresentation(viewMenu);
            item.setMinSize(this.browserSwitchView.frame().size);
            item.setMaxSize(this.browserSwitchView.frame().size);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_NEW_CONNECTION)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_NEW_CONNECTION));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_NEW_CONNECTION));
            item.setToolTip(Locale.localizedString((String)"Connect to server"));
            item.setImage(CDIconCache.iconNamed("connect.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("connectButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_TRANSFERS)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_TRANSFERS));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_TRANSFERS));
            item.setToolTip(Locale.localizedString((String)"Show Transfers window"));
            item.setImage(CDIconCache.iconNamed("queue.tiff"));
            item.setAction(Foundation.selector("showTransferQueueClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_TOOLS)) {
            item.setLabel(Locale.localizedString((String)"Action"));
            item.setPaletteLabel(Locale.localizedString((String)"Action"));
            item.setView(this.actionPopupButton);
            NSMenuItem toolMenu = NSMenuItem.itemWithTitle("", null, "");
            toolMenu.setTitle(Locale.localizedString((String)"Action"));
            NSMenu toolSubmenu = NSMenu.menu();
            for (int i = 1; i < this.actionPopupButton.menu().numberOfItems().intValue(); ++i) {
                NSMenuItem template = this.actionPopupButton.menu().itemAtIndex(i);
                toolSubmenu.addItem(NSMenuItem.itemWithTitle(template.title(), template.action(), template.keyEquivalent()));
            }
            toolMenu.setSubmenu(toolSubmenu);
            item.setMenuFormRepresentation(toolMenu);
            item.setMinSize(this.actionPopupButton.frame().size);
            item.setMaxSize(this.actionPopupButton.frame().size);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_QUICK_CONNECT)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_QUICK_CONNECT));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_QUICK_CONNECT));
            item.setToolTip(Locale.localizedString((String)"Connect to server"));
            item.setView(this.quickConnectPopup);
            item.setMinSize(this.quickConnectPopup.frame().size);
            item.setMaxSize(this.quickConnectPopup.frame().size);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_ENCODING)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_ENCODING));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_ENCODING));
            item.setToolTip(Locale.localizedString((String)"Character Encoding"));
            item.setView(this.encodingPopup);
            NSMenuItem encodingMenu = NSMenuItem.itemWithTitle(Locale.localizedString((String)TOOLBAR_ENCODING), Foundation.selector("encodingMenuClicked:"), "");
            String[] charsets = CDMainController.availableCharsets();
            NSMenu charsetMenu = NSMenu.menu();
            for (String charset : charsets) {
                charsetMenu.addItemWithTitle_action_keyEquivalent(charset, Foundation.selector("encodingMenuClicked:"), "");
            }
            encodingMenu.setSubmenu(charsetMenu);
            item.setMenuFormRepresentation(encodingMenu);
            item.setMinSize(this.encodingPopup.frame().size);
            item.setMaxSize(this.encodingPopup.frame().size);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_REFRESH)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_REFRESH));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_REFRESH));
            item.setToolTip(Locale.localizedString((String)"Refresh directory listing"));
            item.setImage(CDIconCache.iconNamed("reload.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("reloadButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_DOWNLOAD)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_DOWNLOAD));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_DOWNLOAD));
            item.setToolTip(Locale.localizedString((String)"Download file"));
            item.setImage(CDIconCache.iconNamed("download.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("downloadButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_UPLOAD)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_UPLOAD));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_UPLOAD));
            item.setToolTip(Locale.localizedString((String)"Upload local file to the remote host"));
            item.setImage(CDIconCache.iconNamed("upload.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("uploadButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_SYNCHRONIZE)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_SYNCHRONIZE));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_SYNCHRONIZE));
            item.setToolTip(Locale.localizedString((String)"Synchronize files"));
            item.setImage(CDIconCache.iconNamed("sync.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("syncButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_GET_INFO)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_GET_INFO));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_GET_INFO));
            item.setToolTip(Locale.localizedString((String)"Show file attributes"));
            item.setImage(CDIconCache.iconNamed("info.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("infoButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_WEBVIEW)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_WEBVIEW));
            item.setPaletteLabel(Locale.localizedString((String)"Open in Web Browser"));
            item.setToolTip(Locale.localizedString((String)"Open in Web Browser"));
            String browser = URLSchemeHandlerConfiguration.instance().getDefaultHandlerForURLScheme("http");
            if (null == browser) {
                item.setEnabled(false);
                item.setImage(CDIconCache.iconNamed("notfound.tiff"));
            } else {
                String path = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(browser);
                if (null == path) {
                    item.setImage(CDIconCache.iconNamed("notfound.tiff"));
                } else {
                    item.setImage(NSWorkspace.sharedWorkspace().iconForFile(path));
                }
            }
            item.setTarget(this.id());
            item.setAction(Foundation.selector("openBrowserButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_EDIT)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_EDIT));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_EDIT));
            item.setToolTip(Locale.localizedString((String)"Edit file in external editor"));
            item.setImage(CDIconCache.iconNamed("pencil.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("editButtonClicked:"));
            NSMenuItem toolbarMenu = NSMenuItem.itemWithTitle(Locale.localizedString((String)TOOLBAR_EDIT), Foundation.selector("editMenuClicked:"), "");
            NSMenu editMenu = NSMenu.menu();
            editMenu.setAutoenablesItems(true);
            editMenu.setDelegate(this.editMenuDelegate.id());
            toolbarMenu.setSubmenu(editMenu);
            item.setMenuFormRepresentation(toolbarMenu);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_DELETE)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_DELETE));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_DELETE));
            item.setToolTip(Locale.localizedString((String)"Delete file"));
            item.setImage(CDIconCache.iconNamed("delete.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("deleteFileButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_NEW_FOLDER)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_NEW_FOLDER));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_NEW_FOLDER));
            item.setToolTip(Locale.localizedString((String)"Create New Folder"));
            item.setImage(CDIconCache.iconNamed("newfolder.icns"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("createFolderButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_NEW_BOOKMARK)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_NEW_BOOKMARK));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_NEW_BOOKMARK));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_NEW_BOOKMARK));
            item.setImage(CDIconCache.iconNamed("bookmark", 32));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("addBookmarkButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_DISCONNECT)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_DISCONNECT));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_DISCONNECT));
            item.setToolTip(Locale.localizedString((String)"Disconnect from server"));
            item.setImage(CDIconCache.iconNamed("eject.tiff"));
            item.setAutovalidates(true);
            item.setTarget(this.id());
            item.setAction(Foundation.selector("disconnectButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_GO_TO_FOLDER)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_GO_TO_FOLDER));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_GO_TO_FOLDER));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_GO_TO_FOLDER));
            item.setImage(CDIconCache.iconNamed("goto.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("gotoButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_TERMINAL)) {
            String t = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier("com.apple.Terminal");
            item.setLabel(NSFileManager.defaultManager().displayNameAtPath(t));
            item.setPaletteLabel(NSFileManager.defaultManager().displayNameAtPath(t));
            item.setImage(CDIconCache.instance().iconForPath(LocalFactory.createLocal((String)t), (Integer)128));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("openTerminalButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_ARCHIVE)) {
            String t = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier("com.apple.archiveutility");
            item.setLabel(Locale.localizedString((String)TOOLBAR_ARCHIVE, (String)TOOLBAR_ARCHIVE));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_ARCHIVE, (String)TOOLBAR_ARCHIVE));
            item.setImage(CDIconCache.instance().iconForPath(LocalFactory.createLocal((String)t), (Integer)128));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("archiveButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_QUICKLOOK)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_QUICKLOOK));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_QUICKLOOK));
            if (QuickLookFactory.instance().isAvailable()) {
                this.quicklookButton = NSButton.buttonWithFrame(new NSRect(29.0, 23.0));
                this.quicklookButton.setBezelStyle(11);
                this.quicklookButton.setImage(CDIconCache.iconNamed("NSQuickLookTemplate"));
                this.quicklookButton.sizeToFit();
                this.quicklookButton.setTarget(this.id());
                this.quicklookButton.setAction(Foundation.selector("quicklookButtonClicked:"));
                item.setView(this.quicklookButton);
                item.setMinSize(this.quicklookButton.frame().size);
                item.setMaxSize(this.quicklookButton.frame().size);
            } else {
                item.setEnabled(false);
                item.setImage(CDIconCache.iconNamed("notfound.tiff"));
            }
            return item;
        }
        return null;
    }

    @Override
    public NSArray toolbarDefaultItemIdentifiers(NSToolbar toolbar) {
        return NSArray.arrayWithObjects(TOOLBAR_NEW_CONNECTION, "NSToolbarSeparatorItem", TOOLBAR_QUICK_CONNECT, TOOLBAR_TOOLS, "NSToolbarSeparatorItem", TOOLBAR_REFRESH, TOOLBAR_EDIT, "NSToolbarFlexibleSpaceItem", TOOLBAR_DISCONNECT);
    }

    @Override
    public NSArray toolbarAllowedItemIdentifiers(NSToolbar toolbar) {
        return NSArray.arrayWithObjects(TOOLBAR_NEW_CONNECTION, TOOLBAR_BROWSER_VIEW, TOOLBAR_TRANSFERS, TOOLBAR_QUICK_CONNECT, TOOLBAR_TOOLS, TOOLBAR_REFRESH, TOOLBAR_ENCODING, TOOLBAR_SYNCHRONIZE, TOOLBAR_DOWNLOAD, TOOLBAR_UPLOAD, TOOLBAR_EDIT, TOOLBAR_DELETE, TOOLBAR_NEW_FOLDER, TOOLBAR_NEW_BOOKMARK, TOOLBAR_GET_INFO, TOOLBAR_WEBVIEW, TOOLBAR_TERMINAL, TOOLBAR_ARCHIVE, TOOLBAR_QUICKLOOK, TOOLBAR_DISCONNECT, "NSToolbarCustomizeToolbarItem", "NSToolbarSpaceItem", "NSToolbarSeparatorItem", "NSToolbarFlexibleSpaceItem");
    }

    @Override
    public NSArray toolbarSelectableItemIdentifiers(NSToolbar toolbar) {
        return NSArray.array();
    }

    @Override
    protected void invalidate() {
        if (this.hasSession()) {
            this.session.removeConnectionListener(this.listener);
        }
        this.bookmarkTable.setDelegate(null);
        this.bookmarkTable.setDataSource(null);
        this.bookmarkModel.invalidate();
        this.browserListView.setDelegate(null);
        this.browserListView.setDataSource(null);
        this.browserListModel.invalidate();
        this.browserOutlineView.setDelegate(null);
        this.browserOutlineView.setDataSource(null);
        this.browserOutlineModel.invalidate();
        this.toolbar.setDelegate(null);
        this.toolbarItems.clear();
        this.browserListColumnsFactory.clear();
        this.browserOutlineColumnsFactory.clear();
        this.bookmarkTableColumnFactory.clear();
        super.invalidate();
    }

    private static class QuickConnectModel
    extends CDController
    implements NSComboBox.DataSource {
        private QuickConnectModel() {
        }

        public NSInteger numberOfItemsInComboBox(NSComboBox combo) {
            return new NSInteger(HostCollection.defaultCollection().size());
        }

        public NSObject comboBox_objectValueForItemAtIndex(NSComboBox sender, NSInteger row) {
            return NSString.stringWithString(HostCollection.defaultCollection().get(row.intValue()).getNickname());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        private TableColumnFactory() {
        }

        private NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractBrowserTableDelegate<E>
    extends CDAbstractPathTableDelegate {
        public AbstractBrowserTableDelegate() {
            CDBrowserController.this.addListener(new CDWindowListener(){

                public void windowWillClose() {
                    if (QuickLookFactory.instance().isAvailable() && QuickLookFactory.instance().isOpen()) {
                        QuickLookFactory.instance().close();
                    }
                }
            });
        }

        @Override
        public boolean isColumnEditable(NSTableColumn column) {
            if (Preferences.instance().getBoolean("browser.editable") && column.identifier().equals("FILENAME")) {
                Path selected = CDBrowserController.this.getSelectedPath();
                return null != selected;
            }
            return false;
        }

        @Override
        public void tableRowDoubleClicked(ID sender) {
            CDBrowserController.this.insideButtonClicked(sender);
        }

        public void spaceKeyPressed(ID sender) {
            if (QuickLookFactory.instance().isAvailable()) {
                if (QuickLookFactory.instance().isOpen()) {
                    QuickLookFactory.instance().close();
                } else {
                    this.updateQuickLookSelection(CDBrowserController.this.getSelectedPaths());
                }
            }
        }

        private void updateQuickLookSelection(ch.cyberduck.core.Collection<Path> selected) {
            if (QuickLookFactory.instance().isAvailable()) {
                final ch.cyberduck.core.Collection downloads = new ch.cyberduck.core.Collection();
                for (Path path : selected) {
                    if (!path.attributes.isFile()) continue;
                    Local folder = LocalFactory.createLocal((File)new File(Preferences.instance().getProperty("tmp.dir"), path.getParent().getAbsolute()));
                    folder.mkdir(true);
                    path.setLocal(LocalFactory.createLocal((Local)folder, (String)path.getName()));
                    downloads.add((Object)path);
                }
                if (downloads.size() > 0) {
                    this.background((BackgroundAction)new BrowserBackgroundAction(CDBrowserController.this){
                        final ch.cyberduck.core.Collection<Local> previews;
                        {
                            super(x0);
                            this.previews = new ch.cyberduck.core.Collection<Local>(){

                                public void collectionItemRemoved(Local o) {
                                    super.collectionItemRemoved((Object)o);
                                    o.delete(false);
                                }
                            };
                        }

                        public void run() {
                            for (Path download : downloads) {
                                if (this.isCanceled()) break;
                                if (!download.getLocal().exists()) {
                                    download.download(true);
                                    if (download.getStatus().isComplete()) {
                                        this.previews.add((Object)download.getLocal());
                                        continue;
                                    }
                                    download.getLocal().delete(false);
                                    continue;
                                }
                                this.previews.add((Object)download.getLocal());
                            }
                        }

                        public void cleanup() {
                            if (this.previews.isEmpty()) {
                                return;
                            }
                            QuickLookFactory.instance().select(this.previews);
                            QuickLookFactory.instance().open();
                            CDBrowserController.this.updateStatusLabel();
                            CDBrowserController.this.window().makeKeyWindow();
                        }

                        public String getActivity() {
                            return Locale.localizedString((String)CDBrowserController.TOOLBAR_QUICKLOOK, (String)"Status");
                        }
                    });
                }
            }
        }

        @Override
        public void deleteKeyPressed(ID sender) {
            CDBrowserController.this.deleteFileButtonClicked(sender);
        }

        @Override
        public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            ch.cyberduck.core.Collection<Path> selected = CDBrowserController.this.getSelectedPaths();
            if (this.selectedColumnIdentifier().equals(tableColumn.identifier())) {
                this.setSortedAscending(!this.isSortedAscending());
            } else {
                this.setBrowserColumnSortingIndicator(null, this.selectedColumnIdentifier());
                this.setSelectedColumn(tableColumn);
            }
            this.setBrowserColumnSortingIndicator(this.isSortedAscending() ? CDIconCache.iconNamed("NSAscendingSortIndicator") : CDIconCache.iconNamed("NSDescendingSortIndicator"), tableColumn.identifier());
            CDBrowserController.this.reloadData((List<Path>)selected);
        }

        @Override
        public void selectionDidChange(NSNotification notification) {
            final ch.cyberduck.core.Collection<Path> selected = CDBrowserController.this.getSelectedPaths();
            if (1 == selected.size()) {
                Path p = (Path)selected.get(0);
                if (p.attributes.isFile()) {
                    EditorFactory.setSelectedEditor(EditorFactory.editorBundleIdentifierForFile(p.getLocal()));
                }
            }
            if (Preferences.instance().getBoolean("browser.info.isInspector") && CDBrowserController.this.inspector != null && CDBrowserController.this.inspector.isVisible() && selected.size() > 0) {
                this.background((BackgroundAction)new BrowserBackgroundAction(CDBrowserController.this){

                    public void run() {
                        for (Path p : selected) {
                            if (this.isCanceled()) break;
                            if (p.attributes.getPermission() != null) continue;
                            p.readPermission();
                        }
                    }

                    public void cleanup() {
                        if (CDBrowserController.this.inspector != null) {
                            CDBrowserController.this.inspector.setFiles((List<Path>)selected);
                        }
                    }
                });
            }
            if (QuickLookFactory.instance().isOpen()) {
                this.updateQuickLookSelection(selected);
            }
        }

        private void setBrowserColumnSortingIndicator(NSImage image, String columnIdentifier) {
            if (CDBrowserController.this.browserListView.tableColumnWithIdentifier(columnIdentifier) != null) {
                CDBrowserController.this.browserListView.setIndicatorImage_inTableColumn(image, CDBrowserController.this.browserListView.tableColumnWithIdentifier(columnIdentifier));
            }
            if (CDBrowserController.this.browserOutlineView.tableColumnWithIdentifier(columnIdentifier) != null) {
                CDBrowserController.this.browserOutlineView.setIndicatorImage_inTableColumn(image, CDBrowserController.this.browserOutlineView.tableColumnWithIdentifier(columnIdentifier));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractBrowserListViewDelegate<E>
    extends AbstractBrowserTableDelegate<E>
    implements NSTableView.Delegate {
        private AbstractBrowserListViewDelegate() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractBrowserOutlineViewDelegate<E>
    extends AbstractBrowserTableDelegate<E>
    implements NSOutlineView.Delegate {
        private AbstractBrowserOutlineViewDelegate() {
        }
    }
}

