/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDFileController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.odb.Editor;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class CDCreateFileController
extends CDFileController {
    public CDCreateFileController(CDWindowController parent) {
        super(parent);
    }

    protected String getBundleName() {
        return "File";
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.createFile(this.getWorkdir(), this.filenameField.stringValue(), false);
        }
        if (returncode == -1) {
            this.createFile(this.getWorkdir(), this.filenameField.stringValue(), true);
        }
    }

    protected void createFile(final Path workdir, final String filename, final boolean edit) {
        final CDBrowserController c = (CDBrowserController)this.parent;
        c.background((BackgroundAction)new BrowserBackgroundAction(c){
            final Path file;
            {
                super(x0);
                this.file = PathFactory.createPath((Session)workdir.getSession(), (String)workdir.getAbsolute(), (Local)LocalFactory.createLocal((String)Preferences.instance().getProperty("tmp.dir"), (String)filename));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int no = 0;
                while (this.file.getLocal().exists()) {
                    String proposal = FilenameUtils.getBaseName((String)filename) + "-" + ++no;
                    if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)filename))) {
                        proposal = proposal + "." + FilenameUtils.getExtension((String)filename);
                    }
                    this.file.setLocal(LocalFactory.createLocal((String)Preferences.instance().getProperty("tmp.dir"), (String)proposal));
                }
                this.file.getLocal().touch();
                TransferOptions options = new TransferOptions();
                options.closeSession = false;
                try {
                    UploadTransfer upload = new UploadTransfer(this.file);
                    upload.start(new TransferPrompt(){

                        public TransferAction prompt() {
                            return TransferAction.ACTION_OVERWRITE;
                        }
                    }, options);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.file.getLocal().delete(false);
                    throw throwable;
                }
                this.file.getLocal().delete(false);
                if (this.file.exists() && edit) {
                    Editor editor = EditorFactory.createEditor(c, this.file);
                    editor.open();
                }
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Uploading {0}", (String)"Status"), this.file.getName());
            }

            public void cleanup() {
                if (filename.charAt(0) == '.') {
                    c.setShowHiddenFiles(true);
                }
                c.reloadData(Collections.singletonList(this.file));
            }
        });
    }
}

