/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Session;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDSheetController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSComboBox;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;

public class CDGotoController
extends CDSheetController {
    private static Logger log = Logger.getLogger(CDGotoController.class);
    protected NSImageView iconView;
    private NSComboBox folderCombobox;
    private CDController folderComboboxModel = new FolderComboboxModel();

    public void setIconView(NSImageView iconView) {
        this.iconView = iconView;
        this.iconView.setImage(CDIconCache.folderIcon(64));
    }

    public void setFolderCombobox(NSComboBox folderCombobox) {
        this.folderCombobox = folderCombobox;
        this.folderCombobox.setCompletes(true);
        this.folderCombobox.setUsesDataSource(true);
        this.folderCombobox.setDataSource(this.folderComboboxModel.id());
        this.folderCombobox.setStringValue(((CDBrowserController)this.parent).workdir().getAbsolute());
    }

    public CDGotoController(CDWindowController parent) {
        super(parent);
    }

    public String getBundleName() {
        return "Goto";
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.gotoFolder(((CDBrowserController)this.parent).workdir(), this.folderCombobox.stringValue());
        }
    }

    protected boolean validateInput() {
        return StringUtils.isNotBlank((String)this.folderCombobox.stringValue());
    }

    protected void gotoFolder(Path workdir, String filename) {
        CDBrowserController c = (CDBrowserController)this.parent;
        Path dir = PathFactory.createPath((Session)workdir.getSession(), (Object)workdir.getAsDictionary());
        if (filename.charAt(0) != '/') {
            dir.setPath(workdir.getAbsolute(), filename);
        } else {
            dir.setPath(filename);
        }
        if (workdir.getParent().equals((Object)dir)) {
            c.setWorkdir(dir, workdir);
        } else {
            c.setWorkdir(dir);
        }
    }

    private class FolderComboboxModel
    extends CDController
    implements NSComboBox.DataSource {
        private final Comparator<Path> comparator = new NullComparator();
        private final PathFilter<Path> filter = new PathFilter<Path>(){

            public boolean accept(Path p) {
                return p.attributes.isDirectory();
            }
        };

        private FolderComboboxModel() {
        }

        public NSInteger numberOfItemsInComboBox(NSComboBox combo) {
            if (!((CDBrowserController)CDGotoController.this.parent).isMounted()) {
                return new NSInteger(0L);
            }
            return new NSInteger(((CDBrowserController)CDGotoController.this.parent).workdir().childs(this.comparator, this.filter).size());
        }

        public NSObject comboBox_objectValueForItemAtIndex(NSComboBox sender, NSInteger row) {
            return (NSObject)((Path)((CDBrowserController)CDGotoController.this.parent).workdir().childs(this.comparator, this.filter).get(row.intValue())).getReference().unique();
        }
    }
}

