/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractLoginController;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.CDSheetController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSSecureTextField;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;

public class CDLoginController
extends AbstractLoginController
implements LoginController {
    private static Logger log = Logger.getLogger(CDLoginController.class);
    private CDWindowController parent;

    public CDLoginController(CDWindowController parent) {
        this.parent = parent;
    }

    public void prompt(final Host host, final String reason, final String message) throws LoginCanceledException {
        final Credentials credentials = host.getCredentials();
        CDSheetController c = new CDSheetController(this.parent){
            private NSTextField titleField;
            private NSTextField userField;
            private NSTextField textField;
            private NSSecureTextField passField;
            private NSButton keychainCheckbox;
            private NSButton anonymousCheckbox;
            private NSTextField pkLabel;
            private NSButton pkCheckbox;
            private NSOpenPanel publicKeyPanel;

            protected String getBundleName() {
                return "Login";
            }

            public void awakeFromNib() {
                this.update();
                super.awakeFromNib();
            }

            public void setTitleField(NSTextField titleField) {
                this.titleField = titleField;
                this.updateField(this.titleField, Locale.localizedString((String)reason, (String)"Credentials"));
            }

            public void setUserField(NSTextField userField) {
                this.userField = userField;
                this.updateField(this.userField, credentials.getUsername());
                if (host.getProtocol().equals((Object)Protocol.S3)) {
                    this.userField.cell().setPlaceholderString(Locale.localizedString((String)"Access Key ID", (String)"S3"));
                }
                NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("userFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.userField);
            }

            public void userFieldTextDidChange(NSNotification notification) {
                credentials.setUsername(this.userField.stringValue());
                this.update();
            }

            public void setTextField(NSTextField textField) {
                this.textField = textField;
                this.updateField(this.textField, Locale.localizedString((String)message, (String)"Credentials"));
            }

            public void setPassField(NSSecureTextField passField) {
                this.passField = passField;
                this.updateField(this.passField, credentials.getPassword());
                if (host.getProtocol().equals((Object)Protocol.S3)) {
                    this.passField.cell().setPlaceholderString(Locale.localizedString((String)"Secret Access Key", (String)"S3"));
                }
                NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("passFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.passField);
            }

            public void passFieldTextDidChange(NSNotification notification) {
                credentials.setPassword(this.passField.stringValue());
            }

            public void setKeychainCheckbox(NSButton keychainCheckbox) {
                this.keychainCheckbox = keychainCheckbox;
                this.keychainCheckbox.setState(Preferences.instance().getBoolean("connection.login.useKeychain") && Preferences.instance().getBoolean("connection.login.addKeychain") ? 1 : 0);
                this.keychainCheckbox.setTarget(this.id());
                this.keychainCheckbox.setAction(Foundation.selector("keychainCheckboxClicked:"));
            }

            public void keychainCheckboxClicked(NSButton sender) {
                credentials.setUseKeychain(sender.state() == 1);
            }

            public void setAnonymousCheckbox(NSButton anonymousCheckbox) {
                this.anonymousCheckbox = anonymousCheckbox;
                this.anonymousCheckbox.setTarget(this.id());
                this.anonymousCheckbox.setAction(Foundation.selector("anonymousCheckboxClicked:"));
            }

            public void anonymousCheckboxClicked(NSButton sender) {
                if (sender.state() == 1) {
                    credentials.setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
                    credentials.setPassword(Preferences.instance().getProperty("connection.login.anon.pass"));
                }
                if (sender.state() == 0) {
                    credentials.setUsername(Preferences.instance().getProperty("connection.login.name"));
                    credentials.setPassword(null);
                }
                this.updateField(this.userField, credentials.getUsername());
                this.updateField(this.passField, credentials.getPassword());
                this.update();
            }

            public void setPkLabel(NSTextField pkLabel) {
                this.pkLabel = pkLabel;
            }

            public void setPkCheckbox(NSButton pkCheckbox) {
                this.pkCheckbox = pkCheckbox;
                this.pkCheckbox.setTarget(this.id());
                this.pkCheckbox.setAction(Foundation.selector("pkCheckboxSelectionChanged:"));
            }

            public void pkCheckboxSelectionChanged(NSButton sender) {
                log.debug((Object)"pkCheckboxSelectionChanged");
                if (this.pkLabel.stringValue().equals(Locale.localizedString((String)"No Private Key selected"))) {
                    this.publicKeyPanel = NSOpenPanel.openPanel();
                    this.publicKeyPanel.setCanChooseDirectories(false);
                    this.publicKeyPanel.setCanChooseFiles(true);
                    this.publicKeyPanel.setAllowsMultipleSelection(false);
                    this.publicKeyPanel.beginSheetForDirectory(LocalFactory.createLocal((String)"~/.ssh").getAbsolute(), null, this.window(), this.id(), Foundation.selector("pkSelectionPanelDidEnd:returnCode:contextInfo:"), null);
                } else {
                    credentials.setIdentity(null);
                    this.update();
                }
            }

            public void pkSelectionPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
                log.debug((Object)"pkSelectionPanelDidEnd");
                if (returncode == 1) {
                    NSObject next;
                    NSArray selected = sheet.filenames();
                    NSEnumerator enumerator = selected.objectEnumerator();
                    while ((next = enumerator.nextObject()) != null) {
                        credentials.setIdentity(LocalFactory.createLocal((String)next.toString()));
                    }
                }
                if (returncode == 0) {
                    credentials.setIdentity(null);
                }
                this.publicKeyPanel = null;
                this.update();
            }

            private void update() {
                this.userField.setEnabled(!credentials.isAnonymousLogin());
                this.passField.setEnabled(!credentials.isAnonymousLogin());
                this.keychainCheckbox.setEnabled(!credentials.isAnonymousLogin());
                this.anonymousCheckbox.setState(credentials.isAnonymousLogin() ? 1 : 0);
                this.pkCheckbox.setEnabled(host.getProtocol().equals((Object)Protocol.SFTP));
                if (credentials.isPublicKeyAuthentication()) {
                    this.pkCheckbox.setState(1);
                    this.updateField(this.pkLabel, credentials.getIdentity().toURL());
                } else {
                    this.pkCheckbox.setState(0);
                    this.pkLabel.setStringValue(Locale.localizedString((String)"No Private Key selected"));
                }
            }

            protected boolean validateInput() {
                return StringUtils.isNotEmpty((String)credentials.getUsername());
            }

            public void callback(int returncode) {
                if (returncode == 1) {
                    this.window().endEditingFor(null);
                    credentials.setUsername(this.userField.stringValue());
                    credentials.setPassword(this.passField.stringValue());
                }
            }
        };
        c.beginSheet();
        if (c.returnCode() == 0) {
            throw new LoginCanceledException();
        }
    }
}

