/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.CDMainController;
import ch.cyberduck.ui.cocoa.CDPreferencesImpl;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import ch.cyberduck.ui.cocoa.foundation.NSGarbageCollector;
import ch.cyberduck.ui.cocoa.i18n.BundleLocale;
import ch.cyberduck.ui.cocoa.model.CDLocal;
import ch.cyberduck.ui.cocoa.serializer.HostPlistReader;
import ch.cyberduck.ui.cocoa.serializer.PlistDeserializer;
import ch.cyberduck.ui.cocoa.serializer.PlistSerializer;
import ch.cyberduck.ui.cocoa.serializer.PlistWriter;
import ch.cyberduck.ui.cocoa.serializer.TransferPlistReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CDMainApplication {
    private static Logger log = Logger.getLogger(CDMainApplication.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) {
        NSAutoreleasePool pool = NSAutoreleasePool.push();
        try {
            CDMainApplication.registerFactories();
            Logger root = Logger.getRootLogger();
            root.setLevel(Level.toLevel((String)Preferences.instance().getProperty("logging")));
            log.info((Object)("Default garbage collector for the current process:" + NSGarbageCollector.defaultCollector()));
            log.info((Object)("Encoding " + System.getProperty("file.encoding")));
            NSApplication app = NSApplication.sharedApplication();
            CDMainController c = new CDMainController();
            app.setDelegate(c.id());
            app.run();
        }
        finally {
            pool.drain();
        }
    }

    private static void registerFactories() {
        CDLocal.register();
        CDPreferencesImpl.register();
        BundleLocale.register();
        PlistDeserializer.register();
        PlistSerializer.register();
        HostPlistReader.register();
        TransferPlistReader.register();
        PlistWriter.register();
    }
}

