/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.PreferencesFactory;
import ch.cyberduck.ui.cocoa.CDPortablePreferencesImpl;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSUserDefaults;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class CDPreferencesImpl
extends Preferences {
    private static Logger log = Logger.getLogger(Preferences.class);
    private NSUserDefaults props;

    public static void register() {
        PreferencesFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (PreferencesFactory)new Factory());
    }

    public Object getObject(String property) {
        NSObject value = this.props.objectForKey(property);
        if (null == value) {
            return super.getObject(property);
        }
        return value;
    }

    public void setProperty(String property, String value) {
        log.info((Object)("setProperty:" + property + "," + value));
        this.props.setObjectForKey(NSString.stringWithString(value), property);
        this.save();
    }

    public void deleteProperty(String property) {
        log.debug((Object)("deleteProperty:" + property));
        this.props.removeObjectForKey(property);
        this.save();
    }

    protected void load() {
        this.props = NSUserDefaults.standardUserDefaults();
    }

    protected void legacy() {
        this._init("browser.view.autoexpand.useDelay");
        this._init("browser.view.autoexpand.delay");
        this._init("queue.maxtransfers");
        this._init("connection.retry");
        this._init("connection.retry.delay");
        this._init("connection.timeout.seconds");
        this._init("bookmark.icon.size");
        if (this.getBoolean("update.check")) {
            this.props.setInteger_forKey(new NSInteger(Long.parseLong(super.getProperty("update.check.interval"))), "SUScheduledCheckInterval");
        }
    }

    protected void setDefaults() {
        super.setDefaults();
        Local APP_SUPPORT_DIR = null == NSBundle.mainBundle().objectForInfoDictionaryKey("application.support.path") ? LocalFactory.createLocal((String)"~/Library/Application Support/Cyberduck") : LocalFactory.createLocal((String)NSBundle.mainBundle().objectForInfoDictionaryKey("application.support.path").toString());
        APP_SUPPORT_DIR.mkdir(true);
        this.defaults.put("application.support.path", APP_SUPPORT_DIR.getAbbreviatedPath());
        this.defaults.put("application", NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleName").toString());
        this.defaults.put("version", NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleShortVersionString").toString());
    }

    private void _init(String property) {
        if (null == this.props.objectForKey(property)) {
            this.setProperty(property, super.getProperty(property));
        }
    }

    public void save() {
        this.props.synchronize();
    }

    protected String locale() {
        String locale = "en";
        NSArray preferredLocalizations = NSBundle.mainBundle().preferredLocalizations();
        if (null == preferredLocalizations) {
            log.warn((Object)"No localizations found in main bundle");
            return locale;
        }
        if (preferredLocalizations.count().intValue() > 0) {
            locale = preferredLocalizations.objectAtIndex(new NSUInteger(0L)).toString();
        }
        return locale;
    }

    private static class Factory
    extends PreferencesFactory {
        private Factory() {
        }

        protected Preferences create() {
            if (null == NSBundle.mainBundle().objectForInfoDictionaryKey("application.preferences.path")) {
                return new CDPreferencesImpl();
            }
            return new CDPortablePreferencesImpl();
        }
    }
}

