/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDTableCellAttributes;
import ch.cyberduck.ui.cocoa.CDTransferPromptModel;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDSyncPromptModel
extends CDTransferPromptModel {
    private PathFilter<Path> filter;
    protected static final String SYNC_COLUMN = "SYNC";
    protected static final String CREATE_COLUMN = "CREATE";

    public CDSyncPromptModel(CDWindowController c, Transfer transfer) {
        super(c, transfer);
    }

    @Override
    protected PathFilter<Path> filter() {
        if (null == this.filter) {
            this.filter = new CDTransferPromptModel.PromptFilter(){

                public boolean accept(Path child) {
                    CDTransferPromptModel.log.debug((Object)("accept:" + child));
                    return super.accept(child);
                }
            };
        }
        return this.filter;
    }

    @Override
    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached = this.modelCache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals("SIZE")) {
                SyncTransfer.Comparison compare = ((SyncTransfer)this.transfer).compare(item);
                return this.modelCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)(compare.equals((Object)SyncTransfer.COMPARISON_REMOTE_NEWER) ? (double)item.attributes.getSize() : (double)item.getLocal().attributes.getSize())), CDTableCellAttributes.browserFontRightAlignment()));
            }
            if (identifier.equals(SYNC_COLUMN)) {
                SyncTransfer.Comparison compare = ((SyncTransfer)this.transfer).compare(item);
                if (compare.equals((Object)SyncTransfer.COMPARISON_REMOTE_NEWER)) {
                    return this.modelCache.put(item, identifier, CDIconCache.iconNamed("arrowDown", 16));
                }
                if (compare.equals((Object)SyncTransfer.COMPARISON_LOCAL_NEWER)) {
                    return this.modelCache.put(item, identifier, CDIconCache.iconNamed("arrowUp", 16));
                }
                return null;
            }
            if (identifier.equals("WARNING")) {
                if (item.attributes.isFile()) {
                    if (item.exists() && item.attributes.getSize() == 0L) {
                        return this.modelCache.put(item, identifier, this.ALERT_ICON);
                    }
                    if (item.getLocal().exists() && item.getLocal().attributes.getSize() == 0L) {
                        return this.modelCache.put(item, identifier, this.ALERT_ICON);
                    }
                }
                return null;
            }
            if (identifier.equals(CREATE_COLUMN)) {
                if (!item.exists() || !item.getLocal().exists()) {
                    return this.modelCache.put(item, identifier, CDIconCache.iconNamed("plus", 16));
                }
                return null;
            }
        }
        return super.objectValueForItem(item, identifier);
    }
}

