/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDAlertController;
import ch.cyberduck.ui.cocoa.CDBundleController;
import ch.cyberduck.ui.cocoa.CDSheetCallback;
import ch.cyberduck.ui.cocoa.CDSheetController;
import ch.cyberduck.ui.cocoa.CDWindowListener;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class CDWindowController
extends CDBundleController
implements NSWindow.Delegate {
    private static Logger log = Logger.getLogger(CDWindowController.class);
    protected static final String DEFAULT = "Default";
    protected NSWindow window;
    private Set<CDWindowListener> listeners = Collections.synchronizedSet(new HashSet());
    private CDSheetController sheet;

    protected void invalidate() {
        this.listeners.clear();
        if (this.window != null) {
            this.window.setDelegate(null);
        }
        super.invalidate();
    }

    public void addListener(CDWindowListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CDWindowListener listener) {
        this.listeners.remove(listener);
    }

    public void setWindow(NSWindow window) {
        this.window = window;
        this.window.setReleasedWhenClosed(!this.isSingleton());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("windowWillClose:"), "NSWindowWillCloseNotification", this.window);
    }

    public NSWindow window() {
        return this.window;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isVisible() {
        return this.window().isVisible();
    }

    public void windowDidBecomeKey(NSNotification notification) {
    }

    public void windowDidResignKey(NSNotification notification) {
    }

    public boolean windowShouldClose(NSWindow sender) {
        return true;
    }

    public void windowWillClose(NSNotification notification) {
        log.debug((Object)("windowWillClose:" + notification));
        for (CDWindowListener listener : this.listeners) {
            listener.windowWillClose();
        }
        if (!this.isSingleton()) {
            this.invalidate();
        }
    }

    protected void cascade() {
        NSArray windows = NSApplication.sharedApplication().windows();
        int count = windows.count().intValue();
        if (count != 0) {
            NSWindow window = Rococoa.cast(windows.objectAtIndex(new NSUInteger(count - 1)), NSWindow.class);
            NSPoint origin = window.frame().origin;
            origin = new NSPoint(origin.x.doubleValue(), origin.y.doubleValue() + window.frame().size.height.doubleValue());
            this.window.setFrameTopLeftPoint(this.window.cascadeTopLeftFromPoint(origin));
        }
    }

    protected void setState(NSButton toggle, boolean open) {
        if (open) {
            toggle.performClick(null);
        }
        toggle.setState(open ? 1 : 0);
    }

    public void invoke(final MainAction runnable, boolean wait) {
        super.invoke((MainAction)new WindowMainAction(this){

            public void run() {
                runnable.run();
            }
        }, wait);
    }

    public boolean hasSheet() {
        if (null == this.window) {
            return false;
        }
        return this.window.attachedSheet() != null;
    }

    protected void alert(NSAlert alert) {
        this.alert(alert, new CDSheetCallback(){

            public void callback(int returncode) {
            }
        });
    }

    protected void alert(NSAlert alert, final CDSheetCallback callback) {
        this.sheet = new CDAlertController(this, alert){

            public void callback(int returncode) {
                callback.callback(returncode);
                CDWindowController.this.sheet = null;
            }
        };
        this.sheet.beginSheet();
    }

    protected void alert(NSWindow sheet) {
        this.alert(sheet, new CDSheetCallback(){

            public void callback(int returncode) {
            }
        });
    }

    protected void alert(NSWindow sheet, final CDSheetCallback callback) {
        this.sheet = new CDSheetController(this, sheet){

            public void callback(int returncode) {
                callback.callback(returncode);
                CDWindowController.this.sheet = null;
            }
        };
        this.sheet.beginSheet();
    }

    protected void updateField(NSTextView f, String value) {
        f.setString(StringUtils.isNotBlank((String)value) ? value : "");
    }

    protected void updateField(NSTextField f, String value) {
        f.setStringValue(StringUtils.isNotBlank((String)value) ? value : "");
    }

    public void helpButtonClicked(NSButton sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.help")));
    }
}

