/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferMenuDelegate
extends MenuDelegate {
    private static Logger log = Logger.getLogger(TransferMenuDelegate.class);
    private List<Path> roots;

    public TransferMenuDelegate(List<Path> roots) {
        this.roots = roots;
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        return new NSInteger(this.roots.size());
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean shouldCancel) {
        Path path = this.roots.get(index.intValue());
        item.setTitle(path.getName());
        if (path.getLocal().exists()) {
            item.setEnabled(true);
            item.setTarget(this.id());
            item.setAction(Foundation.selector("reveal:"));
        } else {
            item.setEnabled(false);
            item.setTarget(null);
        }
        item.setState(path.getLocal().exists() ? 1 : 0);
        item.setRepresentedObject(path.getLocal().getAbsolute());
        item.setImage(CDIconCache.instance().iconForPath(path, (Integer)16));
        return !shouldCancel;
    }

    public void reveal(NSMenuItem sender) {
        Local l = LocalFactory.createLocal((String)sender.representedObject());
        if (!NSWorkspace.sharedWorkspace().selectFile(l.getAbsolute(), l.getParent().getAbsolute())) {
            log.error((Object)("reveal:" + l.getAbsolute()));
        }
    }
}

