/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.odb;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.io.AbstractFileWatcherListener;
import ch.cyberduck.core.io.FileWatcherListener;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.odb.Editor;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;

public class WatchEditor
extends Editor {
    private static Logger log = Logger.getLogger(WatchEditor.class);

    public WatchEditor(CDBrowserController c, Path path) {
        this(c, null, path);
    }

    public WatchEditor(CDBrowserController c, String bundleIdentifier, Path path) {
        super(c, bundleIdentifier, path);
    }

    public void edit() {
        try {
            this.edited.getLocal().watch((FileWatcherListener)new AbstractFileWatcherListener(){

                public void fileWritten(Local file) {
                    log.debug((Object)("fileWritten:" + file));
                    WatchEditor.this.save();
                    if (!WatchEditor.this.isOpen()) {
                        WatchEditor.this.delete();
                    }
                }
            });
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            return;
        }
        if (null == this.bundleIdentifier) {
            NSWorkspace.sharedWorkspace().openFile(this.edited.getLocal().getAbsolute());
        } else {
            NSWorkspace.sharedWorkspace().openFile(this.edited.getLocal().getAbsolute(), NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(this.bundleIdentifier));
        }
    }

    public boolean isOpen() {
        if (null == this.bundleIdentifier) {
            NSObject next;
            String fullpath = this.edited.getLocal().getDefaultEditor();
            NSEnumerator apps = NSWorkspace.sharedWorkspace().launchedApplications().objectEnumerator();
            while ((next = apps.nextObject()) != null) {
                NSDictionary app = Rococoa.cast(next, NSDictionary.class);
                if (!fullpath.equals(app.objectForKey("NSApplicationPath").toString())) continue;
                return true;
            }
            return false;
        }
        return super.isOpen();
    }
}

