/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import com.sun.jna.Pointer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.IDByReference;
import org.rococoa.NSObject;
import org.rococoa.NSObjectByReference;
import org.rococoa.ReleaseInFinalize;
import org.rococoa.ReturnType;
import org.rococoa.Rococoa;
import org.rococoa.RococoaException;
import org.rococoa.RunOnMainThread;
import org.rococoa.internal.AutoreleaseBatcher;
import org.rococoa.internal.VarArgsUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSObjectInvocationHandler
implements InvocationHandler,
MethodInterceptor {
    private static final int FINALIZE_AUTORELEASE_BATCH_SIZE = 1000;
    private static Logger logging = LoggerFactory.getLogger((String)"org.rococoa.proxy");
    static final Method OBJECT_TOSTRING;
    static final Method OBJECT_HASHCODE;
    static final Method OBJECT_EQUALS;
    static final Method OCOBJECT_ID;
    private final ID ocInstance;
    private final String javaClassName;
    private final boolean invokeOnMainThread;
    private boolean releaseOnFinalize;
    private volatile boolean finalized;

    public NSObjectInvocationHandler(final ID ocInstance, Class<? extends NSObject> javaClass, boolean retain) {
        this.ocInstance = ocInstance;
        this.javaClassName = javaClass.getSimpleName();
        this.invokeOnMainThread = this.shouldInvokeMethodsOnMainThread(javaClass);
        this.releaseOnFinalize = this.shouldReleaseInFinalize(javaClass);
        if (logging.isTraceEnabled()) {
            int retainCount = Foundation.cfGetRetainCount(ocInstance);
            logging.trace("Creating NSObjectInvocationHandler for id {}, javaclass {}. retain = {}, retainCount = {}", new Object[]{ocInstance, javaClass, retain, retainCount});
        }
        if (ocInstance.isNull()) {
            throw new NullPointerException();
        }
        if (retain) {
            if (this.callAcrossToMainThread()) {
                Foundation.runOnMainThread(new Runnable(){

                    public void run() {
                        Foundation.cfRetain(ocInstance);
                    }
                });
            } else {
                Foundation.cfRetain(ocInstance);
            }
        }
    }

    private boolean shouldInvokeMethodsOnMainThread(AnnotatedElement element) {
        return element != null && element.getAnnotation(RunOnMainThread.class) != null;
    }

    private boolean shouldReleaseInFinalize(Class<? extends NSObject> javaClass) {
        ReleaseInFinalize annotation = javaClass.getAnnotation(ReleaseInFinalize.class);
        if (annotation == null) {
            return true;
        }
        return annotation.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.finalized || !this.releaseOnFinalize) {
            return;
        }
        try {
            if (this.callAcrossToMainThread()) {
                Foundation.runOnMainThread(new Runnable(){

                    public void run() {
                        NSObjectInvocationHandler.this.release();
                    }
                });
            } else {
                AutoreleaseBatcher autoreleaseBatcher = AutoreleaseBatcher.forThread(1000);
                this.release();
                autoreleaseBatcher.operate();
            }
            super.finalize();
            Object var3_2 = null;
            this.finalized = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.finalized = true;
            throw throwable;
        }
    }

    private void release() {
        if (this.ocInstance.isNull()) {
            return;
        }
        if (logging.isTraceEnabled()) {
            int retainCount = Foundation.cfGetRetainCount(this.ocInstance);
            logging.trace("finalizing [{} {}], releasing with retain count = {}", new Object[]{this.javaClassName, this.ocInstance, retainCount});
        }
        Foundation.cfRelease(this.ocInstance);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (logging.isTraceEnabled()) {
            logging.trace("invoking [{} {}].{}({})", new Object[]{this.javaClassName, this.ocInstance, method.getName(), new VarArgsUnpacker(args)});
        }
        if (this.isSpecialMethod(method)) {
            return this.invokeSpecialMethod(method, args);
        }
        return this.invokeCocoa(method, args);
    }

    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (logging.isTraceEnabled()) {
            logging.trace("invoking [{} {}].{}({})", new Object[]{this.javaClassName, this.ocInstance, method.getName(), new VarArgsUnpacker(args)});
        }
        if (this.isSpecialMethod(method)) {
            return this.invokeSpecialMethod(method, args);
        }
        if (!Modifier.isAbstract(method.getModifiers())) {
            return methodProxy.invokeSuper(proxy, args);
        }
        return this.invokeCocoa(method, args);
    }

    private boolean isSpecialMethod(Method method) {
        return OBJECT_TOSTRING.equals(method) || OBJECT_EQUALS.equals(method) || OCOBJECT_ID.equals(method);
    }

    private Object invokeSpecialMethod(Method method, Object[] args) {
        if (OBJECT_TOSTRING.equals(method)) {
            return this.invokeDescription();
        }
        if (OBJECT_EQUALS.equals(method)) {
            if (args[0] == null) {
                return false;
            }
            if (args[0] instanceof NSObject) {
                return this.invokeIsEqual(((NSObject)args[0]).id());
            }
            return false;
        }
        if (OCOBJECT_ID.equals(method)) {
            return this.ocInstance;
        }
        throw new IllegalArgumentException("Not a special method " + method);
    }

    private Object invokeDescription() {
        return this.sendOnThisOrMainThread(null, this.ocInstance, "description", String.class, new Object[0]);
    }

    private Object invokeIsEqual(ID another) {
        return this.sendOnThisOrMainThread(null, this.ocInstance, "isEqual:", Boolean.class, new Object[]{another});
    }

    private Object invokeCocoa(Method method, Object[] args) {
        Object[] marshalledArgs;
        Class<?> returnType;
        String selectorName = this.selectorNameFor(method);
        Object result = this.sendOnThisOrMainThread(method, this.ocInstance, selectorName, returnType = this.returnTypeFor(method), marshalledArgs = this.marshallArgsFor(method, args));
        if (null == result && method.getName().startsWith("init")) {
            this.releaseOnFinalize = false;
        }
        this.fillInReferences(args, marshalledArgs);
        if (result instanceof Pointer && method.getReturnType().equals(String.class)) {
            return ((Pointer)result).getString(0L);
        }
        return result;
    }

    private Object sendOnThisOrMainThread(Method method, final ID id, final String selectorName, final Class<?> returnType, final Object ... args) {
        if (this.callAcrossToMainThread(method)) {
            return Foundation.callOnMainThread(new Callable<Object>(){

                @Override
                public Object call() {
                    return Foundation.send(id, selectorName, returnType, args);
                }
            });
        }
        return Foundation.send(id, selectorName, returnType, args);
    }

    private void fillInReferences(Object[] args, Object[] marshalledArgs) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            Object original = args[i];
            Object marshalled = marshalledArgs[i];
            if (!(marshalled instanceof IDByReference)) continue;
            if (!(original instanceof NSObjectByReference)) {
                logging.error("Bad marshalling");
                continue;
            }
            ((NSObjectByReference)((Object)original)).setObject(Rococoa.wrap(((IDByReference)((Object)marshalled)).getValue(), NSObject.class));
        }
    }

    private Class<?> returnTypeFor(Method method) {
        ReturnType annotation = method.getAnnotation(ReturnType.class);
        if (annotation == null) {
            return method.getReturnType();
        }
        return annotation.value();
    }

    private Object[] marshallArgsFor(Method method, Object[] args) {
        if (args == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < args.length; ++i) {
            Object marshalled = this.marshall(args[i]);
            if (marshalled instanceof Object[]) {
                result.addAll(Arrays.asList((Object[])marshalled));
                continue;
            }
            result.add(marshalled);
        }
        return result.toArray(new Object[result.size()]);
    }

    private Object marshall(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof NSObjectByReference) {
            return new IDByReference();
        }
        return arg;
    }

    private String selectorNameFor(Method method) {
        String methodName = method.getName();
        if (methodName.endsWith("_")) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        if (method.getParameterTypes().length == 0) {
            return methodName;
        }
        String[] parts = methodName.split("_");
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            result.append(part).append(":");
        }
        return result.toString();
    }

    private boolean callAcrossToMainThread() {
        return this.callAcrossToMainThread(null);
    }

    private boolean callAcrossToMainThread(Method m) {
        return (this.invokeOnMainThread || this.shouldInvokeMethodsOnMainThread(m)) && !Foundation.isMainThread();
    }

    static {
        try {
            OBJECT_TOSTRING = Object.class.getMethod("toString", new Class[0]);
            OBJECT_HASHCODE = Object.class.getMethod("hashCode", new Class[0]);
            OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
            OCOBJECT_ID = NSObject.class.getMethod("id", new Class[0]);
        }
        catch (Exception x) {
            throw new RococoaException("Error retrieving method", x);
        }
    }
}

