/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.BrowserComparator;
import ch.cyberduck.core.NaturalOrderComparator;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Status;
import ch.cyberduck.ui.cocoa.CDAbstractTableDelegate;
import ch.cyberduck.ui.cocoa.CDDateFormatter;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDAbstractPathTableDelegate
extends CDAbstractTableDelegate<Path> {
    private static Logger log = Logger.getLogger(CDAbstractTableDelegate.class);

    @Override
    public String tooltip(Path p) {
        return p.getAbsolute() + "\n" + Status.getSizeAsString((double)p.attributes.getSize()) + "\n" + CDDateFormatter.getLongFormat(p.attributes.getModificationDate());
    }

    @Override
    public Comparator<Path> getSortingComparator() {
        boolean ascending = this.isSortedAscending();
        String identifier = this.selectedColumnIdentifier();
        if (identifier.equals("ICON") || identifier.equals("KIND")) {
            return new FileTypeComparator(ascending);
        }
        if (identifier.equals("FILENAME")) {
            return new FilenameComparator(ascending);
        }
        if (identifier.equals("SIZE")) {
            return new SizeComparator(ascending);
        }
        if (identifier.equals("MODIFIED")) {
            return new TimestampComparator(ascending);
        }
        if (identifier.equals("OWNER")) {
            return new OwnerComparator(ascending);
        }
        if (identifier.equals("GROUP")) {
            return new GroupComparator(ascending);
        }
        if (identifier.equals("PERMISSIONS")) {
            return new PermissionsComparator(ascending);
        }
        log.error((Object)("Unknown column identifier:" + identifier));
        return new NullComparator();
    }

    private static class PermissionsComparator
    extends BrowserComparator {
        public PermissionsComparator(boolean ascending) {
            super(ascending);
        }

        public int compare(Path p1, Path p2) {
            Permission perm2;
            Permission perm1 = p1.attributes.getPermission();
            if (null == perm1) {
                perm1 = Permission.EMPTY;
            }
            if (null == (perm2 = p2.attributes.getPermission())) {
                perm2 = Permission.EMPTY;
            }
            if (perm1.getOctalNumber() > perm2.getOctalNumber()) {
                return this.ascending ? 1 : -1;
            }
            if (perm1.getOctalNumber() < perm2.getOctalNumber()) {
                return this.ascending ? -1 : 1;
            }
            return 0;
        }

        public String toString() {
            return "PERMISSIONS";
        }
    }

    private static class GroupComparator
    extends BrowserComparator {
        public GroupComparator(boolean ascending) {
            super(ascending);
        }

        public int compare(Path p1, Path p2) {
            if (this.ascending) {
                return p1.attributes.getGroup().compareToIgnoreCase(p2.attributes.getGroup());
            }
            return -p1.attributes.getGroup().compareToIgnoreCase(p2.attributes.getGroup());
        }

        public String toString() {
            return "GROUP";
        }
    }

    private static class OwnerComparator
    extends BrowserComparator {
        public OwnerComparator(boolean ascending) {
            super(ascending);
        }

        public int compare(Path p1, Path p2) {
            if (this.ascending) {
                return p1.attributes.getOwner().compareToIgnoreCase(p2.attributes.getOwner());
            }
            return -p1.attributes.getOwner().compareToIgnoreCase(p2.attributes.getOwner());
        }

        public String toString() {
            return "OWNER";
        }
    }

    private static class TimestampComparator
    extends BrowserComparator {
        public TimestampComparator(boolean ascending) {
            super(ascending);
        }

        public int compare(Path p1, Path p2) {
            long d1 = p1.attributes.getModificationDate();
            if (-1L == d1) {
                return 0;
            }
            long d2 = p2.attributes.getModificationDate();
            if (-1L == d2) {
                return 0;
            }
            if (this.ascending) {
                return d1 > d2 ? 1 : -1;
            }
            return d1 > d2 ? -1 : 1;
        }

        public String toString() {
            return "MODIFIED";
        }
    }

    private static class SizeComparator
    extends BrowserComparator {
        public SizeComparator(boolean ascending) {
            super(ascending);
        }

        public int compare(Path p1, Path p2) {
            if (p1.attributes.getSize() > p2.attributes.getSize()) {
                return this.ascending ? 1 : -1;
            }
            if (p1.attributes.getSize() < p2.attributes.getSize()) {
                return this.ascending ? -1 : 1;
            }
            return 0;
        }

        public String toString() {
            return "SIZE";
        }
    }

    private static class FilenameComparator
    extends BrowserComparator {
        private Comparator<String> impl = new NaturalOrderComparator();

        public FilenameComparator(boolean ascending) {
            super(ascending);
        }

        public int compare(Path p1, Path p2) {
            if (this.ascending) {
                return this.impl.compare(p1.getName(), p2.getName());
            }
            return -this.impl.compare(p1.getName(), p2.getName());
        }

        public String toString() {
            return "FILENAME";
        }
    }

    private static class FileTypeComparator
    extends BrowserComparator {
        private Collator impl = Collator.getInstance(Locale.getDefault());

        public FileTypeComparator(boolean ascending) {
            super(ascending);
        }

        public int compare(Path p1, Path p2) {
            if (p1.attributes.isDirectory() && p2.attributes.isDirectory() || p1.attributes.isFile() && p2.attributes.isFile()) {
                if (this.ascending) {
                    return this.impl.compare(p1.kind(), p2.kind());
                }
                return -this.impl.compare(p1.kind(), p2.kind());
            }
            if (p1.attributes.isFile()) {
                return this.ascending ? 1 : -1;
            }
            return this.ascending ? -1 : 1;
        }

        public String toString() {
            return "ICON";
        }
    }
}

