/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostCollection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDMainController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextFieldCell;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSData;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSFileManager;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.util.HyperlinkAttributedStringFactory;
import com.enterprisedt.net.ftp.FTPConnectMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;

public class CDBookmarkController
extends CDWindowController {
    private static Logger log = Logger.getLogger(CDBookmarkController.class);
    private NSPopUpButton protocolPopup;
    private NSPopUpButton encodingPopup;
    private NSTextField nicknameField;
    private NSTextField hostField;
    private NSButton alertIcon;
    private NSTextField portField;
    private NSTextField pathField;
    private NSTextField urlField;
    private NSTextField usernameField;
    private NSTextField webURLField;
    private NSButton webUrlImage;
    private NSImage favicon;
    private NSTextView commentField;
    protected static final String AUTO = Locale.localizedString((String)"Auto");
    private NSPopUpButton timezonePopup;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String TIMEZONE_ID_PREFIXES = "^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific)/.*";
    private NSPopUpButton connectmodePopup;
    private static final String CONNECTMODE_ACTIVE = Locale.localizedString((String)"Active");
    private static final String CONNECTMODE_PASSIVE = Locale.localizedString((String)"Passive");
    private NSPopUpButton transferPopup;
    private static final String TRANSFER_NEWCONNECTION = Locale.localizedString((String)"Open new connection");
    private static final String TRANSFER_BROWSERCONNECTION = Locale.localizedString((String)"Use browser connection");
    private NSPopUpButton downloadPathPopup;
    private static final String CHOOSE = Locale.localizedString((String)"Choose") + "...";
    private NSOpenPanel downloadPathPanel;
    private NSButton toggleOptionsButton;
    private Host host;
    private final AbstractCollectionListener<Host> bookmarkCollectionListener = new AbstractCollectionListener<Host>(){

        public void collectionItemRemoved(Host item) {
            NSWindow window;
            if (item.equals((Object)CDBookmarkController.this.host) && null != (window = CDBookmarkController.this.window())) {
                window.close();
            }
        }
    };
    private NSTextField pkLabel;
    private NSButton pkCheckbox;
    private NSOpenPanel publicKeyPanel;

    public void setProtocolPopup(NSPopUpButton protocolPopup) {
        Protocol[] protocols;
        this.protocolPopup = protocolPopup;
        this.protocolPopup.setEnabled(true);
        this.protocolPopup.setTarget(this.id());
        this.protocolPopup.setAction(Foundation.selector("protocolSelectionChanged:"));
        this.protocolPopup.removeAllItems();
        for (Protocol protocol : protocols = Protocol.getKnownProtocols()) {
            String title = protocol.getDescription();
            this.protocolPopup.addItemWithTitle(title);
            NSMenuItem item = this.protocolPopup.itemWithTitle(title);
            item.setRepresentedObject(protocol.getIdentifier());
            item.setImage(CDIconCache.iconNamed(protocol.icon(), 16));
        }
    }

    public void protocolSelectionChanged(NSPopUpButton sender) {
        String member;
        log.debug((Object)("protocolSelectionChanged:" + sender));
        Protocol selected = Protocol.forName((String)this.protocolPopup.selectedItem().representedObject());
        this.host.setPort(selected.getDefaultPort());
        if (this.host.getProtocol().getDefaultHostname().equals(this.host.getHostname())) {
            this.host.setHostname(selected.getDefaultHostname());
        }
        if (!selected.isWebUrlConfigurable()) {
            this.host.setWebURL(null);
        }
        if (selected.equals((Object)Protocol.IDISK) && StringUtils.isNotEmpty((String)(member = Preferences.instance().getProperty("iToolsMember")))) {
            this.host.getCredentials().setUsername(member);
            this.host.setDefaultPath("/" + member);
        }
        this.host.setProtocol(selected);
        this.itemChanged();
        this.init();
        this.reachable();
    }

    public void setEncodingPopup(NSPopUpButton encodingPopup) {
        this.encodingPopup = encodingPopup;
        this.encodingPopup.setEnabled(true);
        this.encodingPopup.removeAllItems();
        this.encodingPopup.addItemWithTitle("Default");
        this.encodingPopup.menu().addItem(NSMenuItem.separatorItem());
        this.encodingPopup.addItemsWithTitles(NSArray.arrayWithObjects(CDMainController.availableCharsets()));
        if (null == this.host.getEncoding()) {
            this.encodingPopup.selectItemWithTitle("Default");
        } else {
            this.encodingPopup.selectItemWithTitle(this.host.getEncoding());
        }
        this.encodingPopup.setTarget(this.id());
        Selector action = Foundation.selector("encodingSelectionChanged:");
        this.encodingPopup.setAction(action);
    }

    public void encodingSelectionChanged(NSPopUpButton sender) {
        log.debug((Object)("encodingSelectionChanged:" + sender));
        if (sender.selectedItem().title().equals("Default")) {
            this.host.setEncoding(null);
        } else {
            this.host.setEncoding(sender.selectedItem().title());
        }
        this.itemChanged();
    }

    public void setNicknameField(NSTextField nicknameField) {
        this.nicknameField = nicknameField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("nicknameInputDidChange:"), "NSControlTextDidChangeNotification", this.nicknameField);
    }

    public void setHostField(NSTextField hostField) {
        this.hostField = hostField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("hostFieldDidChange:"), "NSControlTextDidChangeNotification", this.hostField);
    }

    public void setAlertIcon(NSButton alertIcon) {
        this.alertIcon = alertIcon;
        this.alertIcon.setEnabled(false);
        this.alertIcon.setImage(null);
        this.alertIcon.setTarget(this.id());
        this.alertIcon.setAction(Foundation.selector("launchNetworkAssistant:"));
    }

    public void launchNetworkAssistant(NSButton sender) {
        this.host.diagnose();
    }

    public void setPortField(NSTextField portField) {
        this.portField = portField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("portInputDidEndEditing:"), "NSControlTextDidChangeNotification", this.portField);
    }

    public void setPathField(NSTextField pathField) {
        this.pathField = pathField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("pathInputDidChange:"), "NSControlTextDidChangeNotification", this.pathField);
    }

    public void setUrlField(NSTextField urlField) {
        this.urlField = urlField;
        this.urlField.setAllowsEditingTextAttributes(true);
        this.urlField.setSelectable(true);
    }

    public void setUsernameField(NSTextField usernameField) {
        this.usernameField = usernameField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("usernameInputDidChange:"), "NSControlTextDidChangeNotification", this.usernameField);
    }

    public void setWebURLField(NSTextField webURLField) {
        this.webURLField = webURLField;
        NSTextFieldCell cell = this.webURLField.cell();
        cell.setPlaceholderString(this.host.getDefaultWebURL());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("webURLInputDidChange:"), "NSControlTextDidChangeNotification", this.webURLField);
    }

    public void setWebUrlImage(NSButton b) {
        this.webUrlImage = b;
        this.webUrlImage.setTarget(this.id());
        this.webUrlImage.setAction(Foundation.selector("openWebUrl:"));
        this.webUrlImage.setImage(CDIconCache.iconNamed("site", 16));
    }

    private void updateFavicon() {
        if (Preferences.instance().getBoolean("bookmark.favicon.download")) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){

                public void run() {
                    NSData data = NSData.dataWithContentsOfURL(NSURL.URLWithString(CDBookmarkController.this.host.getWebURL() + "/favicon.ico"));
                    if (null == data) {
                        return;
                    }
                    CDBookmarkController.this.favicon = CDIconCache.instance().convert(NSImage.imageWithData(data), 16);
                }

                public void cleanup() {
                    if (null == CDBookmarkController.this.favicon) {
                        return;
                    }
                    CDBookmarkController.this.webUrlImage.setImage(CDBookmarkController.this.favicon);
                }
            });
        }
    }

    public void openWebUrl(NSButton sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(this.host.getWebURL()));
    }

    public void setCommentField(NSTextView commentField) {
        this.commentField = commentField;
        this.commentField.setFont(NSFont.userFixedPitchFontOfSize(11.0));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("commentInputDidChange:"), "NSTextDidChangeNotification", this.commentField);
    }

    public void setTimezonePopup(NSPopUpButton timezonePopup) {
        this.timezonePopup = timezonePopup;
        this.timezonePopup.setTarget(this.id());
        this.timezonePopup.setAction(Foundation.selector("timezonePopupClicked:"));
        this.timezonePopup.removeAllItems();
        this.timezonePopup.addItemWithTitle(UTC.getID());
        this.timezonePopup.menu().addItem(NSMenuItem.separatorItem());
        List<String> timezones = Arrays.asList(TimeZone.getAvailableIDs());
        Collections.sort(timezones, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return TimeZone.getTimeZone(o1).getID().compareTo(TimeZone.getTimeZone(o2).getID());
            }
        });
        for (String tz : timezones) {
            if (!tz.matches(TIMEZONE_ID_PREFIXES)) continue;
            this.timezonePopup.addItemWithTitle(TimeZone.getTimeZone(tz).getID());
        }
    }

    public void timezonePopupClicked(NSPopUpButton sender) {
        String selected = sender.selectedItem().title();
        if (selected.equals(AUTO)) {
            this.host.setTimezone(null);
        } else {
            String[] ids;
            for (String id : ids = TimeZone.getAvailableIDs()) {
                TimeZone tz = TimeZone.getTimeZone(id);
                if (!tz.getID().equals(selected)) continue;
                this.host.setTimezone(tz);
                break;
            }
        }
        this.itemChanged();
    }

    public void setConnectmodePopup(NSPopUpButton connectmodePopup) {
        this.connectmodePopup = connectmodePopup;
        this.connectmodePopup.setTarget(this.id());
        this.connectmodePopup.setAction(Foundation.selector("connectmodePopupClicked:"));
        this.connectmodePopup.removeAllItems();
        this.connectmodePopup.addItemWithTitle("Default");
        this.connectmodePopup.menu().addItem(NSMenuItem.separatorItem());
        this.connectmodePopup.addItemWithTitle(CONNECTMODE_ACTIVE);
        this.connectmodePopup.addItemWithTitle(CONNECTMODE_PASSIVE);
    }

    public void connectmodePopupClicked(NSPopUpButton sender) {
        if (sender.selectedItem().title().equals("Default")) {
            this.host.setFTPConnectMode(null);
        } else if (sender.selectedItem().title().equals(CONNECTMODE_ACTIVE)) {
            this.host.setFTPConnectMode(FTPConnectMode.ACTIVE);
        } else if (sender.selectedItem().title().equals(CONNECTMODE_PASSIVE)) {
            this.host.setFTPConnectMode(FTPConnectMode.PASV);
        }
        this.itemChanged();
    }

    public void setTransferPopup(NSPopUpButton transferPopup) {
        this.transferPopup = transferPopup;
        this.transferPopup.setTarget(this.id());
        this.transferPopup.setAction(Foundation.selector("transferPopupClicked:"));
        this.transferPopup.removeAllItems();
        this.transferPopup.addItemWithTitle("Default");
        this.transferPopup.menu().addItem(NSMenuItem.separatorItem());
        this.transferPopup.addItemWithTitle(TRANSFER_NEWCONNECTION);
        this.transferPopup.addItemWithTitle(TRANSFER_BROWSERCONNECTION);
    }

    public void transferPopupClicked(NSPopUpButton sender) {
        if (sender.selectedItem().title().equals("Default")) {
            this.host.setMaxConnections(null);
        } else if (sender.selectedItem().title().equals(TRANSFER_BROWSERCONNECTION)) {
            this.host.setMaxConnections(Integer.valueOf(1));
        } else if (sender.selectedItem().title().equals(TRANSFER_NEWCONNECTION)) {
            this.host.setMaxConnections(Integer.valueOf(-1));
        }
        this.itemChanged();
    }

    public void setDownloadPathPopup(NSPopUpButton downloadPathPopup) {
        this.downloadPathPopup = downloadPathPopup;
        this.downloadPathPopup.setTarget(this.id());
        Selector action = Foundation.selector("downloadPathPopupClicked:");
        this.downloadPathPopup.setAction(action);
        this.downloadPathPopup.removeAllItems();
        this.addDownloadPath(action, this.host.getDownloadFolder());
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~/Desktop"));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~"));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~/Downloads"));
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.downloadPathPopup.menu().addItemWithTitle_action_keyEquivalent(CHOOSE, action, "");
        this.downloadPathPopup.itemAtIndex(this.downloadPathPopup.numberOfItems() - 1).setTarget(this.id());
    }

    private void addDownloadPath(Selector action, Local f) {
        if (f.exists()) {
            this.downloadPathPopup.menu().addItemWithTitle_action_keyEquivalent(NSFileManager.defaultManager().displayNameAtPath(f.getAbsolute()), action, "");
            this.downloadPathPopup.itemAtIndex(this.downloadPathPopup.numberOfItems() - 1).setTarget(this.id());
            this.downloadPathPopup.itemAtIndex(this.downloadPathPopup.numberOfItems() - 1).setImage(CDIconCache.instance().iconForPath(f, (Integer)16));
            this.downloadPathPopup.itemAtIndex(this.downloadPathPopup.numberOfItems() - 1).setRepresentedObject(f.getAbsolute());
            if (this.host.getDownloadFolder().equals((Object)f)) {
                this.downloadPathPopup.selectItemAtIndex(this.downloadPathPopup.numberOfItems() - 1);
            }
        }
    }

    public void downloadPathPopupClicked(NSMenuItem sender) {
        if (sender.title().equals(CHOOSE)) {
            this.downloadPathPanel = NSOpenPanel.openPanel();
            this.downloadPathPanel.setCanChooseFiles(false);
            this.downloadPathPanel.setCanChooseDirectories(true);
            this.downloadPathPanel.setAllowsMultipleSelection(false);
            this.downloadPathPanel.setCanCreateDirectories(true);
            this.downloadPathPanel.beginSheetForDirectory(null, null, this.window, this.id(), Foundation.selector("downloadPathPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            this.host.setDownloadFolder(sender.representedObject());
            this.itemChanged();
        }
    }

    public void downloadPathPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        if (returncode == 1) {
            NSArray selected = sheet.filenames();
            if (selected.lastObject() != null) {
                this.host.setDownloadFolder(selected.lastObject().toString());
            }
        } else {
            this.host.setDownloadFolder(null);
        }
        this.downloadPathPopup.itemAtIndex(0).setTitle(NSFileManager.defaultManager().displayNameAtPath(this.host.getDownloadFolder().getAbsolute()));
        this.downloadPathPopup.itemAtIndex(0).setRepresentedObject(this.host.getDownloadFolder().getAbsolute());
        this.downloadPathPopup.itemAtIndex(0).setImage(CDIconCache.instance().iconForPath(this.host.getDownloadFolder(), (Integer)16));
        this.downloadPathPopup.selectItemAtIndex(0);
        this.downloadPathPanel = null;
        this.itemChanged();
    }

    public void setToggleOptionsButton(NSButton toggleOptionsButton) {
        this.toggleOptionsButton = toggleOptionsButton;
    }

    private CDBookmarkController(Host host) {
        this.host = host;
        HostCollection.defaultCollection().addListener(this.bookmarkCollectionListener);
        this.loadBundle();
    }

    protected void invalidate() {
        Preferences.instance().setProperty("bookmark.toggle.options", this.toggleOptionsButton.state());
        HostCollection.defaultCollection().removeListener(this.bookmarkCollectionListener);
        super.invalidate();
    }

    protected String getBundleName() {
        return "Bookmark";
    }

    public void awakeFromNib() {
        this.cascade();
        this.init();
        this.setState(this.toggleOptionsButton, Preferences.instance().getBoolean("bookmark.toggle.options"));
        this.reachable();
        this.updateFavicon();
        super.awakeFromNib();
    }

    public void setPkLabel(NSTextField pkLabel) {
        this.pkLabel = pkLabel;
    }

    public void setPkCheckbox(NSButton pkCheckbox) {
        this.pkCheckbox = pkCheckbox;
        this.pkCheckbox.setTarget(this.id());
        this.pkCheckbox.setAction(Foundation.selector("pkCheckboxSelectionChanged:"));
    }

    public void pkCheckboxSelectionChanged(NSButton sender) {
        log.debug((Object)"pkCheckboxSelectionChanged");
        if (this.pkLabel.stringValue().equals(Locale.localizedString((String)"No Private Key selected"))) {
            this.publicKeyPanel = NSOpenPanel.openPanel();
            this.publicKeyPanel.setCanChooseDirectories(false);
            this.publicKeyPanel.setCanChooseFiles(true);
            this.publicKeyPanel.setAllowsMultipleSelection(false);
            this.publicKeyPanel.beginSheetForDirectory(LocalFactory.createLocal((String)"~/.ssh").getAbsolute(), null, this.window(), this.id(), Foundation.selector("pkSelectionPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            this.host.getCredentials().setIdentity(null);
            this.itemChanged();
        }
    }

    public void pkSelectionPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        log.debug((Object)"pkSelectionPanelDidEnd");
        if (returncode == 1) {
            NSObject next;
            NSArray selected = sheet.filenames();
            NSEnumerator enumerator = selected.objectEnumerator();
            while ((next = enumerator.nextObject()) != null) {
                this.host.getCredentials().setIdentity(LocalFactory.createLocal((String)next.toString()));
            }
        }
        if (returncode == 0) {
            this.host.getCredentials().setIdentity(null);
        }
        this.publicKeyPanel = null;
        this.itemChanged();
    }

    public void hostFieldDidChange(NSNotification sender) {
        String input = this.hostField.stringValue();
        if (Protocol.isURL((String)input)) {
            this.host.init(Host.parse((String)input).getAsDictionary());
        } else {
            this.host.setHostname(input);
        }
        this.itemChanged();
        this.init();
        this.reachable();
    }

    private void reachable() {
        if (StringUtils.isNotBlank((String)this.host.getHostname())) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){
                boolean reachable = false;

                public void run() {
                    this.reachable = CDBookmarkController.this.host.isReachable();
                }

                public void cleanup() {
                    CDBookmarkController.this.alertIcon.setEnabled(!this.reachable);
                    CDBookmarkController.this.alertIcon.setImage(this.reachable ? null : CDIconCache.iconNamed("alert.tiff"));
                }
            });
        } else {
            this.alertIcon.setImage(CDIconCache.iconNamed("alert.tiff"));
            this.alertIcon.setEnabled(false);
        }
    }

    public void portInputDidEndEditing(NSNotification sender) {
        try {
            this.host.setPort(Integer.parseInt(this.portField.stringValue()));
        }
        catch (NumberFormatException e) {
            this.host.setPort(-1);
        }
        this.itemChanged();
        this.init();
    }

    public void pathInputDidChange(NSNotification sender) {
        this.host.setDefaultPath(this.pathField.stringValue());
        this.itemChanged();
        this.init();
    }

    public void nicknameInputDidChange(NSNotification sender) {
        this.host.setNickname(this.nicknameField.stringValue());
        this.itemChanged();
    }

    public void usernameInputDidChange(NSNotification sender) {
        this.host.getCredentials().setUsername(this.usernameField.stringValue());
        this.itemChanged();
    }

    public void webURLInputDidChange(NSNotification sender) {
        this.host.setWebURL(this.webURLField.stringValue());
        this.updateFavicon();
        this.itemChanged();
    }

    public void commentInputDidChange(NSNotification sender) {
        this.host.setComment(this.commentField.textStorage().string());
        this.itemChanged();
    }

    private void itemChanged() {
        HostCollection.defaultCollection().collectionItemChanged((Object)this.host);
    }

    private void init() {
        this.window.setTitle(this.host.getNickname());
        this.updateField(this.hostField, this.host.getHostname());
        this.hostField.setEnabled(this.host.getProtocol().isHostnameConfigurable());
        this.updateField(this.nicknameField, this.host.getNickname());
        String url = StringUtils.isNotBlank((String)this.host.getDefaultPath()) ? this.host.toURL() + Path.normalize((String)this.host.getDefaultPath()) : this.host.toURL();
        this.urlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, TRUNCATE_MIDDLE_ATTRIBUTES), url));
        this.updateField(this.portField, String.valueOf(this.host.getPort()));
        this.portField.setEnabled(this.host.getProtocol().isHostnameConfigurable());
        this.updateField(this.pathField, this.host.getDefaultPath());
        this.updateField(this.usernameField, this.host.getCredentials().getUsername());
        NSTextFieldCell usernameCell = this.usernameField.cell();
        if (this.host.getProtocol().equals((Object)Protocol.S3)) {
            usernameCell.setPlaceholderString(Locale.localizedString((String)"Access Key ID", (String)"S3"));
        } else {
            usernameCell.setPlaceholderString("");
        }
        this.protocolPopup.selectItemWithTitle(this.host.getProtocol().getDescription());
        if (null == this.host.getMaxConnections()) {
            this.transferPopup.selectItemWithTitle("Default");
        } else {
            this.transferPopup.selectItemWithTitle(this.host.getMaxConnections() == 1 ? TRANSFER_BROWSERCONNECTION : TRANSFER_NEWCONNECTION);
        }
        this.connectmodePopup.setEnabled(this.host.getProtocol().equals((Object)Protocol.FTP) || this.host.getProtocol().equals((Object)Protocol.FTP_TLS));
        this.encodingPopup.setEnabled(this.host.getProtocol().equals((Object)Protocol.FTP) || this.host.getProtocol().equals((Object)Protocol.FTP_TLS) || this.host.getProtocol().equals((Object)Protocol.SFTP));
        if (this.host.getProtocol().equals((Object)Protocol.FTP) || this.host.getProtocol().equals((Object)Protocol.FTP_TLS)) {
            if (null == this.host.getFTPConnectMode()) {
                this.connectmodePopup.selectItemWithTitle("Default");
            } else if (this.host.getFTPConnectMode().equals(FTPConnectMode.PASV)) {
                this.connectmodePopup.selectItemWithTitle(CONNECTMODE_PASSIVE);
            } else if (this.host.getFTPConnectMode().equals(FTPConnectMode.ACTIVE)) {
                this.connectmodePopup.selectItemWithTitle(CONNECTMODE_ACTIVE);
            }
        }
        this.pkCheckbox.setEnabled(this.host.getProtocol().equals((Object)Protocol.SFTP));
        if (this.host.getCredentials().isPublicKeyAuthentication()) {
            this.pkCheckbox.setState(1);
            this.updateField(this.pkLabel, this.host.getCredentials().getIdentity().toURL());
        } else {
            this.pkCheckbox.setState(0);
            this.pkLabel.setStringValue(Locale.localizedString((String)"No Private Key selected"));
        }
        this.webURLField.setEnabled(this.host.getProtocol().isWebUrlConfigurable());
        this.webUrlImage.setToolTip(this.host.getWebURL());
        this.updateField(this.webURLField, this.host.getWebURL());
        this.updateField(this.commentField, this.host.getComment());
        boolean tzEnabled = this.host.getProtocol().equals((Object)Protocol.FTP) || this.host.getProtocol().equals((Object)Protocol.FTP_TLS);
        this.timezonePopup.setEnabled(tzEnabled);
        if (null == this.host.getTimezone()) {
            if (tzEnabled) {
                if (Preferences.instance().getBoolean("ftp.timezone.auto")) {
                    this.timezonePopup.setTitle(AUTO);
                } else {
                    this.timezonePopup.setTitle(TimeZone.getTimeZone(Preferences.instance().getProperty("ftp.timezone.default")).getID());
                }
            } else {
                this.timezonePopup.setTitle(UTC.getID());
            }
        } else {
            this.timezonePopup.setTitle(this.host.getTimezone().getID());
        }
    }

    public static class Factory {
        private static final Map<Host, CDBookmarkController> open = new HashMap<Host, CDBookmarkController>();

        public static CDBookmarkController create(final Host host) {
            if (open.containsKey(host)) {
                return open.get(host);
            }
            CDBookmarkController c = new CDBookmarkController(host){

                public void windowWillClose(NSNotification notification) {
                    super.windowWillClose(notification);
                    open.remove(host);
                }
            };
            open.put(host, c);
            return c;
        }
    }
}

