/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDBrowserTableDataSource;
import ch.cyberduck.ui.cocoa.PathPasteboard;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.model.CDPathReference;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDBrowserOutlineViewModel
extends CDBrowserTableDataSource
implements NSOutlineView.DataSource {
    protected static Logger log = Logger.getLogger(CDBrowserOutlineViewModel.class);

    public CDBrowserOutlineViewModel(CDBrowserController controller) {
        super(controller);
    }

    @Override
    public int indexOf(NSView tableView, Path p) {
        return ((NSOutlineView)tableView).rowForItem((NSObject)p.getReference().unique()).intValue();
    }

    @Override
    public boolean contains(NSView tableView, Path p) {
        return this.indexOf(tableView, p) != -1;
    }

    protected AttributedList<Path> childs(CDPathReference path) {
        Path lookup = this.controller.lookup(path);
        if (null == lookup) {
            return AttributedList.emptyList();
        }
        return super.childs(lookup);
    }

    @Override
    public boolean outlineView_isItemExpandable(NSOutlineView view, NSObject item) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("outlineViewIsItemExpandable:" + item));
        }
        if (null == item) {
            return false;
        }
        Path path = this.controller.lookup(new CDPathReference(item));
        if (null == path) {
            return false;
        }
        return path.attributes.isDirectory();
    }

    @Override
    public NSInteger outlineView_numberOfChildrenOfItem(NSOutlineView view, NSObject item) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"outlineView_numberOfChildrenOfItem:");
        }
        if (this.controller.isMounted()) {
            if (null == item) {
                return new NSInteger(this.childs(this.controller.workdir()).size());
            }
            NSEvent event = NSApplication.sharedApplication().currentEvent();
            if (event != null) {
                log.debug((Object)("Event:" + event.type()));
                if (6 == event.type()) {
                    int draggingColumn = view.columnAtPoint(view.convertPoint_fromView(event.locationInWindow(), null)).intValue();
                    if (draggingColumn != 0) {
                        log.debug((Object)("Returning 0 to #outlineViewNumberOfChildrenOfItem for column:" + draggingColumn));
                        return new NSInteger(0L);
                    }
                    if (!Preferences.instance().getBoolean("browser.view.autoexpand")) {
                        log.debug((Object)"Returning 0 to #outlineViewNumberOfChildrenOfItem while dragging because browser.view.autoexpand == false");
                        return new NSInteger(0L);
                    }
                }
            }
            return new NSInteger(this.childs(new CDPathReference(item)).size());
        }
        return new NSInteger(0L);
    }

    @Override
    public NSObject outlineView_child_ofItem(NSOutlineView outlineView, NSInteger index, NSObject item) {
        Path path = null == item ? this.controller.workdir() : this.controller.lookup(new CDPathReference(item));
        if (null == path) {
            return null;
        }
        AttributedList<Path> childs = this.childs(path);
        if (index.intValue() >= childs.size()) {
            log.warn((Object)("Index " + (Object)((Object)index) + " out of bound for " + item));
            return null;
        }
        return (NSObject)((Path)childs.get(index.intValue())).getReference().unique();
    }

    @Override
    public void outlineView_setObjectValue_forTableColumn_byItem(NSOutlineView outlineView, NSObject value, NSTableColumn tableColumn, NSObject item) {
        super.setObjectValueForItem(this.controller.lookup(new CDPathReference(item)), value, tableColumn.identifier());
    }

    @Override
    public NSObject outlineView_objectValueForTableColumn_byItem(NSOutlineView outlineView, NSTableColumn tableColumn, NSObject item) {
        if (null == item) {
            return null;
        }
        return super.objectValueForItem(this.controller.lookup(new CDPathReference(item)), tableColumn.identifier());
    }

    @Override
    public NSUInteger outlineView_validateDrop_proposedItem_proposedChildIndex(NSOutlineView outlineView, NSDraggingInfo draggingInfo, NSObject item, NSInteger row) {
        Path destination = null;
        if (this.controller.isMounted()) {
            if (null != item) {
                destination = this.controller.lookup(new CDPathReference(item));
            }
            if (!PathPasteboard.getPasteboard(this.controller.getSession().getHost()).isEmpty() || draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null) {
                if (null != destination) {
                    int draggingColumn = outlineView.columnAtPoint(draggingInfo.draggingLocation()).intValue();
                    if (0 == draggingColumn && destination.attributes.isDirectory()) {
                        outlineView.setDropItem((NSObject)destination.getReference().unique(), NSOutlineView.NSOutlineViewDropOnItemIndex);
                        return super.validateDrop(outlineView, destination, row, draggingInfo);
                    }
                    outlineView.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
                    return super.validateDrop(outlineView, this.controller.workdir(), row, draggingInfo);
                }
                outlineView.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
                return super.validateDrop(outlineView, this.controller.workdir(), row, draggingInfo);
            }
        }
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null) {
            outlineView.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
        }
        return super.validateDrop(outlineView, destination, row, draggingInfo);
    }

    @Override
    public boolean outlineView_acceptDrop_item_childIndex(NSOutlineView outlineView, NSDraggingInfo info, NSObject item, NSInteger row) {
        Path destination = null;
        if (this.controller.isMounted()) {
            destination = null == item ? this.controller.workdir() : this.controller.lookup(new CDPathReference(item));
        }
        return super.acceptDrop(outlineView, destination, info);
    }

    @Override
    public NSArray outlineView_namesOfPromisedFilesDroppedAtDestination_forDraggedItems(NSURL dropDestination, NSArray items) {
        return this.namesOfPromisedFilesDroppedAtDestination(dropDestination);
    }

    @Override
    public boolean outlineView_writeItems_toPasteboard(NSOutlineView outlineView, NSArray items, NSPasteboard pboard) {
        return super.writeItemsToPasteBoard(outlineView, items, pboard);
    }
}

