/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.AttributeCache;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDController;
import ch.cyberduck.ui.cocoa.CDDateFormatter;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDTableCellAttributes;
import ch.cyberduck.ui.cocoa.PathPasteboard;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSDraggingSource;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.model.CDPathReference;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDBrowserTableDataSource
extends CDController
implements NSDraggingSource {
    protected static Logger log = Logger.getLogger(CDBrowserTableDataSource.class);
    public static final String ICON_COLUMN = "ICON";
    public static final String FILENAME_COLUMN = "FILENAME";
    public static final String SIZE_COLUMN = "SIZE";
    public static final String MODIFIED_COLUMN = "MODIFIED";
    public static final String OWNER_COLUMN = "OWNER";
    public static final String GROUP_COLUMN = "GROUP";
    public static final String PERMISSIONS_COLUMN = "PERMISSIONS";
    public static final String KIND_COLUMN = "KIND";
    protected static final String TYPEAHEAD_COLUMN = "TYPEAHEAD";
    protected static final String LOCAL_COLUMN = "LOCAL";
    private static final NSAttributedString UNKNOWN_STRING = NSAttributedString.attributedStringWithAttributes(Locale.localizedString((String)"Unknown"), CDTableCellAttributes.browserFontLeftAlignment());
    protected final List<Path> isLoadingListingInBackground = new Collection();
    protected CDBrowserController controller;
    private AttributeCache<Path> cache = new AttributeCache(Preferences.instance().getInteger("browser.model.cache.size"));

    public CDBrowserTableDataSource(CDBrowserController controller) {
        this.controller = controller;
    }

    @Override
    protected void invalidate() {
        this.cache.clear();
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributedList<Path> childs(final Path path) {
        List<Path> list = this.isLoadingListingInBackground;
        synchronized (list) {
            if (!this.isLoadingListingInBackground.contains(path)) {
                if (path.isCached()) {
                    return path.cache().get((AbstractPath)path, this.controller.getComparator(), this.controller.getFileFilter());
                }
                this.isLoadingListingInBackground.add(path);
                this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                    public void run() {
                        path.childs();
                    }

                    public String getActivity() {
                        return MessageFormat.format(Locale.localizedString((String)"Listing directory {0}", (String)"Status"), path.getName());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void cleanup() {
                        List<Path> list = CDBrowserTableDataSource.this.isLoadingListingInBackground;
                        synchronized (list) {
                            CDBrowserTableDataSource.this.isLoadingListingInBackground.remove(path);
                            if (path.isCached() && CDBrowserTableDataSource.this.isLoadingListingInBackground.isEmpty() && CDBrowserTableDataSource.this.controller.isConnected()) {
                                CDBrowserTableDataSource.this.cache.clear();
                                CDBrowserTableDataSource.this.controller.reloadData(true);
                            }
                        }
                    }
                });
            }
            log.warn((Object)("No cached listing for " + path.getName()));
            return path.cache().get((AbstractPath)path, this.controller.getComparator(), this.controller.getFileFilter());
        }
    }

    public int indexOf(NSView tableView, Path p) {
        return this.childs(this.controller.workdir()).indexOf((Object)p);
    }

    public boolean contains(NSView tableView, Path p) {
        return this.childs(this.controller.workdir()).contains((Object)p);
    }

    public void setObjectValueForItem(Path item, NSObject value, String identifier) {
        log.debug((Object)("setObjectValueForItem:" + item));
        if (identifier.equals(FILENAME_COLUMN) && StringUtils.isNotBlank((String)value.toString()) && !item.getName().equals(value.toString())) {
            Path renamed = PathFactory.createPath((Session)this.controller.workdir().getSession(), (String)item.getParent().getAbsolute(), (String)value.toString(), (int)item.attributes.getType());
            this.controller.renamePath(item, renamed);
        }
    }

    protected NSImage iconForPath(Path item) {
        return CDIconCache.instance().iconForPath(item, (Integer)16);
    }

    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached;
        if (log.isDebugEnabled()) {
            log.debug((Object)("objectValueForItem:" + item.getAbsolute()));
        }
        if (null == (cached = this.cache.get(item, identifier))) {
            if (identifier.equals(ICON_COLUMN)) {
                return this.cache.put(item, identifier, this.iconForPath(item));
            }
            if (identifier.equals(FILENAME_COLUMN)) {
                return this.cache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.getName(), CDTableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(SIZE_COLUMN)) {
                return this.cache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)item.attributes.getSize()), CDTableCellAttributes.browserFontRightAlignment()));
            }
            if (identifier.equals(MODIFIED_COLUMN)) {
                if (item.attributes.getModificationDate() != -1L) {
                    return this.cache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(CDDateFormatter.getShortFormat(item.attributes.getModificationDate()), CDTableCellAttributes.browserFontLeftAlignment()));
                }
                return this.cache.put(item, identifier, UNKNOWN_STRING);
            }
            if (identifier.equals(OWNER_COLUMN)) {
                return this.cache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.attributes.getOwner(), CDTableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(GROUP_COLUMN)) {
                return this.cache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.attributes.getGroup(), CDTableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(PERMISSIONS_COLUMN)) {
                Permission permission = item.attributes.getPermission();
                if (null == permission) {
                    return this.cache.put(item, identifier, UNKNOWN_STRING);
                }
                return this.cache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(permission.toString(), CDTableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(KIND_COLUMN)) {
                return this.cache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.kind(), CDTableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(TYPEAHEAD_COLUMN)) {
                return this.cache.put(item, identifier, NSString.stringWithString(item.getName()));
            }
            if (identifier.equals(LOCAL_COLUMN)) {
                return this.cache.put(item, identifier, NSString.stringWithString(item.getLocal().getAbsolute()));
            }
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return cached;
    }

    @Override
    public boolean ignoreModifierKeysWhileDragging() {
        return false;
    }

    @Override
    public NSUInteger draggingSourceOperationMaskForLocal(boolean local) {
        log.debug((Object)("draggingSourceOperationMaskForLocal:" + local));
        if (local) {
            return new NSUInteger(NSDraggingInfo.NSDragOperationMove.intValue() | NSDraggingInfo.NSDragOperationCopy.intValue());
        }
        return new NSUInteger(NSDraggingInfo.NSDragOperationCopy.intValue() | NSDraggingInfo.NSDragOperationDelete.intValue());
    }

    public boolean acceptDrop(NSTableView view, Path destination, NSDraggingInfo draggingInfo) {
        NSObject o;
        log.debug((Object)("acceptDrop:" + destination));
        if (this.controller.isMounted() && draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null) {
            NSObject o2 = draggingInfo.draggingPasteboard().propertyListForType("NSFilenamesPboardType");
            if (o2 != null) {
                NSArray elements = Rococoa.cast(o2, NSArray.class);
                Session session = this.controller.getTransferSession();
                Collection roots = new Collection();
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    Path p = PathFactory.createPath((Session)session, (String)destination.getAbsolute(), (Local)LocalFactory.createLocal((String)elements.objectAtIndex(new NSUInteger(i)).toString()));
                    roots.add(p);
                }
                UploadTransfer q = new UploadTransfer((List)roots);
                if (q.numberOfRoots() > 0) {
                    this.controller.transfer((Transfer)q, destination);
                }
                return true;
            }
            return false;
        }
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null && (o = draggingInfo.draggingPasteboard().propertyListForType("Apple URL pasteboard type")) != null) {
            NSArray elements = Rococoa.cast(o, NSArray.class);
            for (int i = 0; i < elements.count().intValue(); ++i) {
                if (!Protocol.isURL((String)elements.objectAtIndex(new NSUInteger(i)).toString())) continue;
                this.controller.mount(Host.parse((String)elements.objectAtIndex(new NSUInteger(i)).toString()));
                return true;
            }
            return false;
        }
        if (this.controller.isMounted()) {
            PathPasteboard<NSDictionary> pasteboard = PathPasteboard.getPasteboard(this.controller.getSession().getHost());
            if (!pasteboard.isEmpty()) {
                if ((draggingInfo.draggingSourceOperationMask().intValue() & NSDraggingInfo.NSDragOperationMove.intValue()) == NSDraggingInfo.NSDragOperationMove.intValue()) {
                    HashMap<Path, Path> files = new HashMap<Path, Path>();
                    for (Path next : pasteboard.getFiles(this.controller.getSession())) {
                        Path original = PathFactory.createPath((Session)this.controller.workdir().getSession(), (String)next.getAbsolute(), (int)next.attributes.getType());
                        Path renamed = PathFactory.createPath((Session)this.controller.workdir().getSession(), (String)destination.getAbsolute(), (String)original.getName(), (int)next.attributes.getType());
                        files.put(original, renamed);
                    }
                    pasteboard.clear();
                    this.controller.renamePaths(files);
                    return true;
                }
                if (draggingInfo.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                    HashMap<Path, Path> files = new HashMap<Path, Path>();
                    for (Path next : pasteboard.getFiles(this.controller.getSession())) {
                        Path copy = PathFactory.createPath((Session)this.controller.getSession(), (Object)next.getAsDictionary());
                        copy.setPath(destination.getAbsolute(), next.getName());
                        files.put(next, copy);
                    }
                    pasteboard.clear();
                    this.controller.duplicatePaths(files, false);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public NSUInteger validateDrop(NSTableView view, Path destination, NSInteger row, NSDraggingInfo info) {
        if (this.controller.isMounted() && info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null) {
            if (destination.attributes.isDirectory()) {
                this.setDropRowAndDropOperation(view, destination, row);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null) {
            NSObject o = info.draggingPasteboard().propertyListForType("Apple URL pasteboard type");
            if (o != null) {
                NSArray elements = Rococoa.cast(o, NSArray.class);
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    if (!Protocol.isURL((String)elements.objectAtIndex(new NSUInteger(i)).toString())) continue;
                    view.setDropRow(new NSInteger(-1L), NSTableView.NSTableViewDropOn);
                    return NSDraggingInfo.NSDragOperationCopy;
                }
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (this.controller.isMounted()) {
            if (PathPasteboard.getPasteboard(this.controller.getSession().getHost()).isEmpty()) {
                return NSDraggingInfo.NSDragOperationNone;
            }
            for (Path next : PathPasteboard.getPasteboard(this.controller.getSession().getHost()).getFiles(this.controller.getSession())) {
                if (destination.equals((Object)next)) {
                    return NSDraggingInfo.NSDragOperationNone;
                }
                if (next.attributes.isDirectory() && destination.isChild((AbstractPath)next)) {
                    return NSDraggingInfo.NSDragOperationNone;
                }
                if (!next.getParent().equals((Object)destination)) continue;
                return NSDraggingInfo.NSDragOperationNone;
            }
            log.debug((Object)("Operation Mask:" + info.draggingSourceOperationMask().intValue()));
            if (destination.attributes.isDirectory()) {
                this.setDropRowAndDropOperation(view, destination, row);
                if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                    return NSDraggingInfo.NSDragOperationCopy;
                }
                if (destination.isRenameSupported()) {
                    return NSDraggingInfo.NSDragOperationMove;
                }
            }
        }
        return NSDraggingInfo.NSDragOperationNone;
    }

    private void setDropRowAndDropOperation(NSTableView view, Path destination, NSInteger row) {
        if (destination.equals((Object)this.controller.workdir())) {
            log.debug((Object)"setDropRowAndDropOperation:-1");
            view.setDropRow(new NSInteger(-1L), NSTableView.NSTableViewDropOn);
        } else if (destination.attributes.isDirectory()) {
            log.debug((Object)("setDropRowAndDropOperation:" + row.intValue()));
            view.setDropRow(row, NSTableView.NSTableViewDropOn);
        }
    }

    public boolean writeItemsToPasteBoard(NSTableView view, NSArray items, NSPasteboard pboard) {
        log.debug((Object)"writeItemsToPasteBoard");
        if (this.controller.isMounted() && items.count().intValue() > 0) {
            NSMutableArray fileTypes = NSMutableArray.array();
            PathPasteboard<NSDictionary> pasteboard = PathPasteboard.getPasteboard(this.controller.getSession().getHost());
            for (int i = 0; i < items.count().intValue(); ++i) {
                Path path = this.controller.lookup(new CDPathReference(items.objectAtIndex(new NSUInteger(i))));
                if (null == path) continue;
                if (path.attributes.isFile()) {
                    if (StringUtils.isNotEmpty((String)path.getExtension())) {
                        fileTypes.addObject(NSString.stringWithString(path.getExtension()));
                    } else {
                        fileTypes.addObject(NSString.stringWithString("NSFileTypeRegular"));
                    }
                } else if (path.attributes.isDirectory()) {
                    fileTypes.addObject(NSString.stringWithString("'fldr'"));
                } else {
                    fileTypes.addObject(NSString.stringWithString("NSFileTypeUnknown"));
                }
                pasteboard.add(path.getAsDictionary());
            }
            NSEvent event = NSApplication.sharedApplication().currentEvent();
            if (event != null) {
                NSPoint dragPosition = view.convertPoint_fromView(event.locationInWindow(), null);
                NSRect imageRect = new NSRect(new NSPoint(dragPosition.x.doubleValue() - 16.0, dragPosition.y.doubleValue() - 16.0), new NSSize(32.0, 32.0));
                view.dragPromisedFilesOfTypes(fileTypes, imageRect, this.id(), true, event);
                return true;
            }
        }
        return false;
    }

    @Override
    public void draggedImage_beganAt(NSImage image, NSPoint point) {
        log.trace((Object)("draggedImage_beganAt:" + (Object)((Object)point)));
    }

    @Override
    public void draggedImage_endedAt_operation(NSImage image, NSPoint point, NSUInteger operation) {
        log.trace((Object)("draggedImage_endedAt_operation:" + (Object)((Object)operation)));
        PathPasteboard<NSDictionary> pasteboard = PathPasteboard.getPasteboard(this.controller.getSession().getHost());
        if (NSDraggingInfo.NSDragOperationDelete.intValue() == operation.intValue()) {
            List<Path> files = pasteboard.getFiles(this.controller.getSession());
            this.controller.deletePaths(files);
        }
        pasteboard.clear();
    }

    @Override
    public void draggedImage_movedTo(NSImage image, NSPoint point) {
        log.trace((Object)("draggedImage_movedTo:" + (Object)((Object)point)));
    }

    @Override
    public NSArray namesOfPromisedFilesDroppedAtDestination(NSURL dropDestination) {
        log.debug((Object)("namesOfPromisedFilesDroppedAtDestination:" + dropDestination));
        NSMutableArray promisedDragNames = NSMutableArray.array();
        if (null != dropDestination) {
            DownloadTransfer q;
            PathPasteboard<NSDictionary> pasteboard = PathPasteboard.getPasteboard(this.controller.getSession().getHost());
            List<Path> promisedPaths = pasteboard.getFiles(this.controller.getTransferSession());
            for (Path p : promisedPaths) {
                p.setLocal(LocalFactory.createLocal((String)dropDestination.path(), (String)p.getName()));
                promisedDragNames.addObject(NSString.stringWithString(p.getLocal().getName()));
            }
            if (promisedPaths.size() == 1) {
                if (promisedPaths.get((int)0).attributes.isFile()) {
                    promisedPaths.get(0).getLocal().touch();
                }
                if (promisedPaths.get((int)0).attributes.isDirectory()) {
                    promisedPaths.get(0).getLocal().mkdir();
                }
            }
            if ((q = new DownloadTransfer(promisedPaths)).numberOfRoots() > 0) {
                this.controller.transfer((Transfer)q);
            }
            pasteboard.clear();
        }
        return promisedDragNames;
    }
}

